/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resourceresolver.impl.mapping.BloomFilterUtils;
import org.apache.sling.resourceresolver.impl.mapping.MapConfigurationProvider;
import org.apache.sling.resourceresolver.impl.mapping.MapEntry;
import org.apache.sling.resourceresolver.impl.mapping.Mapping;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapEntries
implements EventHandler {
    public static final MapEntries EMPTY = new MapEntries();
    private static final String PROP_REG_EXP = "sling:match";
    public static final String PROP_REDIRECT_EXTERNAL = "sling:redirect";
    public static final String PROP_REDIRECT_EXTERNAL_STATUS = "sling:status";
    public static final String PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS = "sling:redirectStatus";
    public static final String PROP_VANITY_PATH = "sling:vanityPath";
    public static final String PROP_VANITY_ORDER = "sling:vanityOrder";
    private static final String VANITY_BLOOM_FILTER_NAME = "vanityBloomFilter.txt";
    private static final int VANITY_BLOOM_FILTER_MAX_ENTRIES = 10000000;
    private static final String GLOBAL_LIST_KEY = "*";
    public static final String DEFAULT_MAP_ROOT = "/etc/map";
    public static final int DEFAULT_DEFAULT_VANITY_PATH_REDIRECT_STATUS = 302;
    private static final String JCR_SYSTEM_PREFIX = "/jcr:system/";
    static final String ANY_SCHEME_HOST = "[^/]+/[^/]+";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MapConfigurationProvider factory;
    private volatile ResourceResolver resolver;
    private final String mapRoot;
    private Map<String, List<MapEntry>> resolveMapsMap;
    private Collection<MapEntry> mapMaps;
    private Map<String, List<String>> vanityTargets;
    private Map<String, Map<String, String>> aliasMap;
    private ServiceRegistration registration;
    private EventAdmin eventAdmin;
    private final ReentrantLock initializing = new ReentrantLock();
    private final boolean enabledVanityPaths;
    private final long maxCachedVanityPathEntries;
    private final int vanityBloomFilterMaxBytes;
    private final boolean enableOptimizeAliasResolution;
    private final boolean vanityPathPrecedence;
    private final List<MapConfigurationProvider.VanityPathConfig> vanityPathConfig;
    private final AtomicLong vanityCounter;
    private final File vanityBloomFilterFile;
    private byte[] vanityBloomFilter;
    private Timer timer;
    private boolean updateBloomFilterFile = false;

    private MapEntries() {
        this.factory = null;
        this.resolver = null;
        this.mapRoot = DEFAULT_MAP_ROOT;
        this.resolveMapsMap = Collections.singletonMap(GLOBAL_LIST_KEY, Collections.EMPTY_LIST);
        this.mapMaps = Collections.emptyList();
        this.vanityTargets = Collections.emptyMap();
        this.aliasMap = Collections.emptyMap();
        this.registration = null;
        this.eventAdmin = null;
        this.enabledVanityPaths = true;
        this.maxCachedVanityPathEntries = -1L;
        this.vanityBloomFilterMaxBytes = 0;
        this.enableOptimizeAliasResolution = true;
        this.vanityPathConfig = null;
        this.vanityPathPrecedence = false;
        this.vanityCounter = new AtomicLong(0L);
        this.vanityBloomFilterFile = null;
    }

    public MapEntries(MapConfigurationProvider factory, BundleContext bundleContext, EventAdmin eventAdmin) throws LoginException, IOException {
        this.resolver = factory.getAdministrativeResourceResolver(null);
        this.factory = factory;
        this.mapRoot = factory.getMapRoot();
        this.enabledVanityPaths = factory.isVanityPathEnabled();
        this.maxCachedVanityPathEntries = factory.getMaxCachedVanityPathEntries();
        this.vanityBloomFilterMaxBytes = factory.getVanityBloomFilterMaxBytes();
        this.vanityPathConfig = factory.getVanityPathConfig();
        this.enableOptimizeAliasResolution = factory.isOptimizeAliasResolutionEnabled();
        this.vanityPathPrecedence = factory.hasVanityPathPrecedence();
        this.eventAdmin = eventAdmin;
        this.resolveMapsMap = Collections.singletonMap(GLOBAL_LIST_KEY, Collections.EMPTY_LIST);
        this.mapMaps = Collections.emptyList();
        this.vanityTargets = Collections.emptyMap();
        this.aliasMap = Collections.emptyMap();
        this.doInit();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("event.topics", "org/apache/sling/api/resource/*");
        ((Dictionary)props).put("event.filter", MapEntries.createFilter(this.enabledVanityPaths));
        ((Dictionary)props).put("service.description", "Map Entries Observation");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.registration = bundleContext.registerService(EventHandler.class.getName(), (Object)this, props);
        this.vanityCounter = new AtomicLong(0L);
        this.vanityBloomFilterFile = bundleContext.getDataFile(VANITY_BLOOM_FILTER_NAME);
        this.initializeVanityPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInit() {
        this.initializing.lock();
        try {
            ResourceResolver resolver = this.resolver;
            MapConfigurationProvider factory = this.factory;
            if (resolver == null || factory == null) {
                return;
            }
            ConcurrentHashMap<String, List<MapEntry>> newResolveMapsMap = new ConcurrentHashMap<String, List<MapEntry>>();
            if (this.enableOptimizeAliasResolution) {
                Map<String, Map<String, String>> aliasMap = this.loadAliases(resolver);
                this.aliasMap = aliasMap;
            }
            this.resolveMapsMap = newResolveMapsMap;
            this.doUpdateConfiguration();
            this.sendChangeEvent();
        }
        catch (Exception e) {
            this.log.warn("doInit: Unexpected problem during initialization", (Throwable)e);
        }
        finally {
            this.initializing.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeVanityPaths() throws IOException {
        block9: {
            this.initializing.lock();
            try {
                if (!this.enabledVanityPaths) break block9;
                if (this.vanityBloomFilterFile == null) {
                    throw new RuntimeException("This platform does not have file system support");
                }
                boolean createVanityBloomFilter = false;
                if (!this.vanityBloomFilterFile.exists()) {
                    this.log.debug("creating bloom filter file {}", (Object)this.vanityBloomFilterFile.getAbsolutePath());
                    this.vanityBloomFilter = this.createVanityBloomFilter();
                    this.persistBloomFilter();
                    createVanityBloomFilter = true;
                } else {
                    this.vanityBloomFilter = new byte[(int)this.vanityBloomFilterFile.length()];
                    DataInputStream dis = new DataInputStream(new FileInputStream(this.vanityBloomFilterFile));
                    try {
                        dis.readFully(this.vanityBloomFilter);
                    }
                    finally {
                        dis.close();
                    }
                }
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new BloomFilterTask(), 60000L);
                Map<String, List<String>> vanityTargets = this.loadVanityPaths(this.resolver, this.resolveMapsMap, createVanityBloomFilter);
                this.vanityTargets = vanityTargets;
            }
            finally {
                this.initializing.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doNodeAdded(String path, boolean refreshed) {
        this.initializing.lock();
        boolean newRefreshed = refreshed;
        if (!newRefreshed) {
            this.resolver.refresh();
            newRefreshed = true;
        }
        try {
            Resource resource = this.resolver.getResource(path);
            ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
            if (props.containsKey((Object)PROP_VANITY_PATH)) {
                this.doAddVanity(path);
            }
            if (props.containsKey((Object)"sling:alias")) {
                this.doAddAlias(path);
            }
            if (path.startsWith(this.mapRoot)) {
                this.doUpdateConfiguration();
            }
            this.sendChangeEvent();
        }
        finally {
            this.initializing.unlock();
        }
        return newRefreshed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doAddAttributes(String path, String[] addedAttributes, boolean refreshed) {
        this.initializing.lock();
        boolean newRefreshed = refreshed;
        if (!newRefreshed) {
            this.resolver.refresh();
            newRefreshed = true;
        }
        try {
            for (String changedAttribute : addedAttributes) {
                if (PROP_VANITY_PATH.equals(changedAttribute)) {
                    this.doAddVanity(path);
                    continue;
                }
                if (PROP_VANITY_ORDER.equals(changedAttribute)) {
                    this.doUpdateVanityOrder(path, false);
                    continue;
                }
                if (PROP_REDIRECT_EXTERNAL.equals(changedAttribute) || PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS.equals(changedAttribute)) {
                    this.doUpdateRedirectStatus(path);
                    continue;
                }
                if (!"sling:alias".equals(changedAttribute) || !this.enableOptimizeAliasResolution) continue;
                this.doAddAlias(path);
            }
            if (path.startsWith(this.mapRoot)) {
                this.doUpdateConfiguration();
            }
            this.sendChangeEvent();
        }
        finally {
            this.initializing.unlock();
        }
        return newRefreshed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUpdateAttributes(String path, String[] changedAttributes, boolean refreshed) {
        this.initializing.lock();
        boolean newRefreshed = refreshed;
        if (!newRefreshed) {
            this.resolver.refresh();
            newRefreshed = true;
        }
        try {
            for (String changedAttribute : changedAttributes) {
                if (PROP_VANITY_PATH.equals(changedAttribute)) {
                    this.doUpdateVanity(path);
                    continue;
                }
                if (PROP_VANITY_ORDER.equals(changedAttribute)) {
                    this.doUpdateVanityOrder(path, false);
                    continue;
                }
                if (PROP_REDIRECT_EXTERNAL.equals(changedAttribute) || PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS.equals(changedAttribute)) {
                    this.doUpdateRedirectStatus(path);
                    continue;
                }
                if (!"sling:alias".equals(changedAttribute) || !this.enableOptimizeAliasResolution) continue;
                this.doRemoveAlias(path, false);
                this.doAddAlias(path);
                this.doUpdateAlias(path, false);
            }
            if (path.startsWith(this.mapRoot)) {
                this.doUpdateConfiguration();
            }
            this.sendChangeEvent();
        }
        finally {
            this.initializing.unlock();
        }
        return newRefreshed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRemoveAttributes(String path, String[] removedAttributes, boolean nodeDeletion, boolean refreshed) {
        this.initializing.lock();
        boolean newRefreshed = refreshed;
        if (!newRefreshed) {
            this.resolver.refresh();
            newRefreshed = true;
        }
        try {
            for (String changedAttribute : removedAttributes) {
                if (PROP_VANITY_PATH.equals(changedAttribute)) {
                    this.doRemoveVanity(path);
                    continue;
                }
                if (PROP_VANITY_ORDER.equals(changedAttribute)) {
                    this.doUpdateVanityOrder(path, true);
                    continue;
                }
                if (PROP_REDIRECT_EXTERNAL.equals(changedAttribute) || PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS.equals(changedAttribute)) {
                    this.doUpdateRedirectStatus(path);
                    continue;
                }
                if (!"sling:alias".equals(changedAttribute) || !this.enableOptimizeAliasResolution) continue;
                this.doRemoveAlias(path, nodeDeletion);
                this.doUpdateAlias(path, nodeDeletion);
            }
            if (path.startsWith(this.mapRoot)) {
                this.doUpdateConfiguration();
            }
            this.sendChangeEvent();
        }
        finally {
            this.initializing.unlock();
        }
        return newRefreshed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUpdateConfiguration(boolean refreshed) {
        this.initializing.lock();
        boolean newRefreshed = refreshed;
        if (!newRefreshed) {
            this.resolver.refresh();
            newRefreshed = true;
        }
        try {
            this.doUpdateConfiguration();
            this.sendChangeEvent();
        }
        finally {
            this.initializing.unlock();
        }
        return newRefreshed;
    }

    private void doUpdateConfiguration() {
        ArrayList<MapEntry> globalResolveMap = new ArrayList<MapEntry>();
        TreeMap<String, MapEntry> newMapMaps = new TreeMap<String, MapEntry>();
        this.loadResolverMap(this.resolver, globalResolveMap, newMapMaps);
        this.loadConfiguration(this.factory, globalResolveMap);
        this.loadMapConfiguration(this.factory, newMapMaps);
        Collections.sort(globalResolveMap);
        this.resolveMapsMap.put(GLOBAL_LIST_KEY, globalResolveMap);
        this.mapMaps = Collections.unmodifiableSet(new TreeSet(newMapMaps.values()));
    }

    private void doAddVanity(String path) {
        Resource resource = this.resolver.getResource(path);
        if (this.maxCachedVanityPathEntries < this.vanityCounter.longValue()) {
            this.loadVanityPath(resource, this.resolveMapsMap, this.vanityTargets, true, true);
            this.vanityCounter.incrementAndGet();
        } else {
            this.loadVanityPath(resource, this.resolveMapsMap, this.vanityTargets, false, true);
        }
        this.updateBloomFilterFile = true;
    }

    private void doUpdateVanity(String path) {
        this.doRemoveVanity(path);
        this.doAddVanity(path);
    }

    private void doRemoveVanity(String path) {
        String actualContentPath = this.getActualContentPath(path);
        List<String> l = this.vanityTargets.get(actualContentPath);
        if (l != null) {
            for (String s : l) {
                List<MapEntry> entries = this.resolveMapsMap.get(s);
                if (entries != null) {
                    Iterator<MapEntry> iterator = entries.iterator();
                    while (iterator.hasNext()) {
                        MapEntry entry = iterator.next();
                        String redirect = this.getMapEntryRedirect(entry);
                        if (redirect == null || !redirect.equals(actualContentPath)) continue;
                        iterator.remove();
                    }
                }
                if (entries == null || !entries.isEmpty()) continue;
                this.resolveMapsMap.remove(s);
            }
        }
        this.vanityTargets.remove(actualContentPath);
        if (this.vanityCounter.longValue() > 0L) {
            this.vanityCounter.decrementAndGet();
        }
    }

    private void doUpdateVanityOrder(String path, boolean deletion) {
        Resource resource = this.resolver.getResource(path);
        ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
        long vanityOrder = deletion ? 0L : (Long)props.get(PROP_VANITY_ORDER, Long.class);
        String actualContentPath = this.getActualContentPath(path);
        List<String> vanityPaths = this.vanityTargets.get(actualContentPath);
        if (vanityPaths != null) {
            boolean updatedOrder = false;
            for (String vanityTarget : vanityPaths) {
                List<MapEntry> entries = this.resolveMapsMap.get(vanityTarget);
                for (MapEntry entry : entries) {
                    String redirect = this.getMapEntryRedirect(entry);
                    if (redirect == null || !redirect.equals(actualContentPath)) continue;
                    entry.setOrder(vanityOrder);
                    updatedOrder = true;
                }
                if (!updatedOrder) continue;
                Collections.sort(entries);
            }
        }
    }

    private void doUpdateRedirectStatus(String path) {
        String actualContentPath = this.getActualContentPath(path);
        List<String> vanityPaths = this.vanityTargets.get(actualContentPath);
        if (vanityPaths != null) {
            this.doUpdateVanity(path);
        }
    }

    private void doAddAlias(String path) {
        Resource resource = this.resolver.getResource(path);
        this.loadAlias(resource, this.aliasMap);
    }

    private void doUpdateAlias(String path, boolean nodeDeletion) {
        if (nodeDeletion) {
            Resource resource;
            if (path.endsWith("/jcr:content") && (resource = this.resolver.getResource(path = path.substring(0, path.length() - "/jcr:content".length()))) != null) {
                path = resource.getPath();
                ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
                if (props.get("sling:alias", String[].class) != null) {
                    this.doAddAlias(path);
                }
            }
        } else {
            Resource resource = this.resolver.getResource(path);
            if (resource != null) {
                if (resource.getName().equals("jcr:content")) {
                    Resource parent = resource.getParent();
                    path = parent.getPath();
                    ValueMap props = (ValueMap)parent.adaptTo(ValueMap.class);
                    if (props.get("sling:alias", String[].class) != null) {
                        this.doAddAlias(path);
                    }
                } else if (resource.getChild("jcr:content") != null) {
                    Resource jcrContent = resource.getChild("jcr:content");
                    path = jcrContent.getPath();
                    ValueMap props = (ValueMap)jcrContent.adaptTo(ValueMap.class);
                    if (props.get("sling:alias", String[].class) != null) {
                        this.doAddAlias(path);
                    }
                }
            }
        }
    }

    private void doRemoveAlias(String path, boolean nodeDeletion) {
        String resourceName = null;
        if (nodeDeletion) {
            if (!"/".equals(path)) {
                if (path.endsWith("/jcr:content")) {
                    path = path.substring(0, path.length() - "/jcr:content".length());
                }
                resourceName = path.substring(path.lastIndexOf("/") + 1);
                path = ResourceUtil.getParent((String)path);
            } else {
                resourceName = "";
            }
        } else {
            Resource resource = this.resolver.getResource(path);
            if (resource.getName().equals("jcr:content")) {
                Resource containingResource = resource.getParent();
                path = containingResource.getParent().getPath();
                resourceName = containingResource.getName();
            } else {
                path = resource.getParent().getPath();
                resourceName = resource.getName();
            }
        }
        Map<String, String> aliasMapEntry = this.aliasMap.get(path);
        if (aliasMapEntry != null) {
            Iterator<String> iterator = aliasMapEntry.keySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next();
                if (!resourceName.equals(aliasMapEntry.get(key))) continue;
                iterator.remove();
            }
        }
        if (aliasMapEntry != null && aliasMapEntry.isEmpty()) {
            this.aliasMap.remove(path);
        }
    }

    public boolean isOptimizeAliasResolutionEnabled() {
        return this.enableOptimizeAliasResolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        boolean initLocked;
        try {
            this.persistBloomFilter();
        }
        catch (IOException e) {
            this.log.error("Error while saving bloom filter to disk", (Throwable)e);
        }
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        try {
            initLocked = this.initializing.tryLock(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            initLocked = false;
        }
        try {
            if (!initLocked) {
                this.log.warn("dispose: Could not acquire initialization lock within 10 seconds; ongoing intialization may fail");
            }
            ResourceResolver oldResolver = this.resolver;
            this.resolver = null;
            if (oldResolver != null) {
                oldResolver.close();
            } else {
                this.log.warn("dispose: ResourceResolver has already been cleared before; duplicate call to dispose ?");
            }
        }
        finally {
            if (initLocked) {
                this.initializing.unlock();
            }
        }
        this.factory = null;
        this.eventAdmin = null;
    }

    public List<MapEntry> getResolveMaps() {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        for (List<MapEntry> list : this.resolveMapsMap.values()) {
            entries.addAll(list);
        }
        Collections.sort(entries);
        return Collections.unmodifiableList(entries);
    }

    public Iterator<MapEntry> getResolveMapsIterator(String requestPath) {
        String key = null;
        int firstIndex = requestPath.indexOf(47);
        int secondIndex = requestPath.indexOf(47, firstIndex + 1);
        if (secondIndex != -1) {
            key = requestPath.substring(secondIndex);
        }
        return new MapEntryIterator(key, this.resolveMapsMap, this.vanityPathPrecedence);
    }

    public Collection<MapEntry> getMapMaps() {
        return this.mapMaps;
    }

    public Map<String, String> getAliasMap(String parentPath) {
        return this.aliasMap.get(parentPath);
    }

    private List<MapEntry> getMapEntryList(String vanityPath) {
        List<MapEntry> mapEntries = null;
        if (BloomFilterUtils.probablyContains(this.vanityBloomFilter, vanityPath) && (mapEntries = this.resolveMapsMap.get(vanityPath)) == null) {
            Map<String, List<MapEntry>> mapEntry = this.getVanityPaths(vanityPath);
            mapEntries = mapEntry.get(vanityPath);
        }
        return mapEntries;
    }

    public void handleEvent(Event event) {
        Object p = event.getProperty("path");
        if (!(p instanceof String)) {
            this.log.debug("handleEvent, topic={}, no path provided, event ignored", (Object)event.getTopic());
            return;
        }
        String path = (String)p;
        this.log.debug("handleEvent, topic={}, path={}", (Object)event.getTopic(), (Object)path);
        if (path.startsWith(JCR_SYSTEM_PREFIX)) {
            return;
        }
        boolean wasResolverRefreshed = false;
        if ("org/apache/sling/api/resource/Resource/REMOVED".equals(event.getTopic())) {
            String actualContentPath = this.getActualContentPath(path);
            for (String target : this.vanityTargets.keySet()) {
                if (!target.startsWith(actualContentPath)) continue;
                wasResolverRefreshed = this.doRemoveAttributes(path, new String[]{PROP_VANITY_PATH}, true, wasResolverRefreshed);
            }
            for (String target : this.aliasMap.keySet()) {
                if (!actualContentPath.startsWith(target)) continue;
                wasResolverRefreshed = this.doRemoveAttributes(path, new String[]{"sling:alias"}, true, wasResolverRefreshed);
            }
            if (path.startsWith(this.mapRoot)) {
                wasResolverRefreshed = this.doUpdateConfiguration(wasResolverRefreshed);
            }
        } else if ("org/apache/sling/api/resource/Resource/ADDED".equals(event.getTopic()) && event.getProperty("resourceAddedAttributes") == null) {
            wasResolverRefreshed = this.doNodeAdded(path, wasResolverRefreshed);
        } else {
            Object[] removedAttributes;
            Object[] changedAttributes;
            Object[] addedAttributes = (String[])event.getProperty("resourceAddedAttributes");
            if (addedAttributes != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("found added attributes {}", addedAttributes);
                }
                wasResolverRefreshed = this.doAddAttributes(path, (String[])addedAttributes, wasResolverRefreshed);
            }
            if ((changedAttributes = (String[])event.getProperty("resourceChangedAttributes")) != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("found changed attributes {}", changedAttributes);
                }
                wasResolverRefreshed = this.doUpdateAttributes(path, (String[])changedAttributes, wasResolverRefreshed);
            }
            if ((removedAttributes = (String[])event.getProperty("resourceRemovedAttributes")) != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("found removed attributes {}", removedAttributes);
                }
                wasResolverRefreshed = this.doRemoveAttributes(path, (String[])removedAttributes, false, wasResolverRefreshed);
            }
        }
    }

    private byte[] createVanityBloomFilter() throws IOException {
        byte[] bloomFilter = null;
        if (this.vanityBloomFilter == null) {
            bloomFilter = BloomFilterUtils.createFilter(10000000, this.vanityBloomFilterMaxBytes);
        }
        return bloomFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistBloomFilter() throws IOException {
        if (this.vanityBloomFilterFile != null && this.vanityBloomFilter != null) {
            FileOutputStream out = new FileOutputStream(this.vanityBloomFilterFile);
            try {
                out.write(this.vanityBloomFilter);
            }
            finally {
                out.close();
            }
        }
    }

    private boolean isAllVanityPathEntriesCached() {
        return this.maxCachedVanityPathEntries == -1L;
    }

    private static String escapeIllegalXpathSearchChars(String s) {
        StringBuilder sb = new StringBuilder();
        if (s != null && s.length() > 1) {
            sb.append(s.substring(0, s.length() - 1));
            char c = s.charAt(s.length() - 1);
            if (c == '!' || c == '(' || c == ':' || c == '^' || c == '[' || c == ']' || c == '{' || c == '}' || c == '?') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private Map<String, List<MapEntry>> getVanityPaths(String vanityPath) {
        HashMap<String, List<MapEntry>> entryMap = new HashMap<String, List<MapEntry>>();
        HashMap<String, List<String>> targetPaths = new HashMap<String, List<String>>();
        String queryString = "SELECT sling:vanityPath, sling:redirect, sling:redirectStatus FROM sling:VanityPath WHERE sling:vanityPath ='" + MapEntries.escapeIllegalXpathSearchChars(vanityPath).replaceAll("'", "''") + "' OR sling:vanityPath =" + "'" + MapEntries.escapeIllegalXpathSearchChars(vanityPath.substring(1)).replaceAll("'", "''") + "' ORDER BY sling:vanityOrder DESC";
        Iterator i = this.resolver.findResources(queryString, "sql");
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            this.loadVanityPath(resource, entryMap, targetPaths, true, false);
        }
        return entryMap;
    }

    private boolean isValidVanityPath(Resource resource) {
        ValueMap props;
        if (resource.getPath().startsWith(JCR_SYSTEM_PREFIX)) {
            this.log.debug("isValidVanityPath: not valid {}", (Object)resource);
            return false;
        }
        if (this.vanityPathConfig != null) {
            boolean allowed = false;
            for (MapConfigurationProvider.VanityPathConfig config : this.vanityPathConfig) {
                if (!resource.getPath().startsWith(config.prefix)) continue;
                allowed = !config.isExclude;
                break;
            }
            if (!allowed) {
                this.log.debug("isValidVanityPath: not valid as not in white list {}", (Object)resource);
                return false;
            }
        }
        if ((props = (ValueMap)resource.adaptTo(ValueMap.class)) == null) {
            this.log.debug("isValidVanityPath: not valid {} without properties", (Object)resource);
            return false;
        }
        return true;
    }

    private String getActualContentPath(String path) {
        String checkPath = path.endsWith("/jcr:content") ? path.substring(0, path.length() - "/jcr:content".length()) : path;
        return checkPath;
    }

    private String getMapEntryRedirect(MapEntry mapEntry) {
        String[] redirect = mapEntry.getRedirect();
        if (redirect.length > 1) {
            this.log.warn("something went wrong, please restart the bundle");
            return null;
        }
        String path = redirect[0];
        if (path.endsWith("$1")) {
            path = path.substring(0, path.length() - "$1".length());
        } else if (path.endsWith(".html")) {
            path = path.substring(0, path.length() - ".html".length());
        }
        return path;
    }

    private void sendChangeEvent() {
        if (this.eventAdmin != null) {
            Event event = new Event("org/apache/sling/api/resource/ResourceResolverMapping/CHANGED", (Dictionary)null);
            this.eventAdmin.postEvent(event);
        }
    }

    private void loadResolverMap(ResourceResolver resolver, List<MapEntry> entries, Map<String, MapEntry> mapEntries) {
        Resource res = resolver.getResource(this.mapRoot);
        if (res != null) {
            this.gather(resolver, entries, mapEntries, res, "");
        }
    }

    private void gather(ResourceResolver resolver, List<MapEntry> entries, Map<String, MapEntry> mapEntries, Resource parent, String parentPath) {
        Iterator children = parent.listChildren();
        while (children.hasNext()) {
            List<MapEntry> childMapEntries;
            String childPath;
            Resource child = (Resource)children.next();
            ValueMap vm = ResourceUtil.getValueMap((Resource)child);
            String name = (String)vm.get(PROP_REG_EXP, String.class);
            boolean trailingSlash = false;
            if (name == null) {
                name = child.getName().concat("/");
                trailingSlash = true;
            }
            if (!(childPath = parentPath.concat(name)).endsWith("$")) {
                String childParent = childPath;
                if (!trailingSlash) {
                    childParent = childParent.concat("/");
                }
                this.gather(resolver, entries, mapEntries, child, childParent);
            }
            MapEntry childResolveEntry = null;
            try {
                childResolveEntry = MapEntry.createResolveEntry(childPath, child, trailingSlash);
            }
            catch (IllegalArgumentException iae) {
                this.log.debug("ignored entry due exception ", (Throwable)iae);
            }
            if (childResolveEntry != null) {
                entries.add(childResolveEntry);
            }
            if ((childMapEntries = MapEntry.createMapEntry(childPath, child, trailingSlash)) == null) continue;
            for (MapEntry mapEntry : childMapEntries) {
                this.addMapEntry(mapEntries, mapEntry.getPattern(), mapEntry.getRedirect()[0], mapEntry.getStatus());
            }
        }
    }

    private boolean addEntry(Map<String, List<MapEntry>> entryMap, String key, MapEntry entry) {
        if (entry == null) {
            return false;
        }
        List<MapEntry> entries = entryMap.get(key);
        if (entries == null) {
            entries = new ArrayList<MapEntry>();
            entryMap.put(key, entries);
        }
        entries.add(entry);
        Collections.sort(entries);
        return true;
    }

    private Map<String, Map<String, String>> loadAliases(ResourceResolver resolver) {
        ConcurrentHashMap<String, Map<String, String>> map = new ConcurrentHashMap<String, Map<String, String>>();
        String queryString = "SELECT sling:alias FROM nt:base WHERE sling:alias IS NOT NULL";
        Iterator i = resolver.findResources("SELECT sling:alias FROM nt:base WHERE sling:alias IS NOT NULL", "sql");
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            this.loadAlias(resource, map);
        }
        return map;
    }

    private void loadAlias(Resource resource, Map<String, Map<String, String>> map) {
        String resourceName;
        String parentPath;
        if (resource.getPath().startsWith(JCR_SYSTEM_PREFIX)) {
            this.log.debug("loadAliases: Ignoring {}", (Object)resource);
            return;
        }
        ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
        if (props == null) {
            this.log.debug("loadAliases: Ignoring {} without properties", (Object)resource);
            return;
        }
        if (resource.getName().equals("jcr:content")) {
            Resource containingResource = resource.getParent();
            parentPath = containingResource.getParent().getPath();
            resourceName = containingResource.getName();
        } else {
            parentPath = resource.getParent().getPath();
            resourceName = resource.getName();
        }
        Map<String, String> parentMap = map.get(parentPath);
        for (String alias : (String[])props.get("sling:alias", String[].class)) {
            boolean invalid;
            if (parentMap != null && parentMap.containsKey(alias)) {
                this.log.warn("Encountered duplicate alias {} under parent path {}. Refusing to replace current target {} with {}.", new Object[]{alias, parentPath, parentMap.get(alias), resourceName});
                continue;
            }
            boolean bl = invalid = alias.equals("..") || alias.equals(".");
            if (!invalid) {
                for (char c : alias.toCharArray()) {
                    if (c != '/' && c != '#' && c != '?') continue;
                    invalid = true;
                    break;
                }
            }
            if (invalid) {
                this.log.warn("Encountered invalid alias {} under parent path {}. Refusing to use it.", (Object)alias, (Object)parentPath);
                continue;
            }
            if (parentMap == null) {
                parentMap = new LinkedHashMap<String, String>();
                map.put(parentPath, parentMap);
            }
            parentMap.put(alias, resourceName);
        }
    }

    private Map<String, List<String>> loadVanityPaths(ResourceResolver resolver, Map<String, List<MapEntry>> entryMap, boolean createVanityBloomFilter) {
        ConcurrentHashMap<String, List<String>> targetPaths = new ConcurrentHashMap<String, List<String>>();
        String queryString = "SELECT sling:vanityPath, sling:redirect, sling:redirectStatus FROM sling:VanityPath WHERE sling:vanityPath IS NOT NULL";
        Iterator i = resolver.findResources("SELECT sling:vanityPath, sling:redirect, sling:redirectStatus FROM sling:VanityPath WHERE sling:vanityPath IS NOT NULL", "sql");
        while (i.hasNext() && (createVanityBloomFilter || this.maxCachedVanityPathEntries < this.vanityCounter.longValue())) {
            Resource resource = (Resource)i.next();
            if (this.maxCachedVanityPathEntries < this.vanityCounter.longValue()) {
                this.loadVanityPath(resource, entryMap, targetPaths, true, createVanityBloomFilter);
                this.vanityCounter.incrementAndGet();
                continue;
            }
            this.loadVanityPath(resource, entryMap, targetPaths, false, createVanityBloomFilter);
        }
        return targetPaths;
    }

    private void loadVanityPath(Resource resource, Map<String, List<MapEntry>> entryMap, Map<String, List<String>> targetPaths, boolean addToCache, boolean newVanity) {
        String[] pVanityPaths;
        if (!this.isValidVanityPath(resource)) {
            return;
        }
        ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
        long vanityOrder = 0L;
        if (props.containsKey((Object)PROP_VANITY_ORDER)) {
            vanityOrder = (Long)props.get(PROP_VANITY_ORDER, Long.class);
        }
        for (String pVanityPath : pVanityPaths = (String[])props.get(PROP_VANITY_PATH, (Object)new String[0])) {
            String[] result = this.getVanityPathDefinition(pVanityPath);
            if (result == null) continue;
            String url = result[0] + result[1];
            Resource redirectTarget = resource.getName().equals("jcr:content") ? resource.getParent() : resource;
            String redirect = redirectTarget.getPath();
            String redirectName = redirectTarget.getName();
            int status = (Boolean)props.get(PROP_REDIRECT_EXTERNAL, (Object)false) != false ? (Integer)props.get(PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS, (Object)this.factory.getDefaultVanityPathRedirectStatus()) : -1;
            String checkPath = result[1];
            if (addToCache) {
                boolean addedEntry;
                if (redirectName.indexOf(46) > -1) {
                    this.addEntry(entryMap, checkPath, this.getMapEntry(url + "$", status, false, vanityOrder, redirect));
                    int idx = redirectName.lastIndexOf(46);
                    String extension = redirectName.substring(idx + 1);
                    addedEntry = this.addEntry(entryMap, checkPath, this.getMapEntry(url + "\\." + extension, status, false, vanityOrder, redirect));
                } else {
                    this.addEntry(entryMap, checkPath, this.getMapEntry(url + "$", status, false, vanityOrder, redirect + ".html"));
                    addedEntry = this.addEntry(entryMap, checkPath, this.getMapEntry(url + "(\\..*)", status, false, vanityOrder, redirect + "$1"));
                }
                if (!addedEntry) continue;
                this.updateTargetPaths(targetPaths, redirect, checkPath);
                if (!newVanity) continue;
                BloomFilterUtils.add(this.vanityBloomFilter, checkPath);
                continue;
            }
            if (!newVanity) continue;
            BloomFilterUtils.add(this.vanityBloomFilter, checkPath);
        }
    }

    private void updateTargetPaths(Map<String, List<String>> targetPaths, String key, String entry) {
        if (entry == null) {
            return;
        }
        List<String> entries = targetPaths.get(key);
        if (entries == null) {
            entries = new ArrayList<String>();
            targetPaths.put(key, entries);
        }
        entries.add(entry);
    }

    private String[] getVanityPathDefinition(String pVanityPath) {
        String info;
        String[] result = null;
        if (pVanityPath != null && (info = pVanityPath.trim()).length() > 0) {
            String prefix = null;
            String path = null;
            if (info.indexOf(":/") > -1) {
                try {
                    URL u = new URL(info);
                    prefix = u.getProtocol() + '/' + u.getHost() + '.' + u.getPort();
                    path = u.getPath();
                }
                catch (MalformedURLException e) {
                    this.log.warn("Ignoring malformed vanity path {}", (Object)pVanityPath);
                }
            } else {
                prefix = "^[^/]+/[^/]+";
                path = !info.startsWith("/") ? "/" + info : info;
            }
            if (prefix != null) {
                int lastSlash = path.lastIndexOf(47);
                int firstDot = path.indexOf(46, lastSlash + 1);
                if (firstDot != -1) {
                    path = path.substring(0, firstDot);
                    this.log.warn("Removing extension from vanity path {}", (Object)pVanityPath);
                }
                result = new String[]{prefix, path};
            }
        }
        return result;
    }

    private void loadConfiguration(MapConfigurationProvider factory, List<MapEntry> entries) {
        Mapping[] mappings;
        Map<?, ?> virtuals = factory.getVirtualURLMap();
        if (virtuals != null) {
            for (Map.Entry<?, ?> virtualEntry : virtuals.entrySet()) {
                String intPath;
                String extPath = (String)virtualEntry.getKey();
                if (extPath.equals(intPath = (String)virtualEntry.getValue())) continue;
                String url = "^[^/]+/[^/]+" + extPath + "$";
                String redirect = intPath;
                MapEntry mapEntry = this.getMapEntry(url, -1, false, redirect);
                if (mapEntry == null) continue;
                entries.add(mapEntry);
            }
        }
        if ((mappings = factory.getMappings()) != null) {
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
            for (Mapping mapping : mappings) {
                if (!mapping.mapsInbound()) continue;
                String url = mapping.getTo();
                String alias = mapping.getFrom();
                if (url.length() <= 0) continue;
                ArrayList<String> aliasList = (ArrayList<String>)map.get(url);
                if (aliasList == null) {
                    aliasList = new ArrayList<String>();
                    map.put(url, aliasList);
                }
                aliasList.add(alias);
            }
            for (Map.Entry entry : map.entrySet()) {
                MapEntry mapEntry = this.getMapEntry(ANY_SCHEME_HOST + (String)entry.getKey(), -1, false, ((List)entry.getValue()).toArray(new String[0]));
                if (mapEntry == null) continue;
                entries.add(mapEntry);
            }
        }
    }

    private void loadMapConfiguration(MapConfigurationProvider factory, Map<String, MapEntry> entries) {
        Map<?, ?> virtuals;
        Mapping[] mappings = factory.getMappings();
        if (mappings != null) {
            for (int i = mappings.length - 1; i >= 0; --i) {
                String alias;
                String url;
                Mapping mapping = mappings[i];
                if (!mapping.mapsOutbound() || (url = mapping.getTo()).equals(alias = mapping.getFrom())) continue;
                this.addMapEntry(entries, alias, url, -1);
            }
        }
        if ((virtuals = factory.getVirtualURLMap()) != null) {
            for (Map.Entry<?, ?> virtualEntry : virtuals.entrySet()) {
                String intPath;
                String extPath = (String)virtualEntry.getKey();
                if (extPath.equals(intPath = (String)virtualEntry.getValue())) continue;
                String path = "^" + intPath + "$";
                String url = extPath;
                this.addMapEntry(entries, path, url, -1);
            }
        }
    }

    private void addMapEntry(Map<String, MapEntry> entries, String path, String url, int status) {
        MapEntry entry = entries.get(path);
        if (entry == null) {
            entry = this.getMapEntry(path, status, false, url);
        } else {
            String[] redir = entry.getRedirect();
            String[] newRedir = new String[redir.length + 1];
            System.arraycopy(redir, 0, newRedir, 0, redir.length);
            newRedir[redir.length] = url;
            entry = this.getMapEntry(entry.getPattern(), entry.getStatus(), false, newRedir);
        }
        if (entry != null) {
            entries.put(path, entry);
        }
    }

    private static String createFilter(boolean vanityPathEnabled) {
        String[] nodeProps = new String[]{PROP_REDIRECT_EXTERNAL_REDIRECT_STATUS, PROP_REDIRECT_EXTERNAL, "sling:internalRedirect", PROP_REDIRECT_EXTERNAL_STATUS, PROP_REG_EXP, "sling:alias"};
        String[] eventProps = new String[]{"resourceAddedAttributes", "resourceChangedAttributes", "resourceRemovedAttributes"};
        StringBuilder filter = new StringBuilder();
        filter.append("(|");
        for (String eventProp : eventProps) {
            filter.append("(|");
            if (vanityPathEnabled) {
                filter.append('(').append(eventProp).append('=').append(PROP_VANITY_PATH).append(')');
                filter.append('(').append(eventProp).append('=').append(PROP_VANITY_ORDER).append(')');
            }
            for (String nodeProp : nodeProps) {
                filter.append('(').append(eventProp).append('=').append(nodeProp).append(')');
            }
            filter.append(")");
        }
        filter.append("(").append("event.topics").append("=").append("org/apache/sling/api/resource/Resource/REMOVED").append(")");
        filter.append("(").append("event.topics").append("=").append("org/apache/sling/api/resource/Resource/ADDED").append(")");
        filter.append(")");
        return filter.toString();
    }

    private MapEntry getMapEntry(String url, int status, boolean trailingSlash, String ... redirect) {
        MapEntry mapEntry = null;
        try {
            mapEntry = new MapEntry(url, status, trailingSlash, 0L, redirect);
        }
        catch (IllegalArgumentException iae) {
            this.log.debug("ignored entry due exception ", (Throwable)iae);
        }
        return mapEntry;
    }

    private MapEntry getMapEntry(String url, int status, boolean trailingSlash, long order, String ... redirect) {
        MapEntry mapEntry = null;
        try {
            mapEntry = new MapEntry(url, status, trailingSlash, order, redirect);
        }
        catch (IllegalArgumentException iae) {
            this.log.debug("ignored entry due exception ", (Throwable)iae);
        }
        return mapEntry;
    }

    final class BloomFilterTask
    extends TimerTask {
        BloomFilterTask() {
        }

        @Override
        public void run() {
            try {
                if (MapEntries.this.updateBloomFilterFile) {
                    MapEntries.this.persistBloomFilter();
                    MapEntries.this.updateBloomFilterFile = false;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while saving bloom filter to disk", e);
            }
        }
    }

    private final class MapEntryIterator
    implements Iterator<MapEntry> {
        private final Map<String, List<MapEntry>> resolveMapsMap;
        private String key;
        private MapEntry next;
        private final Iterator<MapEntry> globalListIterator;
        private MapEntry nextGlobal;
        private Iterator<MapEntry> specialIterator;
        private MapEntry nextSpecial;
        private boolean vanityPathPrecedence;

        public MapEntryIterator(String startKey, Map<String, List<MapEntry>> resolveMapsMap, boolean vanityPathPrecedence) {
            this.key = startKey;
            this.resolveMapsMap = resolveMapsMap;
            this.globalListIterator = this.resolveMapsMap.get(MapEntries.GLOBAL_LIST_KEY).iterator();
            this.vanityPathPrecedence = vanityPathPrecedence;
            this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public MapEntry next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            MapEntry result = this.next;
            this.seek();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void seek() {
            if (this.nextGlobal == null && this.globalListIterator.hasNext()) {
                this.nextGlobal = this.globalListIterator.next();
            }
            if (this.nextSpecial == null) {
                if (this.specialIterator != null && !this.specialIterator.hasNext()) {
                    this.specialIterator = null;
                }
                while (this.specialIterator == null && this.key != null) {
                    List<MapEntry> special;
                    int lastSlashPos = this.key.lastIndexOf(47);
                    int lastDotPos = this.key.indexOf(46, lastSlashPos);
                    if (lastDotPos != -1) {
                        this.key = this.key.substring(0, lastDotPos);
                    }
                    if ((special = MapEntries.this.isAllVanityPathEntriesCached() ? this.resolveMapsMap.get(this.key) : MapEntries.this.getMapEntryList(this.key)) != null) {
                        this.specialIterator = special.iterator();
                    }
                    if (this.key.length() > 1) {
                        int lastSlash = this.key.lastIndexOf("/");
                        if (lastSlash == 0) {
                            this.key = null;
                            continue;
                        }
                        this.key = this.key.substring(0, lastSlash);
                        continue;
                    }
                    this.key = null;
                }
                if (this.specialIterator != null && this.specialIterator.hasNext()) {
                    this.nextSpecial = this.specialIterator.next();
                }
            }
            if (this.nextSpecial == null) {
                this.next = this.nextGlobal;
                this.nextGlobal = null;
            } else if (!this.vanityPathPrecedence) {
                if (this.nextGlobal == null) {
                    this.next = this.nextSpecial;
                    this.nextSpecial = null;
                } else if (this.nextGlobal.getPattern().length() >= this.nextSpecial.getPattern().length()) {
                    this.next = this.nextGlobal;
                    this.nextGlobal = null;
                } else {
                    this.next = this.nextSpecial;
                    this.nextSpecial = null;
                }
            } else {
                this.next = this.nextSpecial;
                this.nextSpecial = null;
            }
        }
    }
}

