/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.legacy;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.AttributableResourceProvider;
import org.apache.sling.api.resource.DynamicResourceProvider;
import org.apache.sling.api.resource.ModifyingResourceProvider;
import org.apache.sling.api.resource.ParametrizableResourceProvider;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.QueriableResourceProvider;
import org.apache.sling.api.resource.RefreshableResourceProvider;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.spi.resource.provider.QueryLanguageProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;

public class LegacyResourceProviderAdapter
extends org.apache.sling.spi.resource.provider.ResourceProvider<Object>
implements Closeable {
    private final ResourceProvider rp;
    private final String[] languages;
    private final boolean ownsRoot;

    public LegacyResourceProviderAdapter(ResourceProvider rp, String[] languages, boolean ownsRoot) {
        this.rp = rp;
        this.languages = languages;
        this.ownsRoot = ownsRoot;
    }

    public Resource getResource(ResolveContext<Object> ctx, String path, ResourceContext resourceContext, Resource parent) {
        Resource resourceCandidate = this.rp instanceof ParametrizableResourceProvider ? ((ParametrizableResourceProvider)this.rp).getResource(ctx.getResourceResolver(), path, resourceContext.getResolveParameters()) : this.rp.getResource(ctx.getResourceResolver(), path);
        org.apache.sling.spi.resource.provider.ResourceProvider parentProvider = ctx.getParentResourceProvider();
        ResolveContext parentCtx = ctx.getParentResolveContext();
        if (resourceCandidate == null && !this.ownsRoot && parentProvider != null) {
            return parentProvider.getResource(parentCtx, path, resourceContext, parent);
        }
        Resource fallbackResource = resourceCandidate;
        if (resourceCandidate != null && parentProvider != null && this.isContinueResolving(resourceCandidate)) {
            resourceCandidate = ctx.getParentResourceProvider().getResource(parentCtx, path, resourceContext, parent);
        }
        if (resourceCandidate != null) {
            return resourceCandidate;
        }
        return fallbackResource;
    }

    private boolean isContinueResolving(Resource resource) {
        return resource.getResourceMetadata() != null && resource.getResourceMetadata().containsKey((Object)":org.apache.sling.resource.internal.continue.resolving");
    }

    public Iterator<Resource> listChildren(ResolveContext<Object> ctx, Resource parent) {
        Iterator children = this.rp.listChildren(parent);
        if (children == null && !this.ownsRoot && ctx.getParentResourceProvider() != null) {
            children = ctx.getParentResourceProvider().listChildren(ctx.getParentResolveContext(), parent);
        }
        return children;
    }

    public void refresh(@Nonnull ResolveContext<Object> ctx) {
        if (this.rp instanceof RefreshableResourceProvider) {
            ((RefreshableResourceProvider)this.rp).refresh();
        }
    }

    @CheckForNull
    public QueryLanguageProvider<Object> getQueryLanguageProvider() {
        if (this.rp instanceof QueriableResourceProvider) {
            return new JCRQueryProviderAdapter((QueriableResourceProvider)this.rp, this.languages);
        }
        return super.getQueryLanguageProvider();
    }

    public Collection<String> getAttributeNames(@Nonnull ResolveContext<Object> ctx) {
        if (this.rp instanceof AttributableResourceProvider) {
            return ((AttributableResourceProvider)this.rp).getAttributeNames(ctx.getResourceResolver());
        }
        return super.getAttributeNames(ctx);
    }

    public Object getAttribute(@Nonnull ResolveContext<Object> ctx, @Nonnull String name) {
        if (this.rp instanceof AttributableResourceProvider) {
            return ((AttributableResourceProvider)this.rp).getAttribute(ctx.getResourceResolver(), name);
        }
        return super.getAttribute(ctx, name);
    }

    public boolean isLive(@Nonnull ResolveContext<Object> ctx) {
        if (this.rp instanceof DynamicResourceProvider) {
            return ((DynamicResourceProvider)this.rp).isLive();
        }
        return super.isLive(ctx);
    }

    public void logout(@Nonnull Object state) {
        if (this.rp instanceof DynamicResourceProvider) {
            ((DynamicResourceProvider)this.rp).close();
        }
    }

    @Override
    public void close() throws IOException {
        this.logout(null);
    }

    public Resource create(@Nonnull ResolveContext<Object> ctx, String path, Map<String, Object> properties) throws PersistenceException {
        Resource createdResource = null;
        if (this.rp instanceof ModifyingResourceProvider) {
            createdResource = ((ModifyingResourceProvider)this.rp).create(ctx.getResourceResolver(), path, properties);
        }
        if (createdResource == null && !this.ownsRoot && ctx.getParentResourceProvider() != null) {
            createdResource = ctx.getParentResourceProvider().create(ctx.getParentResolveContext(), path, properties);
        }
        return createdResource;
    }

    public void delete(@Nonnull ResolveContext<Object> ctx, @Nonnull Resource resource) throws PersistenceException {
        if (this.rp instanceof ModifyingResourceProvider) {
            ((ModifyingResourceProvider)this.rp).delete(ctx.getResourceResolver(), resource.getPath());
        } else {
            super.delete(ctx, resource);
        }
    }

    public void revert(@Nonnull ResolveContext<Object> ctx) {
        if (this.rp instanceof ModifyingResourceProvider) {
            ((ModifyingResourceProvider)this.rp).revert(ctx.getResourceResolver());
        } else {
            super.revert(ctx);
        }
    }

    public void commit(@Nonnull ResolveContext<Object> ctx) throws PersistenceException {
        if (this.rp instanceof ModifyingResourceProvider) {
            ((ModifyingResourceProvider)this.rp).commit(ctx.getResourceResolver());
        } else {
            super.commit(ctx);
        }
    }

    public boolean hasChanges(@Nonnull ResolveContext<Object> ctx) {
        if (this.rp instanceof ModifyingResourceProvider) {
            return ((ModifyingResourceProvider)this.rp).hasChanges(ctx.getResourceResolver());
        }
        return super.hasChanges(ctx);
    }

    public <AdapterType> AdapterType adaptTo(@Nonnull ResolveContext<Object> ctx, @Nonnull Class<AdapterType> type) {
        Object value;
        if (this.rp instanceof Adaptable && (value = ((Adaptable)this.rp).adaptTo(type)) != null) {
            return (AdapterType)value;
        }
        return (AdapterType)super.adaptTo(ctx, type);
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + this.rp.toString() + " ]";
    }

    private static class JCRQueryProviderAdapter
    implements QueryLanguageProvider<Object> {
        private final QueriableResourceProvider rp;
        private final String[] languages;

        public JCRQueryProviderAdapter(QueriableResourceProvider rp, String[] languages) {
            this.rp = rp;
            this.languages = languages;
        }

        public String[] getSupportedLanguages(ResolveContext<Object> ctx) {
            return this.languages;
        }

        public Iterator<Resource> findResources(ResolveContext<Object> ctx, String query, String language) {
            return this.rp.findResources(ctx.getResourceResolver(), query, language);
        }

        public Iterator<ValueMap> queryResources(ResolveContext<Object> ctx, String query, String language) {
            return this.rp.queryResources(ctx.getResourceResolver(), query, language);
        }
    }
}

