/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.html.dom;

import org.apache.sling.scripting.sightly.impl.html.dom.MarkupHandler;
import org.apache.sling.scripting.sightly.impl.html.dom.template.Template;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateAttribute;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateCommentNode;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateElementNode;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateNode;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateTextNode;

public class TreeTraverser {
    private final MarkupHandler handler;

    public TreeTraverser(MarkupHandler handler) {
        this.handler = handler;
    }

    public void traverse(Template template) {
        this.traverseNode(template);
        this.handler.onDocumentFinished();
    }

    private void traverseNode(TemplateNode node) {
        if (node instanceof TemplateElementNode) {
            this.traverseElement((TemplateElementNode)node);
        } else if (node instanceof TemplateTextNode) {
            this.traverseText((TemplateTextNode)node);
        } else if (node instanceof TemplateCommentNode) {
            this.traverseComment((TemplateCommentNode)node);
        } else {
            throw new IllegalArgumentException("Unknown node type");
        }
    }

    private void traverseElement(TemplateElementNode elem) {
        if ("ROOT".equalsIgnoreCase(elem.getName())) {
            this.traverseChildren(elem);
            return;
        }
        String tagName = elem.getName();
        if (elem.isHasStartElement()) {
            this.handler.onOpenTagStart("<" + tagName, tagName);
            for (TemplateAttribute attribute : elem.getAttributes()) {
                this.handler.onAttribute(attribute.getName(), attribute.getValue(), attribute.getQuoteChar());
            }
            if (elem.isHasEndSlash()) {
                this.handler.onOpenTagEnd("/>");
            } else {
                this.handler.onOpenTagEnd(">");
            }
        } else {
            this.handler.onOpenTagStart("", tagName);
            this.handler.onOpenTagEnd("");
        }
        this.traverseChildren(elem);
        if (elem.isHasEndElement()) {
            this.handler.onCloseTag("</" + elem.getName() + ">");
        } else {
            this.handler.onCloseTag("");
        }
    }

    private void traverseText(TemplateTextNode textNode) {
        this.handler.onText(textNode.getText());
    }

    private void traverseComment(TemplateCommentNode comment) {
        this.handler.onComment(comment.getText());
    }

    private void traverseChildren(TemplateElementNode elem) {
        for (TemplateNode node : elem.getChildren()) {
            this.traverseNode(node);
        }
    }
}

