/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.compiler.expression;

import java.util.HashMap;
import java.util.Map;

public enum MarkupContext {
    HTML("html"),
    TEXT("text"),
    ELEMENT_NAME("elementName"),
    ATTRIBUTE_NAME("attributeName"),
    ATTRIBUTE("attribute"),
    URI("uri"),
    SCRIPT_TOKEN("scriptToken"),
    SCRIPT_STRING("scriptString"),
    SCRIPT_COMMENT("scriptComment"),
    SCRIPT_REGEXP("scriptRegExp"),
    STYLE_TOKEN("styleToken"),
    STYLE_STRING("styleString"),
    STYLE_COMMENT("styleComment"),
    COMMENT("comment"),
    NUMBER("number"),
    UNSAFE("unsafe");

    private final String name;
    private static final Map<String, MarkupContext> reverseMap;

    private MarkupContext(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static MarkupContext lookup(String name) {
        return reverseMap.get(name);
    }

    static {
        reverseMap = new HashMap<String, MarkupContext>();
        for (MarkupContext markupContext : MarkupContext.values()) {
            reverseMap.put(markupContext.getName(), markupContext);
        }
    }
}

