/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler;

import java.util.LinkedList;
import java.util.List;
import org.apache.sling.scripting.sightly.compiler.commands.Command;
import org.apache.sling.scripting.sightly.compiler.commands.CommandHandler;
import org.apache.sling.scripting.sightly.compiler.commands.CommandStream;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.BroadcastHandler;

public final class PushStream
implements CommandStream {
    private BroadcastHandler handler = new BroadcastHandler();
    private boolean closed;
    private List<Command> commands = new LinkedList<Command>();
    private List<StreamMessage> warnings = new LinkedList<StreamMessage>();

    @Override
    public void addHandler(CommandHandler handler) {
        this.handler.addHandler(handler);
    }

    @Override
    public List<Command> getCommands() {
        return this.commands;
    }

    public List<StreamMessage> getWarnings() {
        return this.warnings;
    }

    public void write(Command command) {
        if (this.closed) {
            throw new UnsupportedOperationException("Stream is closed");
        }
        this.commands.add(command);
        this.handler.onEmit(command);
    }

    public void signalError(String message) {
        if (this.closed) {
            throw new UnsupportedOperationException("Stream has already been closed.");
        }
        this.closed = true;
        this.handler.onError(message);
    }

    public void close() {
        if (this.closed) {
            throw new UnsupportedOperationException("Stream has already been closed.");
        }
        this.closed = true;
        this.handler.onDone();
    }

    public void warn(StreamMessage warning) {
        this.warnings.add(warning);
    }

    public static class StreamMessage {
        private String message;
        private String code;

        public StreamMessage(String message, String code) {
            this.message = message;
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public String getCode() {
            return this.code;
        }
    }
}

