/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl;

import java.util.Collections;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.engine.ResourceResolution;

public class Utils {
    public static final String JS_EXTENSION = "js";
    public static final Bindings EMPTY_BINDINGS = new SimpleBindings(Collections.emptyMap());

    public static SlingScriptHelper getHelper(Bindings bindings) {
        return (SlingScriptHelper)bindings.get("sling");
    }

    public static boolean isJsScript(String identifier) {
        String extension = StringUtils.substringAfterLast((String)identifier, (String)".");
        return JS_EXTENSION.equalsIgnoreCase(extension);
    }

    public static Resource getScriptResource(Resource caller, String path, Bindings bindings) {
        Resource scriptResource = caller.getChild(path);
        if (scriptResource == null) {
            Resource componentCaller = ResourceResolution.getResourceForRequest((ResourceResolver)caller.getResourceResolver(), (SlingHttpServletRequest)((SlingHttpServletRequest)bindings.get("request")));
            scriptResource = Utils.isResourceOverlay(caller, componentCaller) ? ResourceResolution.getResourceFromSearchPath((Resource)componentCaller, (String)path) : ResourceResolution.getResourceFromSearchPath((Resource)caller, (String)path);
        }
        if (scriptResource == null) {
            throw new SightlyException("Required script resource could not be located: " + path + ". The caller is " + caller.getPath());
        }
        return scriptResource;
    }

    private static boolean isResourceOverlay(Resource resourceA, Resource resourceB) {
        String resourceBSuperType = resourceB.getResourceSuperType();
        if (StringUtils.isNotEmpty((String)resourceBSuperType)) {
            ResourceResolver resolver = resourceA.getResourceResolver();
            String parentResourceType = resourceA.getResourceType();
            if ("nt:file".equals(parentResourceType) && (parentResourceType = ResourceUtil.getParent((String)resourceA.getPath())).equals(resourceB.getPath())) {
                return true;
            }
            Resource parentB = resolver.getResource(resourceBSuperType);
            while (parentB != null && !"/".equals(parentB.getPath()) && StringUtils.isNotEmpty((String)resourceBSuperType)) {
                if (parentB.getPath().equals(parentResourceType)) {
                    return true;
                }
                resourceBSuperType = parentB.getResourceSuperType();
                parentB = resolver.getResource(resourceBSuperType);
            }
        }
        return false;
    }
}

