/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.JsEnvironment;
import org.apache.sling.scripting.sightly.js.impl.Utils;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncContainer;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncExtractor;
import org.apache.sling.scripting.sightly.js.impl.jsapi.SlyBindingsValuesProvider;
import org.apache.sling.scripting.sightly.js.impl.rhino.JsValueAdapter;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Sling Scripting Sightly JavaScript Use Provider", description="The JavaScript Use Provider is responsible for instantiating JavaScript Use-API objects.")
@Service(value={UseProvider.class})
@Properties(value={@Property(name="service.ranking", label="Service Ranking", description="The Service Ranking value acts as the priority with which this Use Provider is queried to return an Use-object. A higher value represents a higher priority.", intValue={80}, propertyPrivate=false)})
public class JsUseProvider
implements UseProvider {
    private static final String JS_ENGINE_NAME = "javascript";
    private static final String SCRIPT_CACHE_PID = "org.apache.sling.scripting.core.impl.ScriptCacheImpl";
    private static final String SCRIPT_CACHE_ADDITIONAL_EXTENSIONS = "org.apache.sling.scripting.cache.additional_extensions";
    private static final Logger LOGGER = LoggerFactory.getLogger(JsUseProvider.class);
    private static final JsValueAdapter jsValueAdapter = new JsValueAdapter(new AsyncExtractor());
    @Reference
    private ScriptEngineManager scriptEngineManager = null;
    @Reference
    private SlyBindingsValuesProvider slyBindingsValuesProvider = null;
    @Reference
    private ConfigurationAdmin configurationAdmin = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderOutcome provide(String identifier, RenderContext renderContext, Bindings arguments) {
        Bindings globalBindings = renderContext.getBindings();
        this.slyBindingsValuesProvider.processBindings(globalBindings);
        if (!Utils.isJsScript(identifier)) {
            return ProviderOutcome.failure();
        }
        ScriptEngine jsEngine = this.scriptEngineManager.getEngineByName(JS_ENGINE_NAME);
        if (jsEngine == null) {
            return ProviderOutcome.failure((Throwable)new SightlyException("No JavaScript engine was defined."));
        }
        SlingScriptHelper scriptHelper = Utils.getHelper(globalBindings);
        JsEnvironment environment = null;
        try {
            environment = new JsEnvironment(jsEngine);
            environment.initialize();
            String callerPath = scriptHelper.getScript().getScriptResource().getPath();
            ResourceResolver adminResolver = renderContext.getScriptResourceResolver();
            Resource caller = adminResolver.getResource(callerPath);
            AsyncContainer asyncContainer = environment.run(caller, identifier, globalBindings, arguments);
            ProviderOutcome providerOutcome = ProviderOutcome.success((Object)jsValueAdapter.adapt(asyncContainer));
            return providerOutcome;
        }
        finally {
            if (environment != null) {
                environment.cleanup();
            }
        }
    }

    protected void activate(ComponentContext componentContext) {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration(SCRIPT_CACHE_PID);
            Hashtable<String, String[]> properties = configuration.getProperties();
            if (properties == null) {
                properties = new Hashtable<String, String[]>(1);
            }
            String[] additionalExtensions = PropertiesUtil.toStringArray(((Dictionary)properties).get(SCRIPT_CACHE_ADDITIONAL_EXTENSIONS));
            HashSet<Object> extensionsSet = new HashSet<String>(1);
            if (additionalExtensions != null) {
                extensionsSet = new HashSet<String>(Arrays.asList(additionalExtensions));
            }
            extensionsSet.add("js");
            ((Dictionary)properties).put(SCRIPT_CACHE_ADDITIONAL_EXTENSIONS, extensionsSet.toArray(new String[extensionsSet.size()]));
            configuration.setBundleLocation(null);
            configuration.update(properties);
        }
        catch (IOException e) {
            LOGGER.error("Unable to retrieve org.apache.sling.scripting.core.impl.ScriptCacheImpl configuration. The Script Cache will not invalidate JavaScript file changes (e.g. files with the .js extension).");
        }
    }

    protected void bindScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    protected void unbindScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        if (this.scriptEngineManager == scriptEngineManager) {
            this.scriptEngineManager = null;
        }
    }

    protected void bindSlyBindingsValuesProvider(SlyBindingsValuesProvider slyBindingsValuesProvider) {
        this.slyBindingsValuesProvider = slyBindingsValuesProvider;
    }

    protected void unbindSlyBindingsValuesProvider(SlyBindingsValuesProvider slyBindingsValuesProvider) {
        if (this.slyBindingsValuesProvider == slyBindingsValuesProvider) {
            this.slyBindingsValuesProvider = null;
        }
    }

    protected void bindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void unbindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.configurationAdmin == configurationAdmin) {
            this.configurationAdmin = null;
        }
    }
}

