/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.use;

import javax.script.Bindings;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.JsEnvironment;
import org.apache.sling.scripting.sightly.js.impl.Utils;
import org.apache.sling.scripting.sightly.js.impl.async.UnaryCallback;

public class DependencyResolver {
    private final Resource caller;
    private final JsEnvironment jsEnvironment;
    private final Bindings globalBindings;

    public DependencyResolver(Resource resource, JsEnvironment jsEnvironment, Bindings globalBindings) {
        this.caller = resource;
        this.jsEnvironment = jsEnvironment;
        this.globalBindings = globalBindings;
    }

    public void resolve(String dependency, UnaryCallback callback) {
        if (!Utils.isJsScript(dependency)) {
            throw new SightlyException("Only JS scripts are allowed as dependencies. Invalid dependency: " + dependency);
        }
        this.jsEnvironment.run(this.caller, dependency, this.globalBindings, Utils.EMPTY_BINDINGS, callback);
    }
}

