/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler;

import java.util.Arrays;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;

public class Syntax {
    public static final String SLY_COMMENT_PREFIX = "<!--/*";
    public static final String SLY_COMMENT_SUFFIX = "*/-->";
    public static final String PLUGIN_ATTRIBUTE_PREFIX = "data-sly-";
    public static final String DEFAULT_LIST_ITEM_VAR_NAME = "item";
    public static final String ITEM_LOOP_STATUS_SUFFIX = "List";
    public static final String CONTEXT_OPTION = "context";
    public static final String MAP_ITEM_KEY_PROPERTY = "key";
    public static final String MAP_ITEM_VALUE_PROPERTY = "value";
    public static final String LENGTH_PROPERTY = "size";

    public static boolean isSightlyComment(String text) {
        String trimmed = text.trim();
        return trimmed.startsWith(SLY_COMMENT_PREFIX) && trimmed.endsWith(SLY_COMMENT_SUFFIX);
    }

    public static boolean isPluginAttribute(String attributeName) {
        return attributeName.startsWith(PLUGIN_ATTRIBUTE_PREFIX);
    }

    public static PluginCallInfo parsePluginAttribute(String attributeName) {
        if (!Syntax.isPluginAttribute(attributeName)) {
            return null;
        }
        String fragment = attributeName.substring(PLUGIN_ATTRIBUTE_PREFIX.length());
        String[] parts = fragment.split("\\.");
        if (parts.length == 0) {
            return null;
        }
        return new PluginCallInfo(parts[0], Arrays.copyOfRange(parts, 1, parts.length));
    }

    public static String itemLoopStatusVariable(String itemVariable) {
        return itemVariable + ITEM_LOOP_STATUS_SUFFIX;
    }
}

