/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.optimization;

import java.util.HashSet;
import java.util.Set;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.ArrayLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BinaryOperation;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BooleanConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.Identifier;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.MapLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.NullLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.NumericConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.PropertyAccess;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.TernaryOperator;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.UnaryOperation;
import org.apache.sling.scripting.sightly.impl.compiler.util.expression.SideEffectVisitor;

public class VariableFinder
extends SideEffectVisitor {
    private final Set<String> variables;

    public VariableFinder(Set<String> variables) {
        this.variables = variables;
    }

    private void traverse(ExpressionNode node) {
        if (node != null) {
            node.accept(this);
        }
    }

    public static Set<String> findVariables(ExpressionNode node) {
        HashSet<String> result = new HashSet<String>();
        VariableFinder finder = new VariableFinder(result);
        finder.traverse(node);
        return result;
    }

    @Override
    public void visit(PropertyAccess propertyAccess) {
        this.traverse(propertyAccess.getTarget());
        this.traverse(propertyAccess.getProperty());
    }

    @Override
    public void visit(Identifier identifier) {
        this.variables.add(identifier.getName());
    }

    @Override
    public void visit(StringConstant text) {
    }

    @Override
    public void visit(BinaryOperation binaryOperation) {
        this.traverse(binaryOperation.getLeftOperand());
        this.traverse(binaryOperation.getRightOperand());
    }

    @Override
    public void visit(BooleanConstant booleanConstant) {
    }

    @Override
    public void visit(NumericConstant numericConstant) {
    }

    @Override
    public void visit(UnaryOperation unaryOperation) {
        this.traverse(unaryOperation.getTarget());
    }

    @Override
    public void visit(TernaryOperator ternaryOperator) {
        this.traverse(ternaryOperator.getCondition());
        this.traverse(ternaryOperator.getThenBranch());
        this.traverse(ternaryOperator.getElseBranch());
    }

    @Override
    public void visit(RuntimeCall runtimeCall) {
        for (ExpressionNode node : runtimeCall.getArguments()) {
            this.traverse(node);
        }
    }

    @Override
    public void visit(MapLiteral mapLiteral) {
        for (ExpressionNode value : mapLiteral.getMap().values()) {
            this.traverse(value);
        }
    }

    @Override
    public void visit(ArrayLiteral arrayLiteral) {
        for (ExpressionNode item : arrayLiteral.getItems()) {
            this.traverse(item);
        }
    }

    @Override
    public void visit(NullLiteral nullLiteral) {
    }
}

