/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.sightly.impl.engine.ExtensionRegistryService;
import org.apache.sling.scripting.sightly.impl.engine.SightlyScriptEngineFactory;
import org.apache.sling.scripting.sightly.impl.engine.UnitLoader;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderContextImpl;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderUnit;

public class SightlyScriptEngine
extends AbstractSlingScriptEngine {
    private static final Bindings EMPTY_BINDINGS = new SimpleBindings(Collections.<String, Object>emptyMap());
    private final UnitLoader unitLoader;
    private final ExtensionRegistryService extensionRegistryService;

    public SightlyScriptEngine(ScriptEngineFactory scriptEngineFactory, UnitLoader unitLoader, ExtensionRegistryService extensionRegistryService) {
        super(scriptEngineFactory);
        this.unitLoader = unitLoader;
        this.extensionRegistryService = extensionRegistryService;
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((SightlyScriptEngineFactory)((Object)this.getFactory())).getClassLoader());
        this.checkArguments(reader, scriptContext);
        Bindings bindings = scriptContext.getBindings(100);
        SlingScriptHelper slingScriptHelper = (SlingScriptHelper)bindings.get("sling");
        Resource scriptResource = slingScriptHelper.getScript().getScriptResource();
        SlingBindings slingBindings = new SlingBindings();
        slingBindings.putAll((Map)bindings);
        SimpleBindings globalBindings = new SimpleBindings((Map<String, Object>)slingBindings);
        SlingHttpServletRequest request = slingBindings.getRequest();
        Object oldValue = request.getAttribute(SlingBindings.class.getName());
        ResourceResolver scriptResourceResolver = (ResourceResolver)scriptContext.getAttribute("org.apache.sling.api.scripting.ScriptResourceResolver", -314);
        try {
            request.setAttribute(SlingBindings.class.getName(), (Object)slingBindings);
            this.evaluateScript(scriptResource, globalBindings, scriptResourceResolver);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            request.setAttribute(SlingBindings.class.getName(), oldValue);
            Thread.currentThread().setContextClassLoader(old);
        }
        return null;
    }

    private void evaluateScript(Resource scriptResource, Bindings bindings, ResourceResolver scriptResourceResolver) throws Exception {
        RenderContextImpl renderContext = new RenderContextImpl(bindings, this.extensionRegistryService.extensions(), scriptResourceResolver);
        RenderUnit renderUnit = this.unitLoader.createUnit(scriptResource, renderContext);
        renderUnit.render(renderContext, EMPTY_BINDINGS);
    }

    private void checkArguments(Reader reader, ScriptContext scriptContext) {
        if (reader == null) {
            throw new NullPointerException("Reader cannot be null");
        }
        if (scriptContext == null) {
            throw new NullPointerException("ScriptContext cannot be null");
        }
    }
}

