/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.filter;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.scripting.sightly.impl.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.filter.Filter;
import org.osgi.service.component.ComponentContext;

public abstract class FilterComponent
implements Filter {
    public static final String PRIORITY = "org.apache.sling.scripting.sightly.impl.filter.priority";
    public static final int DEFAULT_PRIORITY = 100;
    private int priority = 100;

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public int compareTo(Filter o) {
        if (this.priority < o.priority()) {
            return -1;
        }
        if (this.priority == o.priority()) {
            return 0;
        }
        return 1;
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        this.priority = PropertiesUtil.toInteger(properties.get(PRIORITY), (int)100);
    }

    protected Map<String, ExpressionNode> getFilterOptions(Expression expression, String ... options) {
        HashMap<String, ExpressionNode> collector = new HashMap<String, ExpressionNode>();
        for (String option : options) {
            ExpressionNode optionNode = expression.removeOption(option);
            if (optionNode == null) continue;
            collector.put(option, optionNode);
        }
        return collector;
    }
}

