/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.impl.compiler.common.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.Identifier;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.MapLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.OutVariable;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Patterns;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.VariableBinding;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.PushStream;
import org.apache.sling.scripting.sightly.impl.plugin.Plugin;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginComponent;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

@Component
@Service(value={Plugin.class})
@Properties(value={@Property(name="service.description", value={"Sightly Include Block Plugin"}), @Property(name="org.apache.sling.scripting.sightly.impl.plugin.name", value={"include"}), @Property(name="org.apache.sling.scripting.sightly.impl.plugin.priority", intValue={100})})
public class IncludePlugin
extends PluginComponent {
    public static final String FUNCTION = "include";

    @Override
    public PluginInvoke invoke(final Expression expression, PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){

            @Override
            public void beforeChildren(PushStream stream) {
                String includedContentVar = compilerContext.generateVariable("includedResult");
                String pathVar = compilerContext.generateVariable("includePath");
                stream.emit(new VariableBinding.Start(pathVar, expression.getRoot()));
                stream.emit(new VariableBinding.Start(includedContentVar, new RuntimeCall(IncludePlugin.FUNCTION, new Identifier(pathVar), new MapLiteral(expression.getOptions()))));
                stream.emit(new OutVariable(includedContentVar));
                stream.emit(VariableBinding.END);
                stream.emit(VariableBinding.END);
                Patterns.beginStreamIgnore(stream);
            }

            @Override
            public void afterChildren(PushStream stream) {
                Patterns.endStreamIgnore(stream);
            }
        };
    }
}

