/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.scripting.api.AbstractScriptEngineFactory;
import org.apache.sling.scripting.sightly.compiler.SightlyCompiler;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.engine.SightlyJavaCompilerService;
import org.apache.sling.scripting.sightly.impl.engine.SightlyScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={ScriptEngineFactory.class})
@Properties(value={@Property(name="service.description", value={"HTL Templating Engine"}), @Property(name="compatible.javax.script.name", value={"sly"})})
public class SightlyScriptEngineFactory
extends AbstractScriptEngineFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SightlyScriptEngineFactory.class);
    @Reference
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    @Reference
    private SightlyEngineConfiguration sightlyEngineConfiguration;
    @Reference
    private ClassLoaderWriter classLoaderWriter;
    @Reference
    private SightlyCompiler sightlyCompiler;
    @Reference
    private SightlyJavaCompilerService sightlyJavaCompilerService;
    public static final String SHORT_NAME = "sightly";
    public static final String LANGUAGE_NAME = "The HTL Templating Language";
    public static final String LANGUAGE_VERSION = "1.0";
    public static final String EXTENSION = "html";
    public static final String SIGHTLY_CONFIG_FILE = "/sightly.config";

    public SightlyScriptEngineFactory() {
        this.setNames(new String[]{SHORT_NAME});
        this.setExtensions(new String[]{EXTENSION});
    }

    public String getLanguageName() {
        return LANGUAGE_NAME;
    }

    public String getLanguageVersion() {
        return LANGUAGE_VERSION;
    }

    public ScriptEngine getScriptEngine() {
        return new SightlyScriptEngine((ScriptEngineFactory)((Object)this), this.sightlyCompiler, this.sightlyJavaCompilerService, this.sightlyEngineConfiguration);
    }

    protected ClassLoader getClassLoader() {
        return this.dynamicClassLoaderManager.getDynamicClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate() {
        boolean newVersion = true;
        String versionInfo = null;
        String newVersionString = this.sightlyEngineConfiguration.getEngineVersion();
        try {
            InputStream is = this.classLoaderWriter.getInputStream(SIGHTLY_CONFIG_FILE);
            if (is != null) {
                versionInfo = IOUtils.toString((InputStream)is, (String)"UTF-8");
                if (newVersionString.equals(versionInfo)) {
                    newVersion = false;
                } else {
                    LOGGER.info("Detected stale classes generated by Apache Sling Scripting HTL engine version {}.", (Object)versionInfo);
                }
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (newVersion) {
            OutputStream os = this.classLoaderWriter.getOutputStream(SIGHTLY_CONFIG_FILE);
            try {
                IOUtils.write((String)this.sightlyEngineConfiguration.getEngineVersion(), (OutputStream)os, (String)"UTF-8");
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.closeQuietly((OutputStream)os);
            }
            String scratchFolder = this.sightlyEngineConfiguration.getScratchFolder();
            boolean scratchFolderDeleted = this.classLoaderWriter.delete(scratchFolder);
            if (scratchFolderDeleted && StringUtils.isNotEmpty((String)versionInfo)) {
                LOGGER.info("Deleted stale classes generated by Apache Sling Scripting HTL engine version {}.", (Object)versionInfo);
            }
        }
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.dynamicClassLoaderManager == dynamicClassLoaderManager) {
            this.dynamicClassLoaderManager = null;
        }
    }

    protected void bindSightlyEngineConfiguration(SightlyEngineConfiguration sightlyEngineConfiguration) {
        this.sightlyEngineConfiguration = sightlyEngineConfiguration;
    }

    protected void unbindSightlyEngineConfiguration(SightlyEngineConfiguration sightlyEngineConfiguration) {
        if (this.sightlyEngineConfiguration == sightlyEngineConfiguration) {
            this.sightlyEngineConfiguration = null;
        }
    }

    protected void bindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        this.classLoaderWriter = classLoaderWriter;
    }

    protected void unbindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        if (this.classLoaderWriter == classLoaderWriter) {
            this.classLoaderWriter = null;
        }
    }

    protected void bindSightlyCompiler(SightlyCompiler sightlyCompiler) {
        this.sightlyCompiler = sightlyCompiler;
    }

    protected void unbindSightlyCompiler(SightlyCompiler sightlyCompiler) {
        if (this.sightlyCompiler == sightlyCompiler) {
            this.sightlyCompiler = null;
        }
    }

    protected void bindSightlyJavaCompilerService(SightlyJavaCompilerService sightlyJavaCompilerService) {
        this.sightlyJavaCompilerService = sightlyJavaCompilerService;
    }

    protected void unbindSightlyJavaCompilerService(SightlyJavaCompilerService sightlyJavaCompilerService) {
        if (this.sightlyJavaCompilerService == sightlyJavaCompilerService) {
            this.sightlyJavaCompilerService = null;
        }
    }
}

