/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.compiled;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.java.compiler.ClassInfo;
import org.apache.sling.scripting.sightly.java.compiler.JavaEscapeUtils;

public class SourceIdentifier
implements ClassInfo {
    public static final Pattern MANGLED_CHAR_PATTER = Pattern.compile("(.*)(__[0-9a-f]{4}__)(.*)");
    private SightlyEngineConfiguration engineConfiguration;
    private String scriptName;
    private String simpleClassName;
    private String packageName;
    private String fullyQualifiedClassName;

    public SourceIdentifier(SightlyEngineConfiguration engineConfiguration, String scriptName) {
        this.engineConfiguration = engineConfiguration;
        this.scriptName = scriptName;
    }

    public String getSimpleClassName() {
        if (this.simpleClassName == null) {
            int lastSlashIndex = this.scriptName.lastIndexOf("/");
            String processingScriptName = this.scriptName;
            if (this.scriptName.endsWith(".java")) {
                processingScriptName = this.scriptName.substring(0, this.scriptName.length() - 5);
            }
            this.simpleClassName = lastSlashIndex != -1 ? JavaEscapeUtils.makeJavaPackage((String)processingScriptName.substring(lastSlashIndex)) : JavaEscapeUtils.makeJavaPackage((String)processingScriptName);
        }
        return this.simpleClassName;
    }

    public String getPackageName() {
        if (this.packageName == null) {
            int lastSlashIndex = this.scriptName.lastIndexOf("/");
            String processingScriptName = this.scriptName;
            boolean javaFile = this.scriptName.endsWith(".java");
            if (javaFile) {
                processingScriptName = this.scriptName.substring(0, this.scriptName.length() - 5);
            }
            this.packageName = lastSlashIndex != -1 ? JavaEscapeUtils.makeJavaPackage((String)processingScriptName.substring(0, lastSlashIndex)) : JavaEscapeUtils.makeJavaPackage((String)processingScriptName);
            if (!javaFile) {
                this.packageName = this.engineConfiguration.getBundleSymbolicName() + "." + this.packageName;
            }
        }
        return this.packageName;
    }

    public String getFullyQualifiedClassName() {
        if (this.fullyQualifiedClassName == null) {
            this.fullyQualifiedClassName = this.getPackageName() + "." + this.getSimpleClassName();
        }
        return this.fullyQualifiedClassName;
    }

    public static String getScriptName(String slashSubpackage, String fullyQualifiedClassName) {
        String className = fullyQualifiedClassName;
        StringBuilder pathElements = new StringBuilder("/");
        if (StringUtils.isNotEmpty((String)slashSubpackage) && className.contains(slashSubpackage)) {
            className = className.replaceAll(slashSubpackage + "\\.", "");
        }
        String[] classElements = StringUtils.split((String)className, (char)'.');
        for (int i = 0; i < classElements.length; ++i) {
            String classElem = classElements[i];
            Matcher matcher = MANGLED_CHAR_PATTER.matcher(classElem);
            if (matcher.matches()) {
                String group = matcher.group(2);
                char unmangled = JavaEscapeUtils.unmangle((String)group);
                classElem = classElem.replaceAll(group, Character.toString(unmangled));
                while (matcher.find()) {
                    group = matcher.group(2);
                    unmangled = JavaEscapeUtils.unmangle((String)group);
                    classElem = classElem.replaceAll(group, Character.toString(unmangled));
                }
            } else {
                int underscoreIndex = classElem.indexOf(95);
                if (underscoreIndex > -1) {
                    classElem = underscoreIndex == classElem.length() - 1 ? classElem.substring(0, classElem.length() - 1) : classElem.replaceAll("_", ".");
                }
            }
            pathElements.append(classElem);
            if (i >= classElements.length - 1) continue;
            pathElements.append("/");
        }
        return pathElements.toString();
    }
}

