/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.util.Collection;
import java.util.Iterator;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;

@Component
@Service(value={RuntimeExtension.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.extension.name", value={"join"})})
public class JoinFilterExtension
implements RuntimeExtension {
    public Object call(RenderContext renderContext, Object ... arguments) {
        ExtensionUtils.checkArgumentCount("join", arguments, 2);
        Object joinArgument = arguments[0];
        RuntimeObjectModel runtimeObjectModel = renderContext.getObjectModel();
        Collection collection = runtimeObjectModel.toCollection(joinArgument);
        String joinString = runtimeObjectModel.toString(arguments[1]);
        return this.join(runtimeObjectModel, collection, joinString);
    }

    private String join(RuntimeObjectModel runtimeObjectModel, Collection<?> collection, String joinString) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String element = runtimeObjectModel.toString(iterator.next());
            sb.append(element);
            if (!iterator.hasNext()) continue;
            sb.append(joinString);
        }
        return sb.toString();
    }
}

