/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.engine.extension.ExtensionUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.render.RuntimeObjectModel;

@Component
@Service(value={RuntimeExtension.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.extension.name", value={"uriManipulation"})})
public class URIManipulationFilterExtension
implements RuntimeExtension {
    public static final String SCHEME = "scheme";
    public static final String DOMAIN = "domain";
    public static final String PATH = "path";
    public static final String APPEND_PATH = "appendPath";
    public static final String PREPEND_PATH = "prependPath";
    public static final String SELECTORS = "selectors";
    public static final String ADD_SELECTORS = "addSelectors";
    public static final String REMOVE_SELECTORS = "removeSelectors";
    public static final String EXTENSION = "extension";
    public static final String SUFFIX = "suffix";
    public static final String PREPEND_SUFFIX = "prependSuffix";
    public static final String APPEND_SUFFIX = "appendSuffix";
    public static final String FRAGMENT = "fragment";
    public static final String QUERY = "query";
    public static final String ADD_QUERY = "addQuery";
    public static final String REMOVE_QUERY = "removeQuery";

    public Object call(RenderContext renderContext, Object ... arguments) {
        String fragment;
        String path;
        String prependPath;
        ExtensionUtils.checkArgumentCount("uriManipulation", arguments, 2);
        RuntimeObjectModel runtimeObjectModel = renderContext.getObjectModel();
        String uriString = runtimeObjectModel.toString(arguments[0]);
        Map options = runtimeObjectModel.toMap(arguments[1]);
        StringBuilder sb = new StringBuilder();
        PathInfo pathInfo = new PathInfo(uriString);
        this.uriAppender(sb, SCHEME, options, pathInfo.getScheme());
        if (sb.length() > 0) {
            sb.append(":");
            sb.append(StringUtils.defaultIfEmpty((String)pathInfo.getBeginPathSeparator(), (String)"//"));
        }
        if (sb.length() > 0) {
            this.uriAppender(sb, DOMAIN, options, pathInfo.getHost());
        } else {
            String domain = this.getOption(DOMAIN, options, pathInfo.getHost());
            if (StringUtils.isNotEmpty((String)domain)) {
                sb.append("//").append(domain);
            }
        }
        if (pathInfo.getPort() > -1) {
            sb.append(":").append(pathInfo.getPort());
        }
        if ((prependPath = this.getOption(PREPEND_PATH, options, "")) == null) {
            prependPath = "";
        }
        if (StringUtils.isEmpty((String)(path = this.getOption(PATH, options, pathInfo.getPath())))) {
            path = pathInfo.getPath();
        }
        if (StringUtils.isNotEmpty((String)path) && !"/".equals(path)) {
            String newSuffix;
            String appendSuffix;
            String pathInfoSuffix;
            String suffix;
            String prependSuffix;
            String newPath;
            String appendPath;
            if (StringUtils.isNotEmpty((String)prependPath)) {
                if (sb.length() > 0 && !prependPath.startsWith("/")) {
                    prependPath = "/" + prependPath;
                }
                if (!prependPath.endsWith("/")) {
                    prependPath = prependPath + "/";
                }
            }
            if ((appendPath = this.getOption(APPEND_PATH, options, "")) == null) {
                appendPath = "";
            }
            if (StringUtils.isNotEmpty((String)appendPath) && !appendPath.startsWith("/")) {
                appendPath = "/" + appendPath;
            }
            try {
                newPath = new URI(prependPath + path + appendPath).normalize().getPath();
            }
            catch (URISyntaxException e) {
                newPath = prependPath + path + appendPath;
            }
            if (sb.length() > 0 && sb.lastIndexOf("/") != sb.length() - 1 && StringUtils.isNotEmpty((String)newPath) && !newPath.startsWith("/")) {
                sb.append("/");
            }
            sb.append(newPath);
            Set<String> selectors = pathInfo.getSelectors();
            this.handleSelectors(runtimeObjectModel, selectors, options);
            for (String selector : selectors) {
                if (!StringUtils.isNotBlank((String)selector) || selector.contains(" ")) continue;
                sb.append(".").append(selector);
            }
            String extension = this.getOption(EXTENSION, options, pathInfo.getExtension());
            if (StringUtils.isNotEmpty((String)extension)) {
                sb.append(".").append(extension);
            }
            if (StringUtils.isNotEmpty((String)(prependSuffix = this.getOption(PREPEND_SUFFIX, options, "")))) {
                if (!prependSuffix.startsWith("/")) {
                    prependSuffix = "/" + prependSuffix;
                }
                if (!prependSuffix.endsWith("/")) {
                    prependSuffix = prependSuffix + "/";
                }
            }
            if ((suffix = this.getOption(SUFFIX, options, (pathInfoSuffix = pathInfo.getSuffix()) == null ? "" : pathInfoSuffix)) == null) {
                suffix = "";
            }
            if (StringUtils.isNotEmpty((String)(appendSuffix = this.getOption(APPEND_SUFFIX, options, "")))) {
                appendSuffix = "/" + appendSuffix;
            }
            if (StringUtils.isNotEmpty((String)(newSuffix = FilenameUtils.normalize((String)(prependSuffix + suffix + appendSuffix), (boolean)true)))) {
                if (!newSuffix.startsWith("/")) {
                    sb.append("/");
                }
                sb.append(newSuffix);
            }
        } else if ("/".equals(path)) {
            sb.append(path);
        }
        Map<String, Collection<String>> parameters = pathInfo.getParameters();
        this.handleParameters(runtimeObjectModel, parameters, options);
        if (sb.length() > 0 && !parameters.isEmpty()) {
            if (StringUtils.isEmpty((String)path)) {
                sb.append("/");
            }
            sb.append("?");
            for (Map.Entry<String, Collection<String>> entry : parameters.entrySet()) {
                for (String value : entry.getValue()) {
                    sb.append(entry.getKey()).append("=").append(value).append("&");
                }
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        if (StringUtils.isNotEmpty((String)(fragment = this.getOption(FRAGMENT, options, pathInfo.getFragment())))) {
            sb.append("#").append(fragment);
        }
        return sb.toString();
    }

    private void uriAppender(StringBuilder stringBuilder, String option, Map<String, Object> options, String defaultValue) {
        String value = (String)options.get(option);
        if (StringUtils.isNotEmpty((String)value)) {
            stringBuilder.append(value);
        } else if (StringUtils.isNotEmpty((String)defaultValue)) {
            stringBuilder.append(defaultValue);
        }
    }

    private String getOption(String option, Map<String, Object> options, String defaultValue) {
        if (options.containsKey(option)) {
            return (String)options.get(option);
        }
        return defaultValue;
    }

    private void handleSelectors(RuntimeObjectModel runtimeObjectModel, Set<String> selectors, Map<String, Object> options) {
        Object addSelectorsOption;
        int index;
        Object[] selectorsURIArray;
        String[] selectorsArray;
        String selectorString;
        if (options.containsKey(SELECTORS)) {
            Object selectorsOption = options.get(SELECTORS);
            if (selectorsOption == null) {
                selectors.clear();
            } else if (selectorsOption instanceof String) {
                selectorString = (String)selectorsOption;
                selectorsArray = selectorString.split("\\.");
                this.replaceSelectors(selectors, selectorsArray);
            } else if (selectorsOption instanceof Object[]) {
                selectorsURIArray = (Object[])selectorsOption;
                selectorsArray = new String[selectorsURIArray.length];
                index = 0;
                for (Object selector : selectorsURIArray) {
                    selectorsArray[index++] = runtimeObjectModel.toString(selector);
                }
                this.replaceSelectors(selectors, selectorsArray);
            }
        }
        if ((addSelectorsOption = options.get(ADD_SELECTORS)) instanceof String) {
            selectorString = (String)addSelectorsOption;
            selectorsArray = selectorString.split("\\.");
            this.addSelectors(selectors, selectorsArray);
        } else if (addSelectorsOption instanceof Object[]) {
            selectorsURIArray = (Object[])addSelectorsOption;
            selectorsArray = new String[selectorsURIArray.length];
            index = 0;
            for (Object selector : selectorsURIArray) {
                selectorsArray[index++] = runtimeObjectModel.toString(selector);
            }
            this.addSelectors(selectors, selectorsArray);
        }
        Object removeSelectorsOption = options.get(REMOVE_SELECTORS);
        if (removeSelectorsOption instanceof String) {
            String selectorString2 = (String)removeSelectorsOption;
            String[] selectorsArray2 = selectorString2.split("\\.");
            this.removeSelectors(selectors, selectorsArray2);
        } else if (removeSelectorsOption instanceof Object[]) {
            Object[] selectorsURIArray2 = (Object[])removeSelectorsOption;
            String[] selectorsArray3 = new String[selectorsURIArray2.length];
            int index2 = 0;
            for (Object selector : selectorsURIArray2) {
                selectorsArray3[index2++] = runtimeObjectModel.toString(selector);
            }
            this.removeSelectors(selectors, selectorsArray3);
        }
    }

    private void replaceSelectors(Set<String> selectors, String[] selectorsArray) {
        selectors.clear();
        selectors.addAll(Arrays.asList(selectorsArray));
    }

    private void addSelectors(Set<String> selectors, String[] selectorsArray) {
        selectors.addAll(Arrays.asList(selectorsArray));
    }

    private void removeSelectors(Set<String> selectors, String[] selectorsArray) {
        selectors.removeAll(Arrays.asList(selectorsArray));
    }

    private void handleParameters(RuntimeObjectModel runtimeObjectModel, Map<String, Collection<String>> parameters, Map<String, Object> options) {
        Object removeQueryOption;
        Object addQueryOption;
        if (options.containsKey(QUERY)) {
            Object queryOption = options.get(QUERY);
            parameters.clear();
            Map queryParameters = runtimeObjectModel.toMap(queryOption);
            this.addQueryParameters(runtimeObjectModel, parameters, queryParameters);
        }
        if ((addQueryOption = options.get(ADD_QUERY)) != null) {
            Map addParams = runtimeObjectModel.toMap(addQueryOption);
            this.addQueryParameters(runtimeObjectModel, parameters, addParams);
        }
        if ((removeQueryOption = options.get(REMOVE_QUERY)) != null) {
            if (removeQueryOption instanceof String) {
                parameters.remove(removeQueryOption);
            } else if (removeQueryOption instanceof Object[]) {
                Object[] removeQueryParamArray;
                for (Object param : removeQueryParamArray = (Object[])removeQueryOption) {
                    String paramString = runtimeObjectModel.toString(param);
                    if (paramString == null) continue;
                    parameters.remove(paramString);
                }
            }
        }
    }

    private void addQueryParameters(RuntimeObjectModel runtimeObjectModel, Map<String, Collection<String>> parameters, Map<String, Object> queryParameters) {
        for (Map.Entry<String, Object> entry : queryParameters.entrySet()) {
            Object entryValue = entry.getValue();
            if (runtimeObjectModel.isCollection(entryValue)) {
                Collection collection = runtimeObjectModel.toCollection(entryValue);
                ArrayList<String> values = new ArrayList<String>(collection.size());
                for (Object o : collection) {
                    values.add(runtimeObjectModel.toString(o));
                }
                parameters.put(entry.getKey(), values);
                continue;
            }
            ArrayList<String> values = new ArrayList<String>(1);
            values.add(runtimeObjectModel.toString(entryValue));
            parameters.put(entry.getKey(), values);
        }
    }

    public static class PathInfo {
        private URI uri;
        private String path;
        private Set<String> selectors;
        private String selectorString;
        private String extension;
        private String suffix;
        private Map<String, Collection<String>> parameters = new LinkedHashMap<String, Collection<String>>();

        public PathInfo(String path) {
            int firstDot;
            int lastDot;
            if (path == null) {
                throw new NullPointerException("The path parameter cannot be null.");
            }
            try {
                this.uri = new URI(path);
            }
            catch (URISyntaxException e) {
                throw new SightlyException("The provided path does not represent a valid URI: " + path);
            }
            this.selectors = new LinkedHashSet<String>();
            String processingPath = path;
            if (this.uri.getPath() != null) {
                processingPath = this.uri.getPath();
            }
            if ((lastDot = processingPath.lastIndexOf(46)) > -1) {
                String afterLastDot = processingPath.substring(lastDot + 1);
                String[] parts = afterLastDot.split("/");
                this.extension = parts[0];
                if (parts.length > 1) {
                    StringBuilder suffixSB = new StringBuilder();
                    for (int i = 1; i < parts.length; ++i) {
                        suffixSB.append("/").append(parts[i]);
                    }
                    int hashIndex = suffixSB.indexOf("#");
                    this.suffix = hashIndex > -1 ? suffixSB.substring(0, hashIndex) : suffixSB.toString();
                }
            }
            if ((firstDot = processingPath.indexOf(46)) < lastDot) {
                this.selectorString = processingPath.substring(firstDot + 1, lastDot);
                String[] selectorsArray = this.selectorString.split("\\.");
                this.selectors.addAll(Arrays.asList(selectorsArray));
            }
            int pathLength = processingPath.length() - (this.selectorString == null ? 0 : this.selectorString.length() + 1) - (this.extension == null ? 0 : this.extension.length() + 1) - (this.suffix == null ? 0 : this.suffix.length());
            this.path = pathLength == processingPath.length() ? processingPath : processingPath.substring(0, pathLength);
            String query = this.uri.getQuery();
            if (StringUtils.isNotEmpty((String)query)) {
                String[] keyValuePairs = query.split("&");
                for (int i = 0; i < keyValuePairs.length; ++i) {
                    String[] pair = keyValuePairs[i].split("=");
                    if (pair.length != 2) continue;
                    String param = pair[0];
                    String value = pair[1];
                    Collection<String> values = this.parameters.get(param);
                    if (values == null) {
                        values = new ArrayList<String>();
                        this.parameters.put(param, values);
                    }
                    values.add(value);
                }
            }
        }

        public String getScheme() {
            return this.uri.getScheme();
        }

        public String getBeginPathSeparator() {
            if (this.uri.isAbsolute()) {
                return "//";
            }
            return null;
        }

        public String getHost() {
            return this.uri.getHost();
        }

        public int getPort() {
            return this.uri.getPort();
        }

        public String getFullPath() {
            return this.uri.toString();
        }

        public String getPath() {
            return this.path;
        }

        public Set<String> getSelectors() {
            return this.selectors;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getSelectorString() {
            return this.selectorString;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getFragment() {
            return this.uri.getFragment();
        }

        public Map<String, Collection<String>> getParameters() {
            return this.parameters;
        }
    }
}

