/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension.use;

import java.io.InputStream;
import java.io.InputStreamReader;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.CachedScript;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.sightly.ResourceResolution;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.impl.engine.SightlyCompiledScript;
import org.apache.sling.scripting.sightly.impl.engine.SightlyScriptEngine;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderContextImpl;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;

@Component(metatype=true, label="Apache Sling Scripting HTL Render Unit Use Provider", description="The Render Unit Use Provider is responsible for instantiating HTL templates through the Use-API.")
@Service(value={UseProvider.class})
@Properties(value={@Property(name="service.ranking", label="Service Ranking", description="The Service Ranking value acts as the priority with which this Use Provider is queried to return an Use-object. A higher value represents a higher priority.", intValue={100}, propertyPrivate=false)})
public class RenderUnitProvider
implements UseProvider {
    @Reference
    private ScriptCache scriptCache;
    @Reference
    private ScriptEngineManager scriptEngineManager;

    public ProviderOutcome provide(String identifier, RenderContext renderContext, Bindings arguments) {
        if (identifier.endsWith(".html")) {
            RenderContextImpl rci = (RenderContextImpl)renderContext;
            Bindings globalBindings = renderContext.getBindings();
            SlingScriptHelper sling = BindingsUtils.getHelper(globalBindings);
            SlingHttpServletRequest request = BindingsUtils.getRequest(globalBindings);
            final Resource renderUnitResource = rci.resolveScript(identifier);
            if (renderUnitResource == null) {
                Resource caller = ResourceResolution.getResourceForRequest(request.getResourceResolver(), request);
                if (caller != null) {
                    String resourceSuperType = caller.getResourceSuperType();
                    StringBuilder errorMessage = new StringBuilder("Cannot find resource ");
                    errorMessage.append(identifier).append(" for base path ").append(caller.getPath());
                    if (StringUtils.isNotEmpty((String)resourceSuperType)) {
                        errorMessage.append(" with resource super type ").append(resourceSuperType);
                    }
                    errorMessage.append(".");
                    return ProviderOutcome.failure((Throwable)((Object)new SightlyException(errorMessage.toString())));
                }
                return ProviderOutcome.failure((Throwable)((Object)new SightlyException("Cannot resolve template " + identifier + " for script " + sling.getScript().getScriptResource().getPath())));
            }
            try {
                SightlyCompiledScript compiledScript;
                CachedScript cachedScript = this.scriptCache.getScript(renderUnitResource.getPath());
                if (cachedScript != null) {
                    compiledScript = (SightlyCompiledScript)cachedScript.getCompiledScript();
                } else {
                    InputStream inputStream;
                    SightlyScriptEngine sightlyScriptEngine = (SightlyScriptEngine)((Object)this.scriptEngineManager.getEngineByName("sightly"));
                    String encoding = renderUnitResource.getResourceMetadata().getCharacterEncoding();
                    if (StringUtils.isEmpty((String)encoding)) {
                        encoding = "UTF-8";
                    }
                    if ((inputStream = (InputStream)renderUnitResource.adaptTo(InputStream.class)) == null) {
                        return ProviderOutcome.failure();
                    }
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream, encoding);
                    compiledScript = (SightlyCompiledScript)sightlyScriptEngine.compile(inputStreamReader);
                    this.scriptCache.putScript(new CachedScript(){

                        public String getScriptPath() {
                            return renderUnitResource.getPath();
                        }

                        public CompiledScript getCompiledScript() {
                            return compiledScript;
                        }
                    });
                }
                RenderUnit renderUnit = compiledScript.getRenderUnit();
                return ProviderOutcome.success((Object)renderUnit);
            }
            catch (Exception e) {
                return ProviderOutcome.failure((Throwable)e);
            }
        }
        return ProviderOutcome.failure();
    }

    protected void bindScriptCache(ScriptCache scriptCache) {
        this.scriptCache = scriptCache;
    }

    protected void unbindScriptCache(ScriptCache scriptCache) {
        if (this.scriptCache == scriptCache) {
            this.scriptCache = null;
        }
    }

    protected void bindScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    protected void unbindScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        if (this.scriptEngineManager == scriptEngineManager) {
            this.scriptEngineManager = null;
        }
    }
}

