/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension.use;

import java.util.Map;
import javax.script.Bindings;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderContextImpl;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Sling Scripting HTL Script Use Provider", description="The Script Use Provider is responsible for instantiating objects from scripts evaluated by other Sling Scripting Engines.")
@Service(value={UseProvider.class})
@Properties(value={@Property(name="service.ranking", label="Service Ranking", description="The Service Ranking value acts as the priority with which this Use Provider is queried to return an Use-object. A higher value represents a higher priority.", intValue={0}, propertyPrivate=false)})
public class ScriptUseProvider
implements UseProvider {
    private static final Logger log = LoggerFactory.getLogger(ScriptUseProvider.class);

    public ProviderOutcome provide(String scriptName, RenderContext renderContext, Bindings arguments) {
        RenderContextImpl rci = (RenderContextImpl)renderContext;
        Bindings globalBindings = rci.getBindings();
        Bindings bindings = BindingsUtils.merge(globalBindings, arguments);
        String extension = this.scriptExtension(scriptName);
        if (extension == null || extension.equals("html")) {
            return ProviderOutcome.failure();
        }
        Resource scriptResource = rci.resolveScript(scriptName);
        if (scriptResource == null) {
            log.debug("Path does not match an existing resource: {}", (Object)scriptName);
            return ProviderOutcome.failure();
        }
        return this.evalScript(scriptResource, bindings);
    }

    private ProviderOutcome evalScript(Resource scriptResource, Bindings bindings) {
        SlingScript slingScript = (SlingScript)scriptResource.adaptTo(SlingScript.class);
        if (slingScript == null) {
            return ProviderOutcome.failure();
        }
        SlingBindings slingBindings = new SlingBindings();
        slingBindings.putAll((Map)bindings);
        Object scriptEval = slingScript.eval(slingBindings);
        return ProviderOutcome.notNullOrFailure((Object)scriptEval);
    }

    private String scriptExtension(String path) {
        String extension = StringUtils.substringAfterLast((String)path, (String)".");
        if (StringUtils.isEmpty((String)extension)) {
            extension = null;
        }
        return extension;
    }
}

