/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.compiled;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.scripting.sightly.impl.compiler.UnitChangeMonitor;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.utils.JavaEscapeUtils;

public class SourceIdentifier {
    private final String className;
    private final Resource resource;
    private final String packageName;
    private final String fullyQualifiedName;
    private SightlyEngineConfiguration configuration;
    private UnitChangeMonitor unitChangeMonitor;
    private ClassLoaderWriter writer;

    public SourceIdentifier(SightlyEngineConfiguration configuration, UnitChangeMonitor unitChangeMonitor, ClassLoaderWriter writer, Resource resource, String classNamePrefix) {
        this.resource = resource;
        this.className = this.buildClassName(resource, classNamePrefix);
        this.packageName = this.buildPackageName(resource);
        this.fullyQualifiedName = this.buildFullyQualifiedName(this.packageName, this.className);
        this.configuration = configuration;
        this.unitChangeMonitor = unitChangeMonitor;
        this.writer = writer;
    }

    public String getClassName() {
        return this.className;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public boolean needsUpdate() {
        if (this.configuration.isDevMode()) {
            return true;
        }
        String slyPath = this.getResource().getPath();
        long slyScriptChangeDate = this.unitChangeMonitor.getLastModifiedDateForScript(slyPath);
        String javaCompilerPath = "/" + this.getFullyQualifiedName().replaceAll("\\.", "/") + ".class";
        long javaFileDate = this.writer.getLastModified(javaCompilerPath);
        return slyScriptChangeDate == 0L && javaFileDate > -1L || slyScriptChangeDate > javaFileDate;
    }

    private String buildFullyQualifiedName(String packageName, String className) {
        return packageName + "." + className;
    }

    private String buildClassName(Resource resource, String classNamePrefix) {
        String scriptName = ResourceUtil.getName((String)resource.getPath());
        scriptName = scriptName.substring(0, scriptName.lastIndexOf(this.getExtension(scriptName)));
        String className = classNamePrefix + scriptName;
        return className.replaceAll("-", "_").replaceAll("\\.", "_");
    }

    private String buildPackageName(Resource resource) {
        String packageName = ResourceUtil.getParent((String)resource.getPath()).replaceAll("/", ".").substring(1).replaceAll("-", "_");
        String[] packageNameElements = packageName.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < packageNameElements.length; ++i) {
            String subPackage = packageNameElements[i];
            sb.append(JavaEscapeUtils.getEscapedToken(subPackage));
            if (i == packageNameElements.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    private String getExtension(String scriptName) {
        int lastDotIndex = scriptName.lastIndexOf(46);
        return scriptName.substring(lastDotIndex);
    }
}

