/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.apache.sling.scripting.sightly.impl.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.filter.Filter;
import org.apache.sling.scripting.sightly.impl.filter.FilterComponent;
import org.apache.sling.scripting.sightly.impl.utils.RenderUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;

@Component
@Service(value={Filter.class, RuntimeExtension.class})
@Properties(value={@Property(name="org.apache.sling.scripting.sightly.extension.name", value={"format"})})
public class FormatFilter
extends FilterComponent
implements RuntimeExtension {
    public static final String FORMAT_OPTION = "format";
    public static final String FORMAT_FUNCTION = "format";
    private static final Pattern PLACEHOLDER_REGEX = Pattern.compile("\\{\\d}");

    @Override
    public Expression apply(Expression expression, ExpressionContext expressionContext) {
        if (!expression.containsOption("format") || expressionContext == ExpressionContext.PLUGIN_DATA_SLY_USE || expressionContext == ExpressionContext.PLUGIN_DATA_SLY_TEMPLATE || expressionContext == ExpressionContext.PLUGIN_DATA_SLY_CALL) {
            return expression;
        }
        ExpressionNode argNode = expression.getOption("format");
        RuntimeCall formattedNode = new RuntimeCall("format", expression.getRoot(), argNode);
        return expression.withNode(formattedNode).withRemovedOptions("format");
    }

    @Override
    public Object call(RenderContext renderContext, Object ... arguments) {
        if (arguments.length != 2) {
            throw new SightlyException("Format function must be called with two arguments");
        }
        String source = RenderUtils.toString(arguments[0]);
        Object[] params = this.decodeParams(arguments[1]);
        return this.replace(source, params);
    }

    private Object[] decodeParams(Object paramObj) {
        if (RenderUtils.isCollection(paramObj)) {
            return RenderUtils.toCollection(paramObj).toArray();
        }
        return new Object[]{paramObj};
    }

    private String replace(String source, Object[] params) {
        Matcher matcher = PLACEHOLDER_REGEX.matcher(source);
        StringBuilder builder = new StringBuilder();
        int lastPos = 0;
        boolean matched = true;
        while (matched) {
            matched = matcher.find();
            if (!matched) continue;
            int paramIndex = this.placeholderIndex(matcher.group());
            String replacement = this.param(params, paramIndex);
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            builder.append(source, lastPos, matchStart).append(replacement);
            lastPos = matchEnd;
        }
        builder.append(source, lastPos, source.length());
        return builder.toString();
    }

    private String param(Object[] params, int index) {
        if (index >= 0 && index < params.length) {
            return RenderUtils.toString(params[index]);
        }
        return "";
    }

    private int placeholderIndex(String placeholder) {
        return Integer.parseInt(placeholder.substring(1, placeholder.length() - 1));
    }
}

