/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.html.dom;

import java.io.IOException;
import java.io.StringReader;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.scripting.sightly.impl.html.dom.MarkupHandler;
import org.apache.sling.scripting.sightly.impl.html.dom.TreeTraverser;
import org.apache.sling.scripting.sightly.impl.html.dom.template.Template;
import org.apache.sling.scripting.sightly.impl.html.dom.template.TemplateParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(name="service.description", value={"Sightly Simple HTML parser"}), @Property(name="service.ranking", intValue={1000})})
@Service(value={HtmlParserService.class})
public class HtmlParserService {
    private static final Logger log = LoggerFactory.getLogger(HtmlParserService.class);

    public void parse(String document, MarkupHandler handler) {
        try {
            StringReader sr = new StringReader(document);
            TemplateParser parser = new TemplateParser();
            Template template = parser.parse(sr);
            TreeTraverser tree = new TreeTraverser(handler);
            tree.traverse(template);
        }
        catch (IOException e) {
            log.error("Failed to parse Sightly template", (Throwable)e);
        }
    }
}

