/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiled;

import java.util.Map;
import org.apache.sling.scripting.sightly.impl.compiled.GenHelper;
import org.apache.sling.scripting.sightly.impl.compiled.JavaSource;
import org.apache.sling.scripting.sightly.impl.compiled.Type;
import org.apache.sling.scripting.sightly.impl.compiled.TypeInfo;
import org.apache.sling.scripting.sightly.impl.compiled.VariableAnalyzer;
import org.apache.sling.scripting.sightly.impl.compiled.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.Operators;
import org.apache.sling.scripting.sightly.impl.compiled.operator.UnaryOpGen;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.ArrayLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BinaryOperation;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BooleanConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.Identifier;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.MapLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.NullLiteral;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.NumericConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.PropertyAccess;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.TernaryOperator;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.UnaryOperation;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.UnaryOperator;
import org.apache.sling.scripting.sightly.impl.compiler.util.expression.SideEffectVisitor;

public final class ExpressionTranslator
extends SideEffectVisitor {
    private final JavaSource source;
    private final VariableAnalyzer analyzer;
    private final TypeInfo typeInfo;

    private ExpressionTranslator(JavaSource source, VariableAnalyzer analyzer, TypeInfo typeInfo) {
        this.source = source;
        this.analyzer = analyzer;
        this.typeInfo = typeInfo;
    }

    public static void buildExpression(ExpressionNode node, JavaSource source, VariableAnalyzer analyzer, TypeInfo typeInfo) {
        ExpressionTranslator builder = new ExpressionTranslator(source, analyzer, typeInfo);
        builder.traverse(node);
    }

    public void traverse(ExpressionNode node) {
        this.visit(node);
    }

    private void visit(ExpressionNode node) {
        node.accept(this);
    }

    @Override
    public void visit(PropertyAccess propertyAccess) {
        if (this.typeInfo.typeOf(propertyAccess.getTarget()) == Type.MAP) {
            this.visit(propertyAccess.getTarget());
            this.source.startCall("get", true);
            this.visit(propertyAccess.getProperty());
            this.source.endCall();
        } else {
            this.source.startMethodCall("RenderUtils", "resolveProperty");
            this.visit(propertyAccess.getTarget());
            this.source.separateArgument();
            this.visit(propertyAccess.getProperty());
            this.source.endCall();
        }
    }

    @Override
    public void visit(Identifier identifier) {
        String safeName = this.analyzer.assignedName(identifier.getName());
        this.source.append(safeName);
    }

    @Override
    public void visit(StringConstant text) {
        this.source.stringLiteral(text.getText());
    }

    @Override
    public void visit(BinaryOperation binaryOperation) {
        BinaryOpGen opGen = Operators.generatorFor(binaryOperation.getOperator());
        this.source.startExpression();
        opGen.generate(this.source, this, this.typeInfo.getTyped(binaryOperation.getLeftOperand()), this.typeInfo.getTyped(binaryOperation.getRightOperand()));
        this.source.endExpression();
    }

    @Override
    public void visit(BooleanConstant booleanConstant) {
        this.source.append(Boolean.toString(booleanConstant.getValue()));
    }

    @Override
    public void visit(NumericConstant numericConstant) {
        this.source.append(numericConstant.getValue().toString());
    }

    @Override
    public void visit(UnaryOperation unaryOperation) {
        UnaryOperator operator = unaryOperation.getOperator();
        ExpressionNode operand = unaryOperation.getTarget();
        UnaryOpGen unaryOpGen = Operators.generatorFor(operator);
        this.source.startExpression();
        unaryOpGen.generate(this.source, this, this.typeInfo.getTyped(operand));
        this.source.endExpression();
    }

    @Override
    public void visit(TernaryOperator ternaryOperator) {
        GenHelper.generateTernary(this.source, this, this.typeInfo.getTyped(ternaryOperator.getCondition()), this.typeInfo.getTyped(ternaryOperator.getThenBranch()), this.typeInfo.getTyped(ternaryOperator.getElseBranch()));
    }

    @Override
    public void visit(RuntimeCall runtimeCall) {
        this.source.startMethodCall("renderContext", "call").stringLiteral(runtimeCall.getFunctionName());
        for (ExpressionNode arg : runtimeCall.getArguments()) {
            this.source.separateArgument();
            this.visit(arg);
        }
        this.source.endCall();
    }

    @Override
    public void visit(MapLiteral mapLiteral) {
        this.source.startCall("obj").endCall();
        for (Map.Entry<String, ExpressionNode> entry : mapLiteral.getMap().entrySet()) {
            this.source.startCall("with", true).stringLiteral(entry.getKey()).separateArgument();
            this.visit(entry.getValue());
            this.source.endCall();
        }
    }

    @Override
    public void visit(ArrayLiteral arrayLiteral) {
        this.source.startExpression().startArray();
        boolean needsComma = false;
        for (ExpressionNode node : arrayLiteral.getItems()) {
            if (needsComma) {
                this.source.separateArgument();
            }
            this.visit(node);
            needsComma = true;
        }
        this.source.endArray().endExpression();
    }

    @Override
    public void visit(NullLiteral nullLiteral) {
        this.source.nullLiteral();
    }

    public VariableAnalyzer getAnalyzer() {
        return this.analyzer;
    }
}

