/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiled.operator;

import org.apache.sling.scripting.sightly.impl.compiled.ExpressionTranslator;
import org.apache.sling.scripting.sightly.impl.compiled.GenHelper;
import org.apache.sling.scripting.sightly.impl.compiled.JavaSource;
import org.apache.sling.scripting.sightly.impl.compiled.Type;
import org.apache.sling.scripting.sightly.impl.compiled.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.impl.compiled.operator.OpHelper;
import org.apache.sling.scripting.sightly.impl.compiled.operator.TypedNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.util.expression.SideEffectVisitor;

public abstract class LogicalOpGen
implements BinaryOpGen {
    private final String javaOperator;
    public static final LogicalOpGen AND = new LogicalOpGen("&&"){

        @Override
        protected void generateGeneric(JavaSource source, SideEffectVisitor visitor, TypedNode left, TypedNode right) {
            GenHelper.generateTernary(source, visitor, left, right, left);
        }
    };
    public static final LogicalOpGen OR = new LogicalOpGen("||"){

        @Override
        protected void generateGeneric(JavaSource source, SideEffectVisitor visitor, TypedNode left, TypedNode right) {
            GenHelper.generateTernary(source, visitor, left, left, right);
        }
    };

    protected LogicalOpGen(String javaOperator) {
        this.javaOperator = javaOperator;
    }

    @Override
    public Type returnType(Type leftType, Type rightType) {
        if (leftType == rightType) {
            return leftType;
        }
        return Type.UNKNOWN;
    }

    @Override
    public void generate(JavaSource source, ExpressionTranslator visitor, TypedNode left, TypedNode right) {
        if (OpHelper.sameType(left, right) == Type.BOOLEAN) {
            this.generateWithOperator(source, visitor, left.getNode(), right.getNode());
        } else {
            this.generateGeneric(source, visitor, left, right);
        }
    }

    protected abstract void generateGeneric(JavaSource var1, SideEffectVisitor var2, TypedNode var3, TypedNode var4);

    private void generateWithOperator(JavaSource source, SideEffectVisitor visitor, ExpressionNode leftNode, ExpressionNode rightNode) {
        leftNode.accept(visitor);
        source.append(this.javaOperator);
        rightNode.accept(visitor);
    }
}

