/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.expression;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;

public class Expression {
    private final Map<String, ExpressionNode> options;
    private final ExpressionNode root;

    public Expression(ExpressionNode root, Map<String, ExpressionNode> options) {
        this.root = root;
        this.options = new HashMap<String, ExpressionNode>(options);
    }

    public Expression(ExpressionNode root) {
        this(root, Collections.emptyMap());
    }

    public Map<String, ExpressionNode> getOptions() {
        return this.options;
    }

    public ExpressionNode getRoot() {
        return this.root;
    }

    public ExpressionNode getOption(String name) {
        return this.options.get(name);
    }

    public Expression withRemovedOptions(String ... removedOptions) {
        HashMap<String, ExpressionNode> newOptions = new HashMap<String, ExpressionNode>(this.options);
        for (String option : removedOptions) {
            newOptions.remove(option);
        }
        return new Expression(this.root, newOptions);
    }

    public void removeOptions(String ... removedOptions) {
        for (String option : removedOptions) {
            this.options.remove(option);
        }
    }

    public ExpressionNode removeOption(String option) {
        return this.options.remove(option);
    }

    public Expression withNode(ExpressionNode node) {
        return new Expression(node, this.options);
    }

    public boolean containsOption(String name) {
        return this.options.containsKey(name);
    }

    public String toString() {
        return "Expression{options=" + this.getOptions() + ", root=" + this.root + '}';
    }
}

