/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.ris.command;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.scripting.sightly.impl.compiler.ris.Command;
import org.apache.sling.scripting.sightly.impl.compiler.ris.CommandVisitor;

public class Procedure {
    public static final End END = new End();

    public static class Call
    implements Command {
        private final String templateVariable;
        private final String argumentsVariable;

        public Call(String templateVariable, String argumentsVariable) {
            this.templateVariable = templateVariable;
            this.argumentsVariable = argumentsVariable;
        }

        public String getTemplateVariable() {
            return this.templateVariable;
        }

        public String getArgumentsVariable() {
            return this.argumentsVariable;
        }

        @Override
        public void accept(CommandVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static final class End
    implements Command {
        private End() {
        }

        @Override
        public void accept(CommandVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Start
    implements Command {
        private String name;
        private Set<String> parameters;

        public Start(String name, Set<String> parameters) {
            this.name = name;
            this.parameters = new HashSet<String>(parameters);
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getParameters() {
            return Collections.unmodifiableSet(this.parameters);
        }

        @Override
        public void accept(CommandVisitor visitor) {
            visitor.visit(this);
        }
    }
}

