/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.scripting.api.AbstractScriptEngineFactory;
import org.apache.sling.scripting.sightly.impl.engine.ExtensionRegistryService;
import org.apache.sling.scripting.sightly.impl.engine.SightlyScriptEngine;
import org.apache.sling.scripting.sightly.impl.engine.UnitLoader;

@Component
@Service(value={ScriptEngineFactory.class})
@Properties(value={@Property(name="service.description", value={"Sightly Templating Engine"}), @Property(name="compatible.javax.script.name", value={"sly"})})
public class SightlyScriptEngineFactory
extends AbstractScriptEngineFactory {
    @Reference
    private UnitLoader unitLoader = null;
    @Reference
    private ExtensionRegistryService extensionRegistryService = null;
    @Reference
    private DynamicClassLoaderManager dynamicClassLoaderManager = null;
    public static final String SHORT_NAME = "sightly";
    public static final String LANGUAGE_NAME = "The Sightly Templating Language";
    public static final String LANGUAGE_VERSION = "1.0";
    public static final String EXTENSION = "html";

    public SightlyScriptEngineFactory() {
        this.setNames(new String[]{SHORT_NAME});
        this.setExtensions(new String[]{EXTENSION});
    }

    public String getLanguageName() {
        return LANGUAGE_NAME;
    }

    public String getLanguageVersion() {
        return LANGUAGE_VERSION;
    }

    public ScriptEngine getScriptEngine() {
        return new SightlyScriptEngine((ScriptEngineFactory)((Object)this), this.unitLoader, this.extensionRegistryService);
    }

    protected ClassLoader getClassLoader() {
        return this.dynamicClassLoaderManager.getDynamicClassLoader();
    }

    protected void bindUnitLoader(UnitLoader unitLoader) {
        this.unitLoader = unitLoader;
    }

    protected void unbindUnitLoader(UnitLoader unitLoader) {
        if (this.unitLoader == unitLoader) {
            this.unitLoader = null;
        }
    }

    protected void bindExtensionRegistryService(ExtensionRegistryService extensionRegistryService) {
        this.extensionRegistryService = extensionRegistryService;
    }

    protected void unbindExtensionRegistryService(ExtensionRegistryService extensionRegistryService) {
        if (this.extensionRegistryService == extensionRegistryService) {
            this.extensionRegistryService = null;
        }
    }

    protected void bindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    protected void unbindDynamicClassLoaderManager(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.dynamicClassLoaderManager == dynamicClassLoaderManager) {
            this.dynamicClassLoaderManager = null;
        }
    }
}

