/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.script.Bindings;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.classloader.ClassLoaderWriter;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.impl.compiled.CompilationOutput;
import org.apache.sling.scripting.sightly.impl.compiled.JavaClassBackend;
import org.apache.sling.scripting.sightly.impl.compiler.SightlyCompilerService;
import org.apache.sling.scripting.sightly.impl.compiler.SightlyJavaCompilerService;
import org.apache.sling.scripting.sightly.impl.compiler.SightlyParsingException;
import org.apache.sling.scripting.sightly.impl.compiler.UnitChangeMonitor;
import org.apache.sling.scripting.sightly.impl.compiler.util.GlobalShadowCheckBackend;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.engine.compiled.JavaClassTemplate;
import org.apache.sling.scripting.sightly.impl.engine.compiled.SourceIdentifier;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={UnitLoader.class})
public class UnitLoader {
    public static final String CLASS_NAME_PREFIX = "SightlyJava_";
    private static final Logger log = LoggerFactory.getLogger(UnitLoader.class);
    private static final String MAIN_TEMPLATE_PATH = "templates/compiled_unit_template.txt";
    private static final String CHILD_TEMPLATE_PATH = "templates/subtemplate.txt";
    private String mainTemplate;
    private String childTemplate;
    @Reference
    private SightlyCompilerService sightlyCompilerService = null;
    @Reference
    private SightlyJavaCompilerService sightlyJavaCompilerService = null;
    @Reference
    private SightlyEngineConfiguration sightlyEngineConfiguration = null;
    @Reference
    private ClassLoaderWriter classLoaderWriter = null;
    @Reference
    private UnitChangeMonitor unitChangeMonitor = null;

    public RenderUnit createUnit(Resource scriptResource, RenderContext renderContext) throws Exception {
        Object obj;
        ResourceResolver adminResolver = renderContext.getScriptResourceResolver();
        SourceIdentifier sourceIdentifier = new SourceIdentifier(this.sightlyEngineConfiguration, this.unitChangeMonitor, this.classLoaderWriter, scriptResource, CLASS_NAME_PREFIX);
        String encoding = this.unitChangeMonitor.getScriptEncoding(scriptResource.getPath());
        if (sourceIdentifier.needsUpdate()) {
            String sourceCode = this.getSourceCodeForScript(adminResolver, sourceIdentifier, renderContext.getBindings(), encoding);
            obj = this.sightlyJavaCompilerService.compileSource(sourceIdentifier, sourceCode, sourceIdentifier.getFullyQualifiedName());
        } else {
            obj = this.sightlyJavaCompilerService.getInstance(renderContext, sourceIdentifier.getFullyQualifiedName(), false);
        }
        if (!(obj instanceof RenderUnit)) {
            throw new SightlyException("Class is not a RenderUnit instance");
        }
        SlingHttpServletResponse response = (SlingHttpServletResponse)renderContext.getBindings().get("response");
        response.setCharacterEncoding(encoding);
        return (RenderUnit)obj;
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.mainTemplate = this.resourceFile(componentContext, MAIN_TEMPLATE_PATH);
        this.childTemplate = this.resourceFile(componentContext, CHILD_TEMPLATE_PATH);
    }

    private String getSourceCodeForScript(ResourceResolver resolver, SourceIdentifier identifier, Bindings bindings, String encoding) {
        String scriptSource = null;
        try {
            Resource scriptResource = resolver.getResource(identifier.getResource().getPath());
            if (scriptResource != null) {
                scriptSource = IOUtils.toString((InputStream)((InputStream)scriptResource.adaptTo(InputStream.class)), (String)encoding);
                return this.obtainResultSource(scriptSource, identifier, bindings);
            }
            throw new SightlyException("Cannot find template " + identifier.getResource().getPath() + " in the repository.");
        }
        catch (SightlyParsingException e) {
            String offendingInput = e.getOffendingInput();
            if (StringUtils.isNotEmpty((String)offendingInput)) {
                offendingInput = StringEscapeUtils.unescapeHtml((String)offendingInput.trim());
                int errorLine = this.getLineWhereErrorOccurred(scriptSource, offendingInput);
                throw new SightlyException("Parsing error in template " + identifier.getResource().getPath() + " at line " + errorLine + ": " + e.getMessage() + " for expression " + offendingInput);
            }
            throw e;
        }
        catch (IOException e) {
            throw new SightlyException("Unable to read the contents of " + identifier.getResource().getPath(), e);
        }
    }

    private String obtainResultSource(String scriptSource, SourceIdentifier identifier, Bindings bindings) {
        JavaClassTemplate classTemplate = this.newMainTemplate();
        classTemplate.setClassName(identifier.getClassName());
        classTemplate.setPackageName(identifier.getPackageName());
        CompilationOutput compilationOutput = this.obtainOutput(scriptSource, bindings);
        this.processCompilationResult(compilationOutput, classTemplate);
        return classTemplate.toString();
    }

    private CompilationOutput obtainOutput(String source, Bindings bindings) {
        JavaClassBackend backend = new JavaClassBackend();
        this.sightlyCompilerService.compile(source, new GlobalShadowCheckBackend(backend, bindings.keySet()));
        return backend.build();
    }

    private void processCompilationResult(CompilationOutput result, JavaClassTemplate mainTemplate) {
        mainTemplate.writeMainBody(result.getMainBody());
        for (Map.Entry<String, CompilationOutput> entry : result.getSubTemplates().entrySet()) {
            JavaClassTemplate childTemplate = this.newChildTemplate();
            this.processCompilationResult(entry.getValue(), childTemplate);
            mainTemplate.writeSubTemplate(entry.getKey(), childTemplate.toString());
        }
    }

    private JavaClassTemplate newMainTemplate() {
        return new JavaClassTemplate(this.mainTemplate);
    }

    private JavaClassTemplate newChildTemplate() {
        return new JavaClassTemplate(this.childTemplate);
    }

    private String resourceFile(ComponentContext componentContext, String path) {
        InputStream inputStream = null;
        try {
            URL url = componentContext.getBundleContext().getBundle().getEntry(path);
            if (url == null) {
                throw new SightlyException("No bundle resource resides at " + path);
            }
            inputStream = componentContext.getBundleContext().getBundle().getEntry(path).openStream();
            String string = IOUtils.toString((InputStream)inputStream);
            return string;
        }
        catch (IOException e) {
            throw new SightlyException("Java class templates could not be found");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("Error when closing bundle resource stream", (Throwable)e);
                }
            }
        }
    }

    private int getLineWhereErrorOccurred(String documentFragment, String offendingInput) {
        int offendingInputIndex = documentFragment.indexOf(offendingInput);
        String textBeforeError = documentFragment.substring(0, offendingInputIndex);
        int line = 0;
        int newLine = 0;
        while (textBeforeError.length() > 0 && newLine != -1) {
            newLine = textBeforeError.indexOf("\n");
            if (newLine == -1) continue;
            ++line;
            textBeforeError = textBeforeError.substring(newLine + 1, textBeforeError.length());
        }
        return ++line;
    }

    protected void bindSightlyCompilerService(SightlyCompilerService sightlyCompilerService) {
        this.sightlyCompilerService = sightlyCompilerService;
    }

    protected void unbindSightlyCompilerService(SightlyCompilerService sightlyCompilerService) {
        if (this.sightlyCompilerService == sightlyCompilerService) {
            this.sightlyCompilerService = null;
        }
    }

    protected void bindSightlyJavaCompilerService(SightlyJavaCompilerService sightlyJavaCompilerService) {
        this.sightlyJavaCompilerService = sightlyJavaCompilerService;
    }

    protected void unbindSightlyJavaCompilerService(SightlyJavaCompilerService sightlyJavaCompilerService) {
        if (this.sightlyJavaCompilerService == sightlyJavaCompilerService) {
            this.sightlyJavaCompilerService = null;
        }
    }

    protected void bindSightlyEngineConfiguration(SightlyEngineConfiguration sightlyEngineConfiguration) {
        this.sightlyEngineConfiguration = sightlyEngineConfiguration;
    }

    protected void unbindSightlyEngineConfiguration(SightlyEngineConfiguration sightlyEngineConfiguration) {
        if (this.sightlyEngineConfiguration == sightlyEngineConfiguration) {
            this.sightlyEngineConfiguration = null;
        }
    }

    protected void bindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        this.classLoaderWriter = classLoaderWriter;
    }

    protected void unbindClassLoaderWriter(ClassLoaderWriter classLoaderWriter) {
        if (this.classLoaderWriter == classLoaderWriter) {
            this.classLoaderWriter = null;
        }
    }

    protected void bindUnitChangeMonitor(UnitChangeMonitor unitChangeMonitor) {
        this.unitChangeMonitor = unitChangeMonitor;
    }

    protected void unbindUnitChangeMonitor(UnitChangeMonitor unitChangeMonitor) {
        if (this.unitChangeMonitor == unitChangeMonitor) {
            this.unitChangeMonitor = null;
        }
    }
}

