/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension.use;

import javax.script.Bindings;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.sightly.ResourceResolution;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.impl.engine.UnitLoader;
import org.apache.sling.scripting.sightly.impl.engine.extension.use.UseProviderUtils;
import org.apache.sling.scripting.sightly.impl.engine.runtime.RenderUnit;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;

@Component(metatype=true, label="Apache Sling Scripting Sightly Render Unit Use Provider", description="The Render Unit Use Provider is responsible for instantiating Sightly templates through the Use-API.")
@Service(value={UseProvider.class})
@Properties(value={@Property(name="service.ranking", label="Service Ranking", description="The Service Ranking value acts as the priority with which this Use Provider is queried to return an Use-object. A higher value represents a higher priority.", intValue={100}, propertyPrivate=false)})
public class RenderUnitProvider
implements UseProvider {
    @Reference
    private UnitLoader unitLoader = null;

    @Override
    public ProviderOutcome provide(String identifier, RenderContext renderContext, Bindings arguments) {
        if (identifier.endsWith(".html")) {
            Bindings globalBindings = renderContext.getBindings();
            SlingScriptHelper sling = BindingsUtils.getHelper(globalBindings);
            Resource renderUnitResource = UseProviderUtils.locateScriptResource(renderContext, identifier);
            if (renderUnitResource == null) {
                Resource caller = ResourceResolution.getResourceForRequest(sling.getRequest().getResourceResolver(), sling.getRequest());
                if (caller != null) {
                    String resourceSuperType = caller.getResourceSuperType();
                    StringBuilder errorMessage = new StringBuilder("Cannot find resource ");
                    errorMessage.append(identifier).append(" for base path ").append(caller.getPath());
                    if (StringUtils.isNotEmpty((String)resourceSuperType)) {
                        errorMessage.append(" with resource super type ").append(resourceSuperType);
                    }
                    errorMessage.append(".");
                    return ProviderOutcome.failure((Throwable)((Object)new SightlyException(errorMessage.toString())));
                }
                return ProviderOutcome.failure((Throwable)((Object)new SightlyException("Cannot resolve template " + identifier + " for script " + sling.getScript().getScriptResource().getPath())));
            }
            try {
                RenderUnit renderUnit = this.unitLoader.createUnit(renderUnitResource, renderContext);
                return ProviderOutcome.success(renderUnit);
            }
            catch (Exception e) {
                return ProviderOutcome.failure(e);
            }
        }
        return ProviderOutcome.failure();
    }

    protected void bindUnitLoader(UnitLoader unitLoader) {
        this.unitLoader = unitLoader;
    }

    protected void unbindUnitLoader(UnitLoader unitLoader) {
        if (this.unitLoader == unitLoader) {
            this.unitLoader = null;
        }
    }
}

