/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.html.dom;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.scripting.sightly.impl.compiler.Syntax;
import org.apache.sling.scripting.sightly.impl.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BinaryOperation;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BinaryOperator;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.BooleanConstant;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.Identifier;
import org.apache.sling.scripting.sightly.impl.compiler.expression.node.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.ElementContext;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.ExpressionParser;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.ExpressionWrapper;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.Fragment;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.Interpolation;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Conditional;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.OutText;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.OutVariable;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.Patterns;
import org.apache.sling.scripting.sightly.impl.compiler.ris.command.VariableBinding;
import org.apache.sling.scripting.sightly.impl.compiler.util.SymbolGenerator;
import org.apache.sling.scripting.sightly.impl.compiler.util.stream.PushStream;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.filter.Filter;
import org.apache.sling.scripting.sightly.impl.html.MarkupUtils;
import org.apache.sling.scripting.sightly.impl.plugin.MarkupContext;
import org.apache.sling.scripting.sightly.impl.plugin.Plugin;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkupHandler {
    private static final Logger log = LoggerFactory.getLogger(MarkupHandler.class);
    private final PushStream stream;
    private final SymbolGenerator symbolGenerator = new SymbolGenerator();
    private final ExpressionParser expressionParser = new ExpressionParser();
    private final Map<String, Plugin> pluginRegistry;
    private final CompilerContext compilerContext;
    private final ExpressionWrapper expressionWrapper;
    private final Stack<ElementContext> elementStack = new Stack();

    public MarkupHandler(PushStream stream, Map<String, Plugin> pluginRegistry, Collection<Filter> filters) {
        this.stream = stream;
        this.pluginRegistry = pluginRegistry;
        this.expressionWrapper = new ExpressionWrapper(filters);
        this.compilerContext = new CompilerContext(this.symbolGenerator, this.expressionWrapper);
    }

    public void onOpenTagStart(String markup, String tagName) {
        ElementContext context = new ElementContext(tagName, markup);
        this.elementStack.push(context);
    }

    public void onAttribute(String name, String value) {
        ElementContext context = this.elementStack.peek();
        if (Syntax.isPluginAttribute(name)) {
            this.handlePlugin(name, StringUtils.defaultString((String)value, (String)""), context);
        } else {
            context.addAttribute(name, value);
        }
    }

    public void onOpenTagEnd(String markup) {
        ElementContext context = this.elementStack.peek();
        PluginInvoke invoke = context.pluginInvoke();
        invoke.beforeElement(this.stream, context.getTagName());
        boolean slyTag = "sly".equalsIgnoreCase(context.getTagName());
        if (slyTag) {
            Patterns.beginStreamIgnore(this.stream);
        }
        invoke.beforeTagOpen(this.stream);
        this.out(context.getOpenTagStartMarkup());
        invoke.beforeAttributes(this.stream);
        this.traverseAttributes(context, invoke);
        invoke.afterAttributes(this.stream);
        this.out(markup);
        invoke.afterTagOpen(this.stream);
        if (slyTag) {
            Patterns.endStreamIgnore(this.stream);
        }
        invoke.beforeChildren(this.stream);
    }

    private void traverseAttributes(ElementContext context, PluginInvoke invoke) {
        for (Map.Entry<String, Object> attribute : context.getAttributes()) {
            String attrName = attribute.getKey();
            Object contentObj = attribute.getValue();
            if (contentObj == null || contentObj instanceof String) {
                String content = (String)contentObj;
                this.emitAttribute(attrName, content, invoke);
                continue;
            }
            if (!(contentObj instanceof Map.Entry)) continue;
            Map.Entry entry = (Map.Entry)contentObj;
            PluginCallInfo info = (PluginCallInfo)entry.getKey();
            Expression expression = (Expression)entry.getValue();
            invoke.onPluginCall(this.stream, info, expression);
        }
    }

    private void emitAttribute(String name, String content, PluginInvoke invoke) {
        invoke.beforeAttribute(this.stream, name);
        if (content == null) {
            this.emitSimpleTextAttribute(name, null, invoke);
        } else {
            Interpolation interpolation = this.expressionParser.parseInterpolation(content);
            String text = this.tryAsSimpleText(interpolation);
            if (text != null) {
                this.emitSimpleTextAttribute(name, text, invoke);
            } else {
                this.emitExpressionAttribute(name, interpolation, invoke);
            }
        }
        invoke.afterAttribute(this.stream, name);
    }

    private void emitSimpleTextAttribute(String name, String textValue, PluginInvoke invoke) {
        this.emitAttributeStart(name);
        invoke.beforeAttributeValue(this.stream, name, new StringConstant(textValue));
        if (textValue != null) {
            this.emitAttributeValueStart();
            textValue = this.escapeQuotes(textValue);
            this.out(textValue);
            this.emitAttributeEnd();
        }
        invoke.afterAttributeValue(this.stream, name);
    }

    private String escapeQuotes(String textValue) {
        return textValue.replace("\"", "&quot;");
    }

    private void emitExpressionAttribute(String name, Interpolation interpolation, PluginInvoke invoke) {
        if ((interpolation = this.attributeChecked(name, interpolation)).size() == 1) {
            this.emitSingleFragment(name, interpolation, invoke);
        } else {
            this.emitMultipleFragment(name, interpolation, invoke);
        }
    }

    private void emitMultipleFragment(String name, Interpolation interpolation, PluginInvoke invoke) {
        Expression expression = this.expressionWrapper.transform(interpolation, this.getAttributeMarkupContext(name), ExpressionContext.ATTRIBUTE);
        String attrContent = this.symbolGenerator.next("attrContent");
        String shouldDisplayAttr = this.symbolGenerator.next("shouldDisplayAttr");
        this.stream.emit(new VariableBinding.Start(attrContent, expression.getRoot()));
        this.stream.emit(new VariableBinding.Start(shouldDisplayAttr, new BinaryOperation(BinaryOperator.OR, new Identifier(attrContent), new BinaryOperation(BinaryOperator.EQ, new StringConstant("false"), new Identifier(attrContent)))));
        this.stream.emit(new Conditional.Start(shouldDisplayAttr, true));
        this.emitAttributeStart(name);
        invoke.beforeAttributeValue(this.stream, name, expression.getRoot());
        this.emitAttributeValueStart();
        this.stream.emit(new OutVariable(attrContent));
        this.emitAttributeEnd();
        invoke.afterAttributeValue(this.stream, name);
        this.stream.emit(Conditional.END);
        this.stream.emit(VariableBinding.END);
        this.stream.emit(VariableBinding.END);
    }

    private void emitSingleFragment(String name, Interpolation interpolation, PluginInvoke invoke) {
        Expression valueExpression = this.expressionWrapper.transform(interpolation, null, ExpressionContext.ATTRIBUTE);
        String attrValue = this.symbolGenerator.next("attrValue");
        String attrContent = this.symbolGenerator.next("attrContent");
        String isTrueVar = this.symbolGenerator.next("isTrueAttr");
        String shouldDisplayAttr = this.symbolGenerator.next("shouldDisplayAttr");
        MarkupContext markupContext = this.getAttributeMarkupContext(name);
        Expression contentExpression = valueExpression.withNode(new Identifier(attrValue));
        ExpressionNode node = valueExpression.getRoot();
        this.stream.emit(new VariableBinding.Start(attrValue, node));
        this.stream.emit(new VariableBinding.Start(attrContent, this.expressionWrapper.adjustToContext(contentExpression, markupContext, ExpressionContext.ATTRIBUTE).getRoot()));
        this.stream.emit(new VariableBinding.Start(shouldDisplayAttr, new BinaryOperation(BinaryOperator.OR, new Identifier(attrContent), new BinaryOperation(BinaryOperator.EQ, new StringConstant("false"), new Identifier(attrValue)))));
        this.stream.emit(new Conditional.Start(shouldDisplayAttr, true));
        this.emitAttributeStart(name);
        invoke.beforeAttributeValue(this.stream, name, node);
        this.stream.emit(new VariableBinding.Start(isTrueVar, new BinaryOperation(BinaryOperator.EQ, new Identifier(attrValue), BooleanConstant.TRUE)));
        this.stream.emit(new Conditional.Start(isTrueVar, false));
        this.emitAttributeValueStart();
        this.stream.emit(new OutVariable(attrContent));
        this.emitAttributeEnd();
        this.stream.emit(Conditional.END);
        this.stream.emit(VariableBinding.END);
        invoke.afterAttributeValue(this.stream, name);
        this.stream.emit(Conditional.END);
        this.stream.emit(VariableBinding.END);
        this.stream.emit(VariableBinding.END);
        this.stream.emit(VariableBinding.END);
    }

    private void emitAttributeStart(String name) {
        this.out(" " + name);
    }

    private void emitAttributeValueStart() {
        this.out("=\"");
    }

    private void emitAttributeEnd() {
        this.out("\"");
    }

    public void onCloseTag(String markup) {
        ElementContext context = this.elementStack.pop();
        PluginInvoke invoke = context.pluginInvoke();
        invoke.afterChildren(this.stream);
        boolean selfClosingTag = StringUtils.isEmpty((String)markup);
        boolean slyTag = "sly".equalsIgnoreCase(context.getTagName());
        if (slyTag) {
            Patterns.beginStreamIgnore(this.stream);
        }
        invoke.beforeTagClose(this.stream, selfClosingTag);
        this.out(markup);
        invoke.afterTagClose(this.stream, selfClosingTag);
        if (slyTag) {
            Patterns.endStreamIgnore(this.stream);
        }
        invoke.afterElement(this.stream);
    }

    public void onText(String text) {
        String tag = this.currentElementTag();
        boolean explicitContextRequired = this.isExplicitContextRequired(tag);
        MarkupContext markupContext = explicitContextRequired ? null : MarkupContext.TEXT;
        this.outText(text, markupContext);
    }

    public void onComment(String markup) {
        if (!Syntax.isSightlyComment(markup)) {
            this.outText(markup, MarkupContext.COMMENT);
        }
    }

    public void onDataNode(String markup) {
        this.out(markup);
    }

    public void onDocType(String markup) {
        this.out(markup);
    }

    public void onDocumentFinished() {
        this.stream.signalDone();
    }

    private void outText(String content, MarkupContext context) {
        String text;
        Interpolation interpolation = this.expressionParser.parseInterpolation(content);
        if (context == null) {
            interpolation = this.requireContext(interpolation);
        }
        if ((text = this.tryAsSimpleText(interpolation)) != null) {
            this.out(text);
        } else {
            this.outExprNode(this.expressionWrapper.transform(interpolation, context, ExpressionContext.TEXT).getRoot());
        }
    }

    private Interpolation requireContext(Interpolation interpolation) {
        Interpolation result = new Interpolation();
        for (Fragment fragment : interpolation.getFragments()) {
            Fragment addedFragment;
            if (fragment.isString()) {
                addedFragment = fragment;
            } else if (fragment.getExpression().containsOption("context")) {
                addedFragment = fragment;
            } else {
                String currentTag = this.currentElementTag();
                log.warn("Element {} requires that all expressions have an explicit context specified. Expression will be replaced by the empty string", (Object)currentTag);
                addedFragment = new Fragment.Expr(new Expression(StringConstant.EMPTY));
            }
            result.addFragment(addedFragment);
        }
        return result;
    }

    private Interpolation attributeChecked(String attributeName, Interpolation interpolation) {
        if (!MarkupUtils.isSensitiveAttribute(attributeName)) {
            return interpolation;
        }
        Interpolation newInterpolation = new Interpolation();
        Iterator<Fragment> i$ = interpolation.getFragments().iterator();
        while (i$.hasNext()) {
            Expression expression;
            Fragment fragment;
            Fragment addedFragment = fragment = i$.next();
            if (fragment.isExpression() && !(expression = fragment.getExpression()).containsOption("context")) {
                log.warn("All expressions within the value of attribute {} need to have an explicit context option. The expression will be erased.", (Object)attributeName);
                addedFragment = new Fragment.Text("");
            }
            newInterpolation.addFragment(addedFragment);
        }
        return newInterpolation;
    }

    private void outExprNode(ExpressionNode node) {
        String variable = this.symbolGenerator.next();
        this.stream.emit(new VariableBinding.Start(variable, node));
        this.stream.emit(new OutVariable(variable));
        this.stream.emit(VariableBinding.END);
    }

    private String tryAsSimpleText(Interpolation interpolation) {
        if (interpolation.size() == 1) {
            Fragment fragment = interpolation.getFragment(0);
            if (fragment.isString()) {
                return fragment.getText();
            }
        } else if (interpolation.size() == 0) {
            return "";
        }
        return null;
    }

    private void out(String text) {
        this.stream.emit(new OutText(text));
    }

    private void handlePlugin(String name, String value, ElementContext context) {
        PluginCallInfo callInfo = Syntax.parsePluginAttribute(name);
        if (callInfo != null) {
            Plugin plugin = this.obtainPlugin(callInfo.getName());
            ExpressionContext expressionContext = ExpressionContext.getContextForPlugin(plugin.name());
            Expression expr = this.expressionWrapper.transform(this.expressionParser.parseInterpolation(value), null, expressionContext);
            PluginInvoke invoke = plugin.invoke(expr, callInfo, this.compilerContext);
            context.addPlugin(invoke, plugin.priority());
            context.addPluginCall(name, callInfo, expr);
        }
    }

    private Plugin obtainPlugin(String name) {
        Plugin plugin = this.pluginRegistry.get(name);
        if (plugin == null) {
            throw new UnsupportedOperationException(String.format("Plugin %s does not exist", name));
        }
        return plugin;
    }

    private MarkupContext getAttributeMarkupContext(String attributeName) {
        if ("src".equalsIgnoreCase(attributeName) || "href".equalsIgnoreCase(attributeName)) {
            return MarkupContext.URI;
        }
        return MarkupContext.ATTRIBUTE;
    }

    private String currentElementTag() {
        if (this.elementStack.isEmpty()) {
            return null;
        }
        ElementContext current = this.elementStack.peek();
        return current.getTagName();
    }

    private boolean isExplicitContextRequired(String parentElementName) {
        return parentElementName != null && ("script".equals(parentElementName) || "style".equals(parentElementName));
    }
}

