/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.scripting.sightly.SightlyException;

public class PathInfo {
    private URI uri;
    private String path;
    private Set<String> selectors;
    private String selectorString;
    private String extension;
    private String suffix;
    private Map<String, Collection<String>> parameters = new LinkedHashMap<String, Collection<String>>();

    public PathInfo(String path) {
        int firstDot;
        int lastDot;
        if (path == null) {
            throw new NullPointerException("The path parameter cannot be null.");
        }
        try {
            this.uri = new URI(path);
        }
        catch (URISyntaxException e) {
            throw new SightlyException("The provided path does not represent a valid URI: " + path);
        }
        this.selectors = new LinkedHashSet<String>();
        String processingPath = path;
        if (this.uri.getPath() != null) {
            processingPath = this.uri.getPath();
        }
        if ((lastDot = processingPath.lastIndexOf(46)) > -1) {
            String afterLastDot = processingPath.substring(lastDot + 1);
            String[] parts = afterLastDot.split("/");
            this.extension = parts[0];
            if (parts.length > 1) {
                StringBuilder suffixSB = new StringBuilder();
                for (int i = 1; i < parts.length; ++i) {
                    suffixSB.append("/").append(parts[i]);
                }
                int hashIndex = suffixSB.indexOf("#");
                this.suffix = hashIndex > -1 ? suffixSB.substring(0, hashIndex) : suffixSB.toString();
            }
        }
        if ((firstDot = processingPath.indexOf(46)) < lastDot) {
            this.selectorString = processingPath.substring(firstDot + 1, lastDot);
            String[] selectorsArray = this.selectorString.split("\\.");
            this.selectors.addAll(Arrays.asList(selectorsArray));
        }
        int pathLength = processingPath.length() - (this.selectorString == null ? 0 : this.selectorString.length() + 1) - (this.extension == null ? 0 : this.extension.length() + 1) - (this.suffix == null ? 0 : this.suffix.length());
        this.path = pathLength == processingPath.length() ? processingPath : processingPath.substring(0, pathLength);
        String query = this.uri.getQuery();
        if (StringUtils.isNotEmpty((String)query)) {
            String[] keyValuePairs = query.split("&");
            for (int i = 0; i < keyValuePairs.length; ++i) {
                String[] pair = keyValuePairs[i].split("=");
                if (pair.length != 2) continue;
                String param = pair[0];
                String value = pair[1];
                Collection<String> values = this.parameters.get(param);
                if (values == null) {
                    values = new ArrayList<String>();
                    this.parameters.put(param, values);
                }
                values.add(value);
            }
        }
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getBeginPathSeparator() {
        if (this.uri.isAbsolute()) {
            return "//";
        }
        return null;
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getFullPath() {
        return this.uri.toString();
    }

    public String getPath() {
        return this.path;
    }

    public Set<String> getSelectors() {
        return this.selectors;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getSelectorString() {
        return this.selectorString;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getFragment() {
        return this.uri.getFragment();
    }

    public Map<String, Collection<String>> getParameters() {
        return this.parameters;
    }
}

