/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.servlets.post.PostResponse;

public abstract class AbstractPostResponse
implements PostResponse {
    public static final String PN_TITLE = "title";
    public static final String PN_STATUS_CODE = "status.code";
    public static final String PN_STATUS_MESSAGE = "status.message";
    public static final String PN_LOCATION = "location";
    public static final String PN_PARENT_LOCATION = "parentLocation";
    public static final String PN_PATH = "path";
    public static final String PN_REFERER = "referer";
    public static final String PN_IS_CREATED = "isCreate";
    public static final String PN_ERROR = "error";
    private final Map<String, Object> properties = new HashMap<String, Object>();

    @Override
    public String getReferer() {
        return this.getProperty(PN_REFERER, String.class);
    }

    @Override
    public void setReferer(String referer) {
        this.setProperty(PN_REFERER, referer);
    }

    @Override
    public String getPath() {
        return this.getProperty(PN_PATH, String.class);
    }

    @Override
    public void setPath(String path) {
        this.setProperty(PN_PATH, path);
    }

    @Override
    public boolean isCreateRequest() {
        Boolean isCreateRequest = this.getProperty(PN_IS_CREATED, Boolean.class);
        return isCreateRequest != null ? isCreateRequest : false;
    }

    @Override
    public void setCreateRequest(boolean isCreateRequest) {
        this.setProperty(PN_IS_CREATED, isCreateRequest);
    }

    @Override
    public String getLocation() {
        return this.getProperty(PN_LOCATION, String.class);
    }

    @Override
    public void setLocation(String location) {
        this.setProperty(PN_LOCATION, location);
    }

    @Override
    public String getParentLocation() {
        return this.getProperty(PN_PARENT_LOCATION, String.class);
    }

    @Override
    public void setParentLocation(String parentLocation) {
        this.setProperty(PN_PARENT_LOCATION, parentLocation);
    }

    @Override
    public void setTitle(String title) {
        this.setProperty(PN_TITLE, title);
    }

    @Override
    public void setStatus(int code, String message) {
        this.setProperty(PN_STATUS_CODE, code);
        this.setProperty(PN_STATUS_MESSAGE, message);
    }

    @Override
    public int getStatusCode() {
        Integer status = this.getProperty(PN_STATUS_CODE, Integer.class);
        if (status == null) {
            status = this.getError() != null ? Integer.valueOf(500) : Integer.valueOf(200);
        }
        return status;
    }

    @Override
    public String getStatusMessage() {
        return this.getProperty(PN_STATUS_MESSAGE, String.class);
    }

    @Override
    public Throwable getError() {
        return this.getProperty(PN_ERROR, Throwable.class);
    }

    @Override
    public void setError(Throwable error) {
        this.setProperty(PN_ERROR, error);
    }

    @Override
    public boolean isSuccessful() {
        return this.getError() == null && this.getStatusCode() / 100 == 2;
    }

    @Override
    public void onModified(String path) {
        this.onChange("modified", path);
    }

    @Override
    public void onCreated(String path) {
        this.onChange("created", path);
    }

    @Override
    public void onDeleted(String path) {
        if (path != null) {
            this.onChange("deleted", path);
        }
    }

    @Override
    public void onMoved(String srcPath, String dstPath) {
        this.onChange("moved", srcPath, dstPath);
    }

    @Override
    public void onCopied(String srcPath, String dstPath) {
        this.onChange("copied", srcPath, dstPath);
    }

    private void prepare(HttpServletResponse response, boolean setStatus) {
        Object status;
        String referer;
        String path = this.getPath();
        if (this.getProperty(PN_STATUS_CODE) == null) {
            if (this.getError() != null) {
                this.setStatus(500, this.getError().toString());
                this.setTitle("Error while processing " + path);
            } else if (this.isCreateRequest()) {
                this.setStatus(201, "Created");
                this.setTitle("Content created " + path);
            } else {
                this.setStatus(200, "OK");
                this.setTitle("Content modified " + path);
            }
        }
        if ((referer = this.getReferer()) == null) {
            referer = "";
        }
        this.setReferer(referer);
        if (setStatus && (status = this.getProperty(PN_STATUS_CODE)) instanceof Number) {
            int statusCode = ((Number)status).intValue();
            response.setStatus(statusCode);
            if (statusCode == 201 || statusCode / 100 == 3) {
                response.setHeader("Location", this.getLocation());
            }
        }
    }

    protected void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    protected <Type> Type getProperty(String name, Class<Type> type) {
        Object value = this.getProperty(name);
        if (type.isInstance(value)) {
            return (Type)value;
        }
        return null;
    }

    protected Object getProperty(String name) {
        return this.properties.get(name);
    }

    protected boolean isSafeReferer() {
        String referer = this.getReferer();
        return referer.startsWith("http://") || referer.startsWith("https://");
    }

    protected abstract void doSend(HttpServletResponse var1) throws IOException;

    @Override
    public final void send(HttpServletResponse response, boolean setStatus) throws IOException {
        this.prepare(response, setStatus);
        this.doSend(response);
    }
}

