/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.Part;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.helper.ResourceIteratorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamedChunk {
    private static final String SLING_CHUNKS_LENGTH = "sling:length";
    private static final String SLING_FILE_LENGTH = "sling:fileLength";
    private static final String SLING_CHUNK_MIXIN = "sling:chunks";
    private static final String SLING_CHUNK_NT = "sling:chunk";
    private static final String SLING_OFFSET = "sling:offset";
    private static final String MT_APP_OCTET = "application/octet-stream";
    private final Logger LOGGER = LoggerFactory.getLogger(StreamedChunk.class);
    private final long offset;
    private final long chunkLength;
    private final long fileLength;
    private final Part part;
    private ServletContext servletContext;
    private final boolean completed;
    private final boolean chunked;
    private final String chunkResourceName;

    public StreamedChunk(Part part, Map<String, List<String>> formFields, ServletContext servletContext) {
        this.part = part;
        this.servletContext = servletContext;
        String contentRangeHeader = part.getHeader("Content-Range");
        String contentLengthHeader = part.getHeader("Content-Length");
        if (contentRangeHeader != null) {
            ContentRange contentRange = new ContentRange(contentRangeHeader);
            this.fileLength = contentRange.length;
            this.offset = contentRange.offset;
            this.chunkLength = contentRange.range;
            this.chunked = true;
        } else if (formFields.containsKey(part.getName() + "@Length") && formFields.containsKey(part.getName() + "@Offset")) {
            this.fileLength = Long.parseLong(this.lastFrom(formFields.get(part.getName() + "@Length")));
            this.offset = Long.parseLong(this.lastFrom(formFields.get(part.getName() + "@Offset")));
            if (contentLengthHeader != null) {
                this.chunkLength = Long.parseLong(contentLengthHeader);
            } else if (formFields.containsKey(part.getName() + "@PartLength")) {
                this.chunkLength = Long.parseLong(this.lastFrom(formFields.get(part.getName() + "@PartLength")));
            } else {
                this.LOGGER.info("No part length specified assuming this is the final part of the chunked upload.");
                this.chunkLength = this.fileLength - this.offset;
            }
            this.chunked = true;
        } else {
            this.offset = 0L;
            if (contentLengthHeader != null) {
                this.chunkLength = this.fileLength = Long.parseLong(contentLengthHeader);
            } else {
                this.fileLength = -1L;
                this.chunkLength = -1L;
            }
            this.chunked = false;
        }
        this.chunkResourceName = "chunk_" + this.offset + "-" + (this.offset + this.chunkLength);
        this.completed = this.offset + this.chunkLength == this.fileLength || formFields.containsKey(part.getName() + "@Completed");
        this.LOGGER.debug(" chunkResourceName {},  chunked {},completed {},  fileLength {}, chunkLength {}, offset {} ", new Object[]{this.chunkResourceName, this.chunked, this.completed, this.fileLength, this.chunkLength, this.offset});
    }

    public Resource store(Resource fileResource, List<Modification> changes) throws PersistenceException {
        Resource result = fileResource.getChild("jcr:content");
        if (result != null) {
            this.updateState(result, changes);
        } else {
            result = this.initState(fileResource, changes);
        }
        this.storeChunk(result, changes);
        return result;
    }

    private String lastFrom(List<String> strings) {
        return strings.get(strings.size() - 1);
    }

    private void updateState(Resource contentResource, List<Modification> changes) throws IllegalStateException, PersistenceException {
        ModifiableValueMap vm = (ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class);
        if (vm == null) {
            throw new PersistenceException("Resource at " + contentResource.getPath() + " is not modifiable.");
        }
        vm.put((Object)"jcr:lastModified", (Object)Calendar.getInstance());
        vm.put((Object)"jcr:mimeType", (Object)this.getContentType(this.part));
        if (this.chunked) {
            long previousFileLength;
            if (vm.containsKey((Object)SLING_FILE_LENGTH) && (previousFileLength = ((Long)vm.get(SLING_FILE_LENGTH, Long.class)).longValue()) != this.fileLength) {
                throw new IllegalStateException("Chunk file length has changed while cunks were being uploaded expected " + previousFileLength + " chunk contained  " + this.fileLength);
            }
            long previousChunksLength = 0L;
            if (vm.containsKey((Object)SLING_CHUNKS_LENGTH) && (previousChunksLength = ((Long)vm.get(SLING_CHUNKS_LENGTH, Long.class)).longValue()) != this.offset) {
                throw new IllegalStateException("Chunks recieved out of order, was expecting chunk starting at " + this.offset + " found last chunk ending at " + previousChunksLength);
            }
            vm.put((Object)SLING_CHUNKS_LENGTH, (Object)(previousChunksLength + this.chunkLength));
            vm.put((Object)"jcr:mixinTypes", (Object)SLING_CHUNK_MIXIN);
        } else {
            try {
                vm.put((Object)"jcr:data", (Object)this.part.getInputStream());
            }
            catch (IOException e) {
                throw new PersistenceException("Error while retrieving inputstream from request part.", (Throwable)e);
            }
        }
    }

    private Resource initState(Resource fileResource, List<Modification> changes) throws PersistenceException {
        HashMap<String, Object> resourceProps = new HashMap<String, Object>();
        resourceProps.put("jcr:primaryType", "nt:resource");
        resourceProps.put("jcr:lastModified", Calendar.getInstance());
        resourceProps.put("jcr:mimeType", this.getContentType(this.part));
        if (this.chunked) {
            resourceProps.put(SLING_CHUNKS_LENGTH, this.chunkLength);
            resourceProps.put(SLING_FILE_LENGTH, this.fileLength);
            resourceProps.put("jcr:mixinTypes", SLING_CHUNK_MIXIN);
            resourceProps.put("jcr:data", new ByteArrayInputStream(new byte[0]));
        } else {
            try {
                resourceProps.put("jcr:data", this.part.getInputStream());
            }
            catch (IOException e) {
                throw new PersistenceException("Error while retrieving inputstream from request part.", (Throwable)e);
            }
        }
        Resource result = fileResource.getResourceResolver().create(fileResource, "jcr:content", resourceProps);
        for (String key : resourceProps.keySet()) {
            changes.add(Modification.onModified(result.getPath() + '/' + key));
        }
        return result;
    }

    private void storeChunk(Resource contentResource, List<Modification> changes) throws PersistenceException {
        if (this.chunked) {
            HashMap<String, Object> chunkProperties = new HashMap<String, Object>();
            chunkProperties.put("jcr:primaryType", SLING_CHUNK_NT);
            chunkProperties.put(SLING_OFFSET, this.offset);
            try {
                chunkProperties.put("jcr:data", this.part.getInputStream());
            }
            catch (IOException e) {
                throw new PersistenceException("Error while retrieving inputstream from request part.", (Throwable)e);
            }
            this.LOGGER.debug("Creating chunk at {} with properties {}  ", (Object)this.chunkResourceName, chunkProperties);
            Resource chunkResource = contentResource.getResourceResolver().create(contentResource, this.chunkResourceName, chunkProperties);
            for (String key : chunkProperties.keySet()) {
                changes.add(Modification.onModified(chunkResource.getPath() + '/' + key));
            }
            this.processChunks(contentResource, changes);
        }
    }

    private void processChunks(Resource contentResource, List<Modification> changes) throws PersistenceException {
        if (this.completed) {
            contentResource.getResourceResolver().commit();
            ModifiableValueMap vm = (ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class);
            vm.put((Object)"jcr:data", (Object)this.getChunksInputStream(contentResource));
            this.removeChunkData(contentResource, vm);
        }
    }

    private void removeChunkData(Resource contentResource, ModifiableValueMap vm) throws PersistenceException {
        for (Resource r : contentResource.getChildren()) {
            if (!r.isResourceType(SLING_CHUNK_NT)) continue;
            r.getResourceResolver().delete(r);
        }
        vm.remove((Object)SLING_CHUNKS_LENGTH);
        vm.remove((Object)SLING_FILE_LENGTH);
    }

    private InputStream getChunksInputStream(Resource contentResource) {
        ArrayList<Resource> chunkResources = new ArrayList<Resource>();
        for (Resource r : contentResource.getChildren()) {
            if (!r.isResourceType(SLING_CHUNK_NT)) continue;
            chunkResources.add(r);
        }
        Collections.sort(chunkResources, new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                long offset1 = (Long)((ValueMap)o1.adaptTo(ValueMap.class)).get(StreamedChunk.SLING_OFFSET, Long.class);
                long offset2 = (Long)((ValueMap)o2.adaptTo(ValueMap.class)).get(StreamedChunk.SLING_OFFSET, Long.class);
                return (int)(offset1 - offset2);
            }
        });
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Finishing Chunk upload at {} consolidating {} chunks into one file of  ", new Object[]{contentResource.getPath(), chunkResources.size(), ((ValueMap)contentResource.adaptTo(ValueMap.class)).get((Object)SLING_CHUNKS_LENGTH)});
            this.LOGGER.debug("Content Resource Properties {} ", contentResource.adaptTo(ValueMap.class));
            for (Resource r : chunkResources) {
                this.LOGGER.debug("Chunk {} properties {} ", (Object)r.getPath(), r.adaptTo(ValueMap.class));
            }
        }
        return new ResourceIteratorInputStream(chunkResources.iterator());
    }

    private String getContentType(Part part) {
        int idx;
        String contentType = part.getContentType();
        if (contentType != null && (idx = contentType.indexOf(59)) > 0) {
            contentType = contentType.substring(0, idx);
        }
        if (contentType == null || contentType.equals(MT_APP_OCTET)) {
            ServletContext ctx = this.servletContext;
            if (ctx != null) {
                contentType = ctx.getMimeType(part.getSubmittedFileName());
            }
            if (contentType == null || contentType.equals(MT_APP_OCTET)) {
                contentType = MT_APP_OCTET;
            }
        }
        return contentType;
    }

    public static class ContentRange {
        private static final Pattern rangePattern = Pattern.compile("bytes\\s([0-9]+)-([0-9]+)\\/([0-9]*)(\\**)");
        public long length;
        public long offset;
        public long range;

        public ContentRange(String contentRangeHeader) {
            Matcher m = rangePattern.matcher(contentRangeHeader);
            if (m.find()) {
                this.offset = Long.parseLong(m.group(1));
                long end = Long.parseLong(m.group(2));
                this.range = end - this.offset + 1L;
                if ("*".equals(m.group(4))) {
                    this.length = -1L;
                } else {
                    this.length = Long.parseLong(m.group(3));
                    if (this.offset > this.length) {
                        throw new IllegalArgumentException("Range header " + contentRangeHeader + " is invalid, offset beyond end.");
                    }
                    if (end > this.length) {
                        throw new IllegalArgumentException("Range header " + contentRangeHeader + " is invalid, range end beyond end.");
                    }
                    if (this.range > this.length) {
                        throw new IllegalArgumentException("Range header " + contentRangeHeader + " is invalid, range greater than length.");
                    }
                }
                if (this.offset > end) {
                    throw new IllegalArgumentException("Range header " + contentRangeHeader + " is invalid, offset beyond end of range.");
                }
            } else {
                throw new IllegalArgumentException("Range header " + contentRangeHeader + " is invalid");
            }
        }
    }
}

