/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.servlets.post.AbstractPostResponse;
import org.apache.sling.servlets.post.impl.contentparser.impl.JsonTicksConverter;

public class JSONResponse
extends AbstractPostResponse {
    public static final String RESPONSE_CONTENT_TYPE = "application/json";
    static final String PROP_TYPE = "type";
    static final String PROP_ARGUMENT = "argument";
    static final String RESPONSE_CHARSET = "UTF-8";
    private static final String PROP_CHANGES = "changes";
    private Map<String, Object> json = new HashMap<String, Object>();
    private Map<String, JsonStructure> jsonCached = new HashMap<String, JsonStructure>();
    private List<Map<String, Object>> changes = new ArrayList<Map<String, Object>>();
    private Throwable error;

    @Override
    public void onChange(String type, String ... arguments) {
        HashMap<String, Object> change = new HashMap<String, Object>();
        change.put(PROP_TYPE, type);
        if (arguments.length > 1) {
            change.put(PROP_ARGUMENT, Arrays.asList(arguments));
        } else if (arguments.length == 1) {
            change.put(PROP_ARGUMENT, arguments[0]);
        }
        this.changes.add(change);
    }

    @Override
    public void setError(Throwable error) {
        this.error = error;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public void setProperty(String name, Object value) {
        if (value instanceof String || value instanceof Boolean || value instanceof Number || value == null) {
            this.json.put(name, value);
        } else {
            try {
                String valueString = JsonTicksConverter.tickToDoubleQuote(value.toString());
                this.jsonCached.put(name, Json.createReader((Reader)new StringReader(valueString)).read());
                this.json.put(name, value);
            }
            catch (Exception ex) {
                throw new JSONResponseException((Throwable)ex);
            }
        }
    }

    @Override
    public Object getProperty(String name) {
        return PROP_CHANGES.equals(name) ? this.getJson().getJsonArray(PROP_CHANGES) : ("error".equals(name) && this.error != null ? this.getJson().get((Object)"error") : this.json.get(name));
    }

    @Override
    protected void doSend(HttpServletResponse response) throws IOException {
        response.setContentType(RESPONSE_CONTENT_TYPE);
        response.setCharacterEncoding(RESPONSE_CHARSET);
        Json.createGenerator((Writer)response.getWriter()).write((JsonValue)this.getJson()).close();
    }

    JsonObject getJson() {
        JsonObjectBuilder jsonBuilder = Json.createObjectBuilder();
        for (Map.Entry<String, Object> entry : this.json.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                jsonBuilder.add(entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (value instanceof Boolean) {
                jsonBuilder.add(entry.getKey(), ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof BigInteger) {
                jsonBuilder.add(entry.getKey(), (BigInteger)value);
                continue;
            }
            if (value instanceof BigDecimal) {
                jsonBuilder.add(entry.getKey(), (BigDecimal)value);
                continue;
            }
            if (value instanceof Byte) {
                jsonBuilder.add(entry.getKey(), (int)((Byte)value).byteValue());
                continue;
            }
            if (value instanceof Short) {
                jsonBuilder.add(entry.getKey(), (int)((Short)value).shortValue());
                continue;
            }
            if (value instanceof Integer) {
                jsonBuilder.add(entry.getKey(), ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                jsonBuilder.add(entry.getKey(), ((Long)value).longValue());
                continue;
            }
            if (value instanceof Double) {
                jsonBuilder.add(entry.getKey(), ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Float) {
                jsonBuilder.add(entry.getKey(), (double)((Float)value).floatValue());
                continue;
            }
            if (value == null) {
                jsonBuilder.addNull(entry.getKey());
                continue;
            }
            jsonBuilder.add(entry.getKey(), (JsonValue)this.jsonCached.get(entry.getKey()));
        }
        if (this.error != null) {
            jsonBuilder.add("error", Json.createObjectBuilder().add("class", this.error.getClass().getName()).add("message", this.error.getMessage()));
        }
        JsonArrayBuilder changesBuilder = Json.createArrayBuilder();
        if (this.error == null) {
            for (Map<String, Object> entry : this.changes) {
                JsonObjectBuilder entryBuilder = Json.createObjectBuilder();
                entryBuilder.add(PROP_TYPE, (String)entry.get(PROP_TYPE));
                Object arguments = entry.get(PROP_ARGUMENT);
                if (arguments != null) {
                    if (arguments instanceof List) {
                        JsonArrayBuilder argumentsBuilder = Json.createArrayBuilder();
                        for (String argument : (List)arguments) {
                            if (argument == null) continue;
                            argumentsBuilder.add(argument);
                        }
                        entryBuilder.add(PROP_ARGUMENT, argumentsBuilder);
                    } else {
                        entryBuilder.add(PROP_ARGUMENT, (String)arguments);
                    }
                }
                changesBuilder.add(entryBuilder);
            }
        }
        jsonBuilder.add(PROP_CHANGES, changesBuilder);
        return jsonBuilder.build();
    }

    public class JSONResponseException
    extends RuntimeException {
        public JSONResponseException(String message, Throwable exception) {
            super(message, exception);
        }

        public JSONResponseException(Throwable e) {
            super("Error building JSON response", e);
        }
    }
}

