/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.contentloader.ContentImporter;
import org.apache.sling.servlets.post.HtmlResponse;
import org.apache.sling.servlets.post.JSONResponse;
import org.apache.sling.servlets.post.NodeNameGenerator;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.PostResponseCreator;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.DateParser;
import org.apache.sling.servlets.post.impl.helper.DefaultNodeNameGenerator;
import org.apache.sling.servlets.post.impl.helper.MediaRangeList;
import org.apache.sling.servlets.post.impl.operations.CheckinOperation;
import org.apache.sling.servlets.post.impl.operations.CheckoutOperation;
import org.apache.sling.servlets.post.impl.operations.CopyOperation;
import org.apache.sling.servlets.post.impl.operations.DeleteOperation;
import org.apache.sling.servlets.post.impl.operations.ImportOperation;
import org.apache.sling.servlets.post.impl.operations.ModifyOperation;
import org.apache.sling.servlets.post.impl.operations.MoveOperation;
import org.apache.sling.servlets.post.impl.operations.NopOperation;
import org.apache.sling.servlets.post.impl.operations.RestoreOperation;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(immediate=true, specVersion="1.1", metatype=true, label="%servlet.post.name", description="%servlet.post.description")
@Service(value={Servlet.class})
@org.apache.felix.scr.annotations.Properties(value={@Property(name="service.description", value={"Sling Post Servlet"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="sling.servlet.prefix", intValue={-1}, propertyPrivate=true), @Property(name="sling.servlet.paths", value={"sling/servlet/default/POST"}, propertyPrivate=true)})
@References(value={@Reference(name="postProcessor", referenceInterface=SlingPostProcessor.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="postOperation", referenceInterface=PostOperation.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="nodeNameGenerator", referenceInterface=NodeNameGenerator.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="postResponseCreator", referenceInterface=PostResponseCreator.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="contentImporter", referenceInterface=ContentImporter.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)})
public class SlingPostServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1837674988291697074L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Property(value={"EEE MMM dd yyyy HH:mm:ss 'GMT'Z", "ISO8601", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd", "dd.MM.yyyy HH:mm:ss", "dd.MM.yyyy"})
    private static final String PROP_DATE_FORMAT = "servlet.post.dateFormats";
    @Property(value={"title", "jcr:title", "name", "description", "jcr:description", "abstract", "text", "jcr:text"})
    private static final String PROP_NODE_NAME_HINT_PROPERTIES = "servlet.post.nodeNameHints";
    @Property(intValue={20})
    private static final String PROP_NODE_NAME_MAX_LENGTH = "servlet.post.nodeNameMaxLength";
    private static final boolean DEFAULT_CHECKIN_ON_CREATE = false;
    @Property(boolValue={false})
    private static final String PROP_CHECKIN_ON_CREATE = "servlet.post.checkinNewVersionableNodes";
    private static final boolean DEFAULT_AUTO_CHECKOUT = false;
    @Property(boolValue={false})
    private static final String PROP_AUTO_CHECKOUT = "servlet.post.autoCheckout";
    private static final boolean DEFAULT_AUTO_CHECKIN = true;
    @Property(boolValue={true})
    private static final String PROP_AUTO_CHECKIN = "servlet.post.autoCheckin";
    private static final String PARAM_CHECKIN_ON_CREATE = ":checkinNewVersionableNodes";
    private static final String PARAM_AUTO_CHECKOUT = ":autoCheckout";
    private static final String PARAM_AUTO_CHECKIN = ":autoCheckin";
    private static final String DEFAULT_IGNORED_PARAMETER_NAME_PATTERN = "j_.*";
    @Property(value={"j_.*"})
    private static final String PROP_IGNORED_PARAMETER_NAME_PATTERN = "servlet.post.ignorePattern";
    private final ModifyOperation modifyOperation = new ModifyOperation();
    private ServiceRegistration[] internalOperations;
    private final Map<String, PostOperation> postOperations = new HashMap<String, PostOperation>();
    private final List<PostProcessorHolder> postProcessors = new ArrayList<PostProcessorHolder>();
    private SlingPostProcessor[] cachedPostProcessors = new SlingPostProcessor[0];
    private final List<NodeNameGeneratorHolder> nodeNameGenerators = new ArrayList<NodeNameGeneratorHolder>();
    private NodeNameGenerator[] cachedNodeNameGenerators = new NodeNameGenerator[0];
    private final List<PostResponseCreatorHolder> postResponseCreators = new ArrayList<PostResponseCreatorHolder>();
    private PostResponseCreator[] cachedPostResponseCreators = new PostResponseCreator[0];
    private final ImportOperation importOperation = new ImportOperation();
    private ContentImporter contentImporter;
    private VersioningConfiguration baseVersioningConfiguration;
    private static final Pattern REDIRECT_WITH_SCHEME_PATTERN = Pattern.compile("^(https?://[^/]+)(.*)$");

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        VersioningConfiguration localVersioningConfig = this.createRequestVersioningConfiguration(request);
        request.setAttribute(VersioningConfiguration.class.getName(), (Object)localVersioningConfig);
        PostResponse htmlResponse = this.createPostResponse(request);
        htmlResponse.setReferer(request.getHeader("referer"));
        PostOperation operation = this.getSlingPostOperation(request);
        if (operation == null) {
            htmlResponse.setStatus(500, "Invalid operation specified for POST request");
        } else {
            request.getRequestProgressTracker().log("Calling PostOperation: {0}", new Object[]{operation.getClass().getName()});
            SlingPostProcessor[] processors = this.cachedPostProcessors;
            try {
                operation.run(request, htmlResponse, processors);
            }
            catch (ResourceNotFoundException rnfe) {
                htmlResponse.setStatus(404, rnfe.getMessage());
            }
            catch (Exception exception) {
                this.log.warn("Exception while handling POST " + request.getResource().getPath() + " with " + operation.getClass().getName(), (Throwable)exception);
                htmlResponse.setError(exception);
            }
        }
        if (htmlResponse.isSuccessful() && this.redirectIfNeeded(request, htmlResponse, response)) {
            return;
        }
        htmlResponse.send((HttpServletResponse)response, this.isSetStatus(request));
    }

    boolean redirectIfNeeded(SlingHttpServletRequest request, PostResponse htmlResponse, SlingHttpServletResponse response) throws IOException {
        String redirectURL = this.getRedirectUrl(request, htmlResponse);
        if (redirectURL != null) {
            String encodedURL;
            Matcher m = REDIRECT_WITH_SCHEME_PATTERN.matcher(redirectURL);
            boolean hasScheme = m.matches();
            if (hasScheme && m.group(2).length() > 0) {
                encodedURL = m.group(1) + response.encodeRedirectURL(m.group(2));
            } else if (hasScheme) {
                encodedURL = redirectURL;
            } else {
                this.log.debug("Request path is [{}]", (Object)request.getPathInfo());
                encodedURL = response.encodeRedirectURL(redirectURL);
            }
            this.log.debug("redirecting to URL [{}] - encoded as [{}]", (Object)redirectURL, (Object)encodedURL);
            response.sendRedirect(encodedURL);
            return true;
        }
        return false;
    }

    PostResponse createPostResponse(SlingHttpServletRequest req) {
        for (PostResponseCreator creator : this.cachedPostResponseCreators) {
            PostResponse response = creator.createPostResponse(req);
            if (response == null) continue;
            return response;
        }
        MediaRangeList mediaRangeList = new MediaRangeList((HttpServletRequest)req);
        if ("application/json".equals(mediaRangeList.prefer("text/html", "application/json"))) {
            return new JSONResponse();
        }
        return new HtmlResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PostOperation getSlingPostOperation(SlingHttpServletRequest request) {
        String operation = request.getParameter(":operation");
        if (operation == null || operation.length() == 0) {
            return this.modifyOperation;
        }
        Map<String, PostOperation> map = this.postOperations;
        synchronized (map) {
            return this.postOperations.get(operation);
        }
    }

    protected String getRedirectUrl(SlingHttpServletRequest request, PostResponse ctx) {
        String result = request.getParameter(":redirect");
        if (result != null) {
            try {
                URI redirectUri = new URI(result);
                if (redirectUri.getAuthority() != null) {
                    this.log.warn("redirect target ({}) does include host information ({}). This is not allowed for security reasons!", (Object)result, (Object)redirectUri.getAuthority());
                    return null;
                }
            }
            catch (URISyntaxException e) {
                this.log.warn("given redirect target ({}) is not a valid uri: {}", (Object)result, (Object)e);
                return null;
            }
            this.log.debug("redirect requested as [{}] for path [{}]", (Object)result, (Object)ctx.getPath());
            int star = result.indexOf(42);
            if (star >= 0 && ctx.getPath() != null) {
                String requestPath;
                StringBuilder buf = new StringBuilder();
                if (star > 0) {
                    buf.append(result.substring(0, star));
                }
                buf.append(ResourceUtil.getName((String)ctx.getPath()));
                if (star < result.length() - 1) {
                    buf.append(result.substring(star + 1));
                }
                if ((requestPath = request.getPathInfo()).endsWith("/") && buf.charAt(0) != '/' && !REDIRECT_WITH_SCHEME_PATTERN.matcher(buf).matches()) {
                    buf.insert(0, requestPath);
                }
                result = buf.toString();
            } else if (result.endsWith("/")) {
                result = result.concat(ResourceUtil.getName((String)ctx.getPath()));
            }
            this.log.debug("Will redirect to {}", (Object)result);
        }
        return result;
    }

    protected boolean isSetStatus(SlingHttpServletRequest request) {
        String statusParam = request.getParameter(":status");
        if (statusParam == null) {
            this.log.debug("getStatusMode: Parameter {} not set, assuming standard status code", (Object)":status");
            return true;
        }
        if ("browser".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for user-friendly status code", (Object)":status");
            return false;
        }
        if ("standard".equals(statusParam)) {
            this.log.debug("getStatusMode: Parameter {} asks for standard status code", (Object)":status");
            return true;
        }
        this.log.debug("getStatusMode: Parameter {} set to unknown value {}, assuming standard status code", (Object)":status");
        return true;
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> configuration) {
        this.configure(configuration);
        ArrayList<ServiceRegistration> providedServices = new ArrayList<ServiceRegistration>();
        BundleContext bundleContext = context.getBundleContext();
        providedServices.add(this.registerOperation(bundleContext, "modify", this.modifyOperation));
        providedServices.add(this.registerOperation(bundleContext, "copy", new CopyOperation()));
        providedServices.add(this.registerOperation(bundleContext, "move", new MoveOperation()));
        providedServices.add(this.registerOperation(bundleContext, "delete", new DeleteOperation()));
        providedServices.add(this.registerOperation(bundleContext, "nop", new NopOperation()));
        providedServices.add(this.registerOperation(bundleContext, "checkin", new CheckinOperation()));
        providedServices.add(this.registerOperation(bundleContext, "checkout", new CheckoutOperation()));
        providedServices.add(this.registerOperation(bundleContext, "restore", new RestoreOperation()));
        providedServices.add(this.registerOperation(bundleContext, "import", this.importOperation));
        this.internalOperations = providedServices.toArray(new ServiceRegistration[providedServices.size()]);
    }

    private ServiceRegistration registerOperation(BundleContext context, String opCode, PostOperation operation) {
        Properties properties = new Properties();
        properties.put("sling.post.operation", opCode);
        properties.put("service.description", "Apache Sling POST Servlet Operation " + opCode);
        properties.put("service.vendor", context.getBundle().getHeaders().get("Bundle-Vendor"));
        return context.registerService("org.apache.sling.servlets.post.PostOperation", (Object)operation, (Dictionary)properties);
    }

    public void init() throws ServletException {
        this.modifyOperation.setServletContext(this.getServletContext());
    }

    @Modified
    private void configure(Map<String, Object> configuration) {
        String[] dateFormats;
        this.baseVersioningConfiguration = this.createBaseVersioningConfiguration(configuration);
        DateParser dateParser = new DateParser();
        for (String dateFormat : dateFormats = OsgiUtil.toStringArray((Object)configuration.get(PROP_DATE_FORMAT))) {
            try {
                dateParser.register(dateFormat);
            }
            catch (Throwable t) {
                this.log.warn("configure: Ignoring DateParser format {} because it is invalid: {}", (Object)dateFormat, (Object)t);
            }
        }
        String[] nameHints = OsgiUtil.toStringArray((Object)configuration.get(PROP_NODE_NAME_HINT_PROPERTIES));
        int nameMax = (int)OsgiUtil.toLong((Object)configuration.get(PROP_NODE_NAME_MAX_LENGTH), (long)-1L);
        DefaultNodeNameGenerator nodeNameGenerator = new DefaultNodeNameGenerator(nameHints, nameMax);
        String paramMatch = OsgiUtil.toString((Object)configuration.get(PROP_IGNORED_PARAMETER_NAME_PATTERN), (String)DEFAULT_IGNORED_PARAMETER_NAME_PATTERN);
        Pattern paramMatchPattern = Pattern.compile(paramMatch);
        this.modifyOperation.setDateParser(dateParser);
        this.modifyOperation.setDefaultNodeNameGenerator(nodeNameGenerator);
        this.importOperation.setDefaultNodeNameGenerator(nodeNameGenerator);
        this.modifyOperation.setIgnoredParameterNamePattern(paramMatchPattern);
        this.importOperation.setIgnoredParameterNamePattern(paramMatchPattern);
    }

    public void destroy() {
        this.modifyOperation.setServletContext(null);
    }

    @Deactivate
    protected void deactivate() {
        if (this.internalOperations != null) {
            for (ServiceRegistration registration : this.internalOperations) {
                registration.unregister();
            }
            this.internalOperations = null;
        }
        this.modifyOperation.setExtraNodeNameGenerators(null);
        this.importOperation.setExtraNodeNameGenerators(null);
        this.importOperation.setContentImporter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPostOperation(PostOperation operation, Map<String, Object> properties) {
        String operationName = (String)properties.get("sling.post.operation");
        if (operationName != null && operation != null) {
            Map<String, PostOperation> map = this.postOperations;
            synchronized (map) {
                this.postOperations.put(operationName, operation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPostOperation(PostOperation operation, Map<String, Object> properties) {
        String operationName = (String)properties.get("sling.post.operation");
        if (operationName != null) {
            Map<String, PostOperation> map = this.postOperations;
            synchronized (map) {
                this.postOperations.remove(operationName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPostProcessor(SlingPostProcessor processor, Map<String, Object> properties) {
        PostProcessorHolder pph = new PostProcessorHolder();
        pph.processor = processor;
        pph.ranking = OsgiUtil.toInteger((Object)properties.get("service.ranking"), (int)0);
        List<PostProcessorHolder> list = this.postProcessors;
        synchronized (list) {
            int index;
            for (index = 0; index < this.postProcessors.size() && pph.ranking < this.postProcessors.get((int)index).ranking; ++index) {
            }
            if (index == this.postProcessors.size()) {
                this.postProcessors.add(pph);
            } else {
                this.postProcessors.add(index, pph);
            }
            this.updatePostProcessorCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPostProcessor(SlingPostProcessor processor, Map<String, Object> properties) {
        List<PostProcessorHolder> list = this.postProcessors;
        synchronized (list) {
            Iterator<PostProcessorHolder> i = this.postProcessors.iterator();
            while (i.hasNext()) {
                PostProcessorHolder current = i.next();
                if (current.processor != processor) continue;
                i.remove();
            }
            this.updatePostProcessorCache();
        }
    }

    private void updatePostProcessorCache() {
        SlingPostProcessor[] localCache = new SlingPostProcessor[this.postProcessors.size()];
        int index = 0;
        for (PostProcessorHolder current : this.postProcessors) {
            localCache[index] = current.processor;
            ++index;
        }
        this.cachedPostProcessors = localCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindNodeNameGenerator(NodeNameGenerator generator, Map<String, Object> properties) {
        NodeNameGeneratorHolder nngh = new NodeNameGeneratorHolder();
        nngh.generator = generator;
        nngh.ranking = OsgiUtil.toInteger((Object)properties.get("service.ranking"), (int)0);
        List<NodeNameGeneratorHolder> list = this.nodeNameGenerators;
        synchronized (list) {
            int index;
            for (index = 0; index < this.nodeNameGenerators.size() && nngh.ranking < this.nodeNameGenerators.get((int)index).ranking; ++index) {
            }
            if (index == this.nodeNameGenerators.size()) {
                this.nodeNameGenerators.add(nngh);
            } else {
                this.nodeNameGenerators.add(index, nngh);
            }
            this.updateNodeNameGeneratorCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindNodeNameGenerator(NodeNameGenerator generator, Map<String, Object> properties) {
        List<NodeNameGeneratorHolder> list = this.nodeNameGenerators;
        synchronized (list) {
            Iterator<NodeNameGeneratorHolder> i = this.nodeNameGenerators.iterator();
            while (i.hasNext()) {
                NodeNameGeneratorHolder current = i.next();
                if (current.generator != generator) continue;
                i.remove();
            }
            this.updateNodeNameGeneratorCache();
        }
    }

    private void updateNodeNameGeneratorCache() {
        NodeNameGenerator[] localCache = new NodeNameGenerator[this.nodeNameGenerators.size()];
        int index = 0;
        for (NodeNameGeneratorHolder current : this.nodeNameGenerators) {
            localCache[index] = current.generator;
            ++index;
        }
        this.cachedNodeNameGenerators = localCache;
        this.modifyOperation.setExtraNodeNameGenerators(this.cachedNodeNameGenerators);
        this.importOperation.setExtraNodeNameGenerators(this.cachedNodeNameGenerators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        PostResponseCreatorHolder nngh = new PostResponseCreatorHolder();
        nngh.creator = creator;
        nngh.ranking = OsgiUtil.toInteger((Object)properties.get("service.ranking"), (int)0);
        List<PostResponseCreatorHolder> list = this.postResponseCreators;
        synchronized (list) {
            int index;
            for (index = 0; index < this.postResponseCreators.size() && nngh.ranking < this.postResponseCreators.get((int)index).ranking; ++index) {
            }
            if (index == this.postResponseCreators.size()) {
                this.postResponseCreators.add(nngh);
            } else {
                this.postResponseCreators.add(index, nngh);
            }
            this.updatePostResponseCreatorCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPostResponseCreator(PostResponseCreator creator, Map<String, Object> properties) {
        List<PostResponseCreatorHolder> list = this.postResponseCreators;
        synchronized (list) {
            Iterator<PostResponseCreatorHolder> i = this.postResponseCreators.iterator();
            while (i.hasNext()) {
                PostResponseCreatorHolder current = i.next();
                if (current.creator != creator) continue;
                i.remove();
            }
            this.updatePostResponseCreatorCache();
        }
    }

    private void updatePostResponseCreatorCache() {
        PostResponseCreator[] localCache = new PostResponseCreator[this.postResponseCreators.size()];
        int index = 0;
        for (PostResponseCreatorHolder current : this.postResponseCreators) {
            localCache[index] = current.creator;
            ++index;
        }
        this.cachedPostResponseCreators = localCache;
    }

    protected void bindContentImporter(ContentImporter importer) {
        this.contentImporter = importer;
        this.importOperation.setContentImporter(importer);
    }

    protected void unbindContentImporter(ContentImporter importer) {
        if (this.contentImporter == importer) {
            this.contentImporter = null;
            this.importOperation.setContentImporter(null);
        }
    }

    private VersioningConfiguration createBaseVersioningConfiguration(Map<?, ?> props) {
        VersioningConfiguration cfg = new VersioningConfiguration();
        cfg.setCheckinOnNewVersionableNode(OsgiUtil.toBoolean(props.get(PROP_CHECKIN_ON_CREATE), (boolean)false));
        cfg.setAutoCheckout(OsgiUtil.toBoolean(props.get(PROP_AUTO_CHECKOUT), (boolean)false));
        cfg.setAutoCheckin(OsgiUtil.toBoolean(props.get(PROP_AUTO_CHECKIN), (boolean)true));
        return cfg;
    }

    private VersioningConfiguration createRequestVersioningConfiguration(SlingHttpServletRequest request) {
        VersioningConfiguration cfg = this.baseVersioningConfiguration.clone();
        String paramValue = request.getParameter(PARAM_CHECKIN_ON_CREATE);
        if (paramValue != null) {
            cfg.setCheckinOnNewVersionableNode(Boolean.parseBoolean(paramValue));
        }
        if ((paramValue = request.getParameter(PARAM_AUTO_CHECKOUT)) != null) {
            cfg.setAutoCheckout(Boolean.parseBoolean(paramValue));
        }
        if ((paramValue = request.getParameter(PARAM_AUTO_CHECKIN)) != null) {
            cfg.setAutoCheckin(Boolean.parseBoolean(paramValue));
        }
        return cfg;
    }

    private static final class PostResponseCreatorHolder {
        public PostResponseCreator creator;
        public int ranking;

        private PostResponseCreatorHolder() {
        }
    }

    private static final class NodeNameGeneratorHolder {
        public NodeNameGenerator generator;
        public int ranking;

        private NodeNameGeneratorHolder() {
        }
    }

    private static final class PostProcessorHolder {
        public SlingPostProcessor processor;
        public int ranking;

        private PostProcessorHolder() {
        }
    }
}

