/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.xss.ProtectionContext;
import org.apache.sling.xss.XSSAPI;
import org.apache.sling.xss.XSSFilter;
import org.apache.sling.xss.impl.LongValidationRule;
import org.owasp.encoder.Encode;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

@Component
@Service(value={XSSAPI.class})
public class XSSAPIImpl
implements XSSAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(XSSAPIImpl.class);
    @Reference
    private XSSFilter xssFilter = null;
    private Validator validator = ESAPI.validator();
    private static final Pattern PATTERN_AUTO_DIMENSION = Pattern.compile("['\"]?auto['\"]?");
    private SAXParserFactory factory;
    private static final String LINK_PREFIX = "<a href=\"";
    private static final String LINK_SUFFIX = "\"></a>";
    private static final String MANGLE_NAMESPACE_OUT_SUFFIX = ":";
    private static final String MANGLE_NAMESPACE_OUT = "/([^:/]+):";
    private static final Pattern MANGLE_NAMESPACE_PATTERN = Pattern.compile("/([^:/]+):");
    private static final String MANGLE_NAMESPACE_IN_SUFFIX = "_";
    private static final String MANGLE_NAMESPACE_IN_PREFIX = "/_";
    private static final String SCHEME_PATTERN = "://";
    private static final String NON_ASCII = "\\x00\\x08\\x0B\\x0C\\x0E-\\x1F";
    private static final String NUMBER = "[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?";
    private static final String HEX_DIGITS = "#[0-9a-f]*";
    private static final String IDENTIFIER = "-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*";
    private static final String STRING = "\"(?:(?!javascript\\s?:)[^\"^\\\\^\\n]|(?:\\\\\"))*\"|'(?:(?!javascript\\s?:)[^'^\\\\^\\n]|(?:\\\\'))*'";
    private static final String DIMENSION = "[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*";
    private static final String PERCENT = "[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?%";
    private static final String FUNCTION = "-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*\\((?:(?:[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?)|(?:-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*)|(?:[\\s]*)|(?:,))*\\)";
    private static final String URL_UNQUOTED = "[^\"^'^\\(^\\)^[\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]]*";
    private static final String URL = "url\\((?:(?:[^\"^'^\\(^\\)^[\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]]*)|(?:\"(?:(?!javascript\\s?:)[^\"^\\\\^\\n]|(?:\\\\\"))*\"|'(?:(?!javascript\\s?:)[^'^\\\\^\\n]|(?:\\\\'))*'))\\)";
    private static final String CSS_TOKEN = "(?i)(?:[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?)|(?:[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*)|(?:[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?%)|(?:#[0-9a-f]*)|(?:-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*)|(?:\"(?:(?!javascript\\s?:)[^\"^\\\\^\\n]|(?:\\\\\"))*\"|'(?:(?!javascript\\s?:)[^'^\\\\^\\n]|(?:\\\\'))*')|(?:-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*\\((?:(?:[+-]?[\\d]*[\\.]?[\\d]*(?:[e][+-]?\\d+)?)|(?:-?[a-z_\\x00\\x08\\x0B\\x0C\\x0E-\\x1F][\\w_\\-\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]*)|(?:[\\s]*)|(?:,))*\\))|(?:url\\((?:(?:[^\"^'^\\(^\\)^[\\x00\\x08\\x0B\\x0C\\x0E-\\x1F]]*)|(?:\"(?:(?!javascript\\s?:)[^\"^\\\\^\\n]|(?:\\\\\"))*\"|'(?:(?!javascript\\s?:)[^'^\\\\^\\n]|(?:\\\\'))*'))\\))";

    @Activate
    protected void activate() {
        this.factory = SAXParserFactory.newInstance();
        this.factory.setValidating(false);
        this.factory.setNamespaceAware(true);
    }

    @Deactivate
    protected void deactivate() {
        this.factory = null;
    }

    @Override
    public Integer getValidInteger(String integer, int defaultValue) {
        if (integer != null && integer.length() > 0) {
            try {
                return this.validator.getValidInteger("XSS", integer, -2000000000, 2000000000, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public Long getValidLong(String source, long defaultValue) {
        if (source != null && source.length() > 0) {
            try {
                LongValidationRule ivr = new LongValidationRule("number", ESAPI.encoder(), -9000000000000000000L, 9000000000000000000L);
                ivr.setAllowNull(false);
                return ivr.getValid("XSS", source);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public String getValidDimension(String dimension, String defaultValue) {
        if (dimension != null && dimension.length() > 0) {
            if (PATTERN_AUTO_DIMENSION.matcher(dimension).matches()) {
                return "\"auto\"";
            }
            try {
                return this.validator.getValidInteger("XSS", dimension, -10000, 10000, false).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private String mangleNamespaces(String absPath) {
        if (absPath != null) {
            String manglePath;
            String prefix;
            int schemeIndex = absPath.indexOf(SCHEME_PATTERN);
            if (schemeIndex != -1) {
                int pathIndex = absPath.indexOf("/", schemeIndex + 3);
                if (pathIndex != -1) {
                    prefix = absPath.substring(0, pathIndex);
                    manglePath = absPath.substring(pathIndex);
                } else {
                    prefix = absPath;
                    manglePath = "";
                }
            } else {
                prefix = "";
                manglePath = absPath;
            }
            if (manglePath.contains(MANGLE_NAMESPACE_OUT_SUFFIX)) {
                Matcher m = MANGLE_NAMESPACE_PATTERN.matcher(manglePath);
                StringBuffer buf = new StringBuffer();
                while (m.find()) {
                    String replacement = MANGLE_NAMESPACE_IN_PREFIX + m.group(1) + MANGLE_NAMESPACE_IN_SUFFIX;
                    m.appendReplacement(buf, replacement);
                }
                m.appendTail(buf);
                absPath = prefix + buf.toString();
            }
        }
        return absPath;
    }

    @Override
    @Nonnull
    public String getValidHref(String url) {
        if (url != null && url.length() > 0) {
            String encodedUrl = url.replaceAll("\"", "%22").replaceAll("'", "%27").replaceAll(">", "%3E").replaceAll("<", "%3C").replaceAll("`", "%60").replaceAll(" ", "%20");
            int qMarkIx = encodedUrl.indexOf(63);
            if (qMarkIx > 0) {
                encodedUrl = encodedUrl.substring(0, qMarkIx) + encodedUrl.substring(qMarkIx).replaceAll(MANGLE_NAMESPACE_OUT_SUFFIX, "%3A");
            }
            if (this.xssFilter.isValidHref(encodedUrl = this.mangleNamespaces(encodedUrl))) {
                return encodedUrl;
            }
        }
        return "";
    }

    @Override
    public String getValidJSToken(String token, String defaultValue) {
        if (token != null && token.length() > 0) {
            String q = (token = token.trim()).substring(0, 1);
            if (q.matches("['\"]") && token.endsWith(q)) {
                String literal = token.substring(1, token.length() - 1);
                return q + this.encodeForJSString(literal) + q;
            }
            if (token.matches("[0-9a-zA-Z_$][0-9a-zA-Z_$.]*")) {
                return token;
            }
        }
        return defaultValue;
    }

    @Override
    public String getValidStyleToken(String token, String defaultValue) {
        if (token != null && token.length() > 0 && token.matches(CSS_TOKEN)) {
            return token;
        }
        return defaultValue;
    }

    @Override
    public String getValidCSSColor(String color, String defaultColor) {
        if (color != null && color.length() > 0) {
            if ((color = color.trim()).matches("(?i)[#a-fghlrs(+0-9-.%,) \\t\\n\\x0B\\f\\r]+")) {
                return color;
            }
            if (color.matches("(?i)[a-zA-Z \\t\\n\\x0B\\f\\r]+")) {
                return color;
            }
        }
        return defaultColor;
    }

    @Override
    public String getValidMultiLineComment(String comment, String defaultComment) {
        if (comment != null && !comment.contains("*/")) {
            return comment;
        }
        return defaultComment;
    }

    @Override
    public String getValidJSON(String json, String defaultJson) {
        if (json == null) {
            return this.getValidJSON(defaultJson, "");
        }
        if ("".equals(json = json.trim())) {
            return "";
        }
        int curlyIx = json.indexOf("{");
        int straightIx = json.indexOf("[");
        if (curlyIx >= 0 && (curlyIx < straightIx || straightIx < 0)) {
            try {
                JSONObject obj = new JSONObject(json);
                return obj.toString();
            }
            catch (JSONException e) {
                LOGGER.debug("JSON validation failed: " + e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                JSONArray arr = new JSONArray(json);
                return arr.toString();
            }
            catch (JSONException e) {
                LOGGER.debug("JSON validation failed: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.getValidJSON(defaultJson, "");
    }

    @Override
    public String getValidXML(String xml, String defaultXml) {
        if (xml == null) {
            return this.getValidXML(defaultXml, "");
        }
        if ("".equals(xml = xml.trim())) {
            return "";
        }
        try {
            SAXParser parser = this.factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.parse(new InputSource(new StringReader(xml)));
            return xml;
        }
        catch (Exception e) {
            LOGGER.debug("XML validation failed: " + e.getMessage(), (Throwable)e);
            return this.getValidXML(defaultXml, "");
        }
    }

    @Override
    public String encodeForHTML(String source) {
        return source == null ? null : Encode.forHtml(source);
    }

    @Override
    public String encodeForHTMLAttr(String source) {
        return source == null ? null : Encode.forHtmlAttribute(source);
    }

    @Override
    public String encodeForXML(String source) {
        return source == null ? null : Encode.forXml(source);
    }

    @Override
    public String encodeForXMLAttr(String source) {
        return source == null ? null : Encode.forXmlAttribute(source);
    }

    @Override
    public String encodeForJSString(String source) {
        return source == null ? null : Encode.forJavaScript(source);
    }

    @Override
    public String encodeForCSSString(String source) {
        return source == null ? null : Encode.forCssString(source);
    }

    @Override
    @Nonnull
    public String filterHTML(String source) {
        return this.xssFilter.filter(ProtectionContext.HTML_HTML_CONTENT, source);
    }

    @Override
    public XSSAPI getRequestSpecificAPI(SlingHttpServletRequest request) {
        return this;
    }

    @Override
    public XSSAPI getResourceResolverSpecificAPI(ResourceResolver resourceResolver) {
        return this;
    }

    protected void bindXssFilter(XSSFilter xSSFilter) {
        this.xssFilter = xSSFilter;
    }

    protected void unbindXssFilter(XSSFilter xSSFilter) {
        if (this.xssFilter == xSSFilter) {
            this.xssFilter = null;
        }
    }
}

