/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.io.ModelReader;
import org.apache.sling.provisioning.model.io.ModelWriter;
import org.codehaus.plexus.logging.Logger;

public abstract class ModelUtils {
    private static final String RAW_MODEL_TXT = Model.class.getName() + "/raw.txt";
    private static final String EFFECTIVE_MODEL_TXT = Model.class.getName() + "/effective.txt";
    private static final String RAW_MODEL = Model.class.getName() + "/raw";
    private static final String EFFECTIVE_MODEL = Model.class.getName() + "/effective";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Model readLocalModel(File systemsDirectory, MavenProject project, MavenSession session, Logger logger) throws MojoExecutionException {
        Model result = new Model();
        ArrayList<String> candidates = new ArrayList<String>();
        if (systemsDirectory != null && systemsDirectory.exists()) {
            for (File f : systemsDirectory.listFiles()) {
                if (!f.isFile() || !f.getName().endsWith(".txt") || f.getName().startsWith(".")) continue;
                candidates.add(f.getName());
            }
            Collections.sort(candidates);
        }
        if (candidates.size() == 0) {
            throw new MojoExecutionException("No model files found in " + systemsDirectory);
        }
        for (String name : candidates) {
            logger.debug("Reading model " + name + " in project " + project.getId());
            try {
                File f = new File(systemsDirectory, name);
                FileReader reader = new FileReader(f);
                try {
                    Model current = ModelReader.read((Reader)reader, (String)f.getAbsolutePath());
                    Map errors = ModelUtility.validate((Model)current);
                    if (errors != null) {
                        throw new MojoExecutionException("Invalid model at " + name + " : " + errors);
                    }
                    ModelUtility.merge((Model)result, (Model)current);
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            catch (IOException io) {
                throw new MojoExecutionException("Unable to read " + name, (Exception)io);
            }
        }
        Map errors = ModelUtility.validate((Model)result);
        if (errors != null) {
            throw new MojoExecutionException("Invalid assembled model : " + errors);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model readFullModel(File systemsDirectory, List<File> dependentModels, MavenProject project, MavenSession session, Logger logger) throws MojoExecutionException {
        try {
            Model result;
            Model localModel = ModelUtils.readLocalModel(systemsDirectory, project, session, logger);
            Model depModel = null;
            for (File file : dependentModels) {
                FileReader r = null;
                try {
                    Model readModel;
                    Map errors;
                    r = new FileReader(file);
                    if (depModel == null) {
                        depModel = new Model();
                    }
                    if ((errors = ModelUtility.validate((Model)(readModel = ModelReader.read((Reader)r, (String)file.getAbsolutePath())))) != null) {
                        throw new MojoExecutionException("Invalid model at " + file + " : " + errors);
                    }
                    ModelUtility.merge((Model)depModel, (Model)readModel);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(r);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)r);
            }
            if (depModel != null) {
                Map errors = ModelUtility.validate(depModel);
                if (errors != null) {
                    throw new MojoExecutionException("Invalid model : " + errors);
                }
                ModelUtility.merge(depModel, (Model)localModel);
                errors = ModelUtility.validate(depModel);
                if (errors != null) {
                    throw new MojoExecutionException("Invalid model : " + errors);
                }
                result = depModel;
            } else {
                result = localModel;
            }
            return result;
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to cache model", (Exception)ioe);
        }
    }

    public static Artifact getBaseArtifact(Model model) throws MojoExecutionException {
        Feature base = model.getFeature(":launchpad");
        if (base == null) {
            throw new MojoExecutionException("No launchpad feature found.");
        }
        RunMode runMode = base.getRunMode(null);
        if (runMode == null) {
            throw new MojoExecutionException("No global run mode found in launchpad feature.");
        }
        if (runMode.getArtifactGroups().isEmpty()) {
            throw new MojoExecutionException("No base artifacts defined.");
        }
        if (runMode.getArtifactGroups().size() > 1) {
            throw new MojoExecutionException("Base run mode should only have a single start level.");
        }
        Artifact firstArtifact = null;
        for (Artifact a : (ArtifactGroup)runMode.getArtifactGroups().get(0)) {
            if (firstArtifact == null) {
                firstArtifact = a;
                continue;
            }
            throw new MojoExecutionException("Base run mode should contain exactly one artifact.");
        }
        return firstArtifact;
    }

    public static org.apache.maven.artifact.Artifact getArtifact(MavenProject project, MavenSession session, ArtifactHandlerManager artifactHandlerManager, ArtifactResolver resolver, String groupId, String artifactId, String version, String type, String classifier) throws MojoExecutionException {
        Set artifacts = project.getDependencyArtifacts();
        for (org.apache.maven.artifact.Artifact artifact : artifacts) {
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId) || !artifact.getVersion().equals(version) || !artifact.getType().equals(type) || (classifier != null || artifact.getClassifier() != null) && (classifier == null || !classifier.equals(artifact.getClassifier()))) continue;
            return artifact;
        }
        DefaultArtifact prjArtifact = new DefaultArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), "provided", type, classifier, artifactHandlerManager.getArtifactHandler(type));
        try {
            resolver.resolve((org.apache.maven.artifact.Artifact)prjArtifact, project.getRemoteArtifactRepositories(), session.getLocalRepository());
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to get artifact for " + groupId + ":" + artifactId + ":" + version, (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to get artifact for " + groupId + ":" + artifactId + ":" + version, (Exception)((Object)e));
        }
        return prjArtifact;
    }

    public static void storeRawModel(MavenProject project, Model model) throws IOException {
        StringWriter w = new StringWriter();
        ModelWriter.write((Writer)w, (Model)model);
        project.setContextValue(RAW_MODEL_TXT, (Object)w.toString());
    }

    public static Model getRawModel(MavenProject project) throws MojoExecutionException {
        Model result = (Model)project.getContextValue(RAW_MODEL);
        if (result == null) {
            String contents = (String)project.getContextValue(RAW_MODEL_TXT);
            try {
                result = ModelReader.read((Reader)new StringReader(contents), null);
                project.setContextValue(RAW_MODEL, (Object)result);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to read cached model.", (Exception)ioe);
            }
        }
        return result;
    }

    public static void storeEffectiveModel(MavenProject project, Model model) throws IOException {
        StringWriter w = new StringWriter();
        ModelWriter.write((Writer)w, (Model)model);
        project.setContextValue(EFFECTIVE_MODEL_TXT, (Object)w.toString());
    }

    public static Model getEffectiveModel(MavenProject project) throws MojoExecutionException {
        Model result = (Model)project.getContextValue(EFFECTIVE_MODEL);
        if (result == null) {
            String contents = (String)project.getContextValue(EFFECTIVE_MODEL_TXT);
            try {
                result = ModelUtility.getEffectiveModel((Model)ModelReader.read((Reader)new StringReader(contents), null), null);
                project.setContextValue(EFFECTIVE_MODEL, (Object)result);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to read cached model.", (Exception)ioe);
            }
        }
        return result;
    }
}

