/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.maven.slingstart.AbstractSlingStartMojo;
import org.apache.sling.maven.slingstart.JarArchiverHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(name="package", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class PackageMojo
extends AbstractSlingStartMojo {
    private static final String[] EXCLUDES_MANIFEST = new String[]{"META-INF/MANIFEST.MF"};
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map globalContentsMap = (Map)this.project.getContextValue("slingstart:global");
        this.packageStandaloneApp(globalContentsMap);
        this.packageWebapp(globalContentsMap);
    }

    private void packageStandaloneApp(Map<String, File> globalContentsMap) throws MojoExecutionException {
        FileInputStream fis;
        block5: {
            this.getLog().info((CharSequence)"Packaging standalone jar...");
            File buildDirectory = new File(this.project.getBuild().getDirectory());
            Map contentsMap = (Map)this.project.getContextValue("slingstart:standalone");
            File buildOutputDirectory = new File(this.project.getBuild().getOutputDirectory());
            File manifestFile = new File(buildOutputDirectory, "META-INF/MANIFEST.MF");
            fis = null;
            try {
                fis = new FileInputStream(manifestFile);
                Manifest mf = new Manifest(fis);
                File outputFile = new File(buildDirectory, this.project.getArtifactId() + "-" + this.project.getVersion() + ".jar");
                JarArchiverHelper helper = new JarArchiverHelper(this.jarArchiver, this.project, outputFile, mf);
                helper.addDirectory(buildOutputDirectory, null, EXCLUDES_MANIFEST);
                helper.addArtifacts(globalContentsMap, "");
                helper.addArtifacts(contentsMap, "");
                helper.createArchive();
                if ("slingstart".equals(this.project.getPackaging())) {
                    this.project.getArtifact().setFile(outputFile);
                    break block5;
                }
                this.projectHelper.attachArtifact(this.project, "jar", "app", outputFile);
            }
            catch (IOException ioe) {
                try {
                    throw new MojoExecutionException("Unable to create standalone jar", (Exception)ioe);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
    }

    private void packageWebapp(Map<String, File> globalContentsMap) throws MojoExecutionException {
        if (this.createWebapp) {
            this.getLog().info((CharSequence)"Packaging webapp...");
            File buildDirectory = new File(this.project.getBuild().getDirectory());
            Map contentsMap = (Map)this.project.getContextValue("slingstart:webapp");
            File buildOutputDirectory = new File(buildDirectory, "slingstart-webapp");
            File outputFile = new File(buildDirectory, this.project.getArtifactId() + "-" + this.project.getVersion() + ".war");
            JarArchiverHelper helper = new JarArchiverHelper(this.jarArchiver, this.project, outputFile);
            helper.addDirectory(buildOutputDirectory, null, EXCLUDES_MANIFEST);
            helper.addArtifacts(globalContentsMap, "WEB-INF/");
            helper.addArtifacts(contentsMap, "WEB-INF/");
            helper.createArchive();
            this.projectHelper.attachArtifact(this.project, "war", "webapp", outputFile);
        }
    }
}

