/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.maven.slingstart.AbstractSlingStartMojo;
import org.apache.sling.maven.slingstart.ModelUtils;
import org.apache.sling.maven.slingstart.PomArtifactVersionResolver;
import org.apache.sling.maven.slingstart.PomVariableResolver;
import org.apache.sling.maven.slingstart.ProjectHelper;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.io.ModelWriter;

@Mojo(name="repository", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class RepositoryMojo
extends AbstractSlingStartMojo {
    private static final String DIR_NAME = "artifacts";
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ArtifactResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Creating repository...");
        File artifactDir = new File(this.project.getBuild().getDirectory(), DIR_NAME);
        Model model = ProjectHelper.getEffectiveModel(this.project, this.getResolverOptions());
        for (Feature feature : model.getFeatures()) {
            for (RunMode runMode : feature.getRunModes()) {
                for (ArtifactGroup group : runMode.getArtifactGroups()) {
                    for (Artifact artifact : group) {
                        this.copyArtifactToRepository(artifact, artifactDir);
                    }
                }
            }
        }
        try {
            Artifact baseArtifact = ModelUtils.findBaseArtifact(model);
            Artifact appArtifact = new Artifact(baseArtifact.getGroupId(), baseArtifact.getArtifactId(), baseArtifact.getVersion(), "app", "jar");
            this.copyArtifactToRepository(appArtifact, artifactDir);
        }
        catch (MavenExecutionException mee) {
            throw new MojoExecutionException(mee.getMessage(), mee.getCause());
        }
        Model rawModel = ProjectHelper.getRawModel(this.project);
        if (this.usePomVariables) {
            rawModel = ModelUtility.applyVariables((Model)rawModel, (ModelUtility.VariableResolver)new PomVariableResolver(this.project));
        }
        if (this.usePomDependencies) {
            rawModel = ModelUtility.applyArtifactVersions((Model)rawModel, (ModelUtility.ArtifactVersionResolver)new PomArtifactVersionResolver(this.project, this.allowUnresolvedPomDependencies));
        }
        String classifier = this.project.getPackaging().equals("slingfeature") ? null : "slingfeature";
        Artifact rawModelArtifact = new Artifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), classifier, "txt");
        File rawModelFile = this.getRepositoryFile(artifactDir, rawModelArtifact);
        FileWriter writer = null;
        try {
            writer = new FileWriter(rawModelFile);
            ModelWriter.write((Writer)writer, (Model)rawModel);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Unable to write model to " + rawModelFile, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        for (Map.Entry<String, String> entry : ProjectHelper.getDependencyModel(this.project).entrySet()) {
            Artifact modelDepArtifact = Artifact.fromMvnUrl((String)entry.getKey());
            String modelClassifier = modelDepArtifact.getType().equals("slingstart") ? "slingfeature" : modelDepArtifact.getClassifier();
            Artifact modelArtifact = new Artifact(modelDepArtifact.getGroupId(), modelDepArtifact.getArtifactId(), modelDepArtifact.getVersion(), modelClassifier, "txt");
            File modelFile = this.getRepositoryFile(artifactDir, modelArtifact);
            FileWriter modelWriter = null;
            try {
                modelWriter = new FileWriter(modelFile);
                modelWriter.write(entry.getValue());
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("Unable to write model to " + modelFile, (Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(modelWriter);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)modelWriter);
        }
    }

    private File getRepositoryFile(File artifactDir, Artifact artifact) {
        StringBuilder artifactNameBuilder = new StringBuilder();
        artifactNameBuilder.append(artifact.getArtifactId());
        artifactNameBuilder.append('-');
        artifactNameBuilder.append(artifact.getVersion());
        if (artifact.getClassifier() != null && artifact.getClassifier().length() > 0) {
            artifactNameBuilder.append('-');
            artifactNameBuilder.append(artifact.getClassifier());
        }
        artifactNameBuilder.append('.');
        artifactNameBuilder.append(artifact.getType());
        String artifactName = artifactNameBuilder.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId().replace('.', File.separatorChar));
        sb.append(File.separatorChar);
        sb.append(artifact.getArtifactId());
        sb.append(File.separatorChar);
        sb.append(artifact.getVersion());
        sb.append(File.separatorChar);
        sb.append(artifactName);
        String destPath = sb.toString();
        File artifactFile = new File(artifactDir, destPath);
        artifactFile.getParentFile().mkdirs();
        return artifactFile;
    }

    private void copyArtifactToRepository(Artifact artifact, File artifactDir) throws MojoExecutionException {
        File artifactFile = this.getRepositoryFile(artifactDir, artifact);
        org.apache.maven.artifact.Artifact source = ModelUtils.getArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.resolver, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getClassifier());
        try {
            FileUtils.copyFile((File)source.getFile(), (File)artifactFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy artifact from " + source.getFile(), (Exception)e);
        }
    }
}

