/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart.run;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.sling.maven.slingstart.run.LauncherCallable;
import org.apache.sling.maven.slingstart.run.ProcessDescription;
import org.apache.sling.maven.slingstart.run.ProcessDescriptionProvider;
import org.apache.sling.maven.slingstart.run.StartMojo;

@Mojo(name="stop", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true)
public class StopMojo
extends StartMojo {
    @Override
    public void execute() throws MojoExecutionException {
        if (this.skipLaunchpad) {
            this.getLog().info((CharSequence)"Executing of the stop-multiple launchpad mojo is disabled by configuration.");
            return;
        }
        Properties launchpadConfigProps = new Properties();
        FileReader reader = null;
        try {
            reader = new FileReader(this.systemPropertiesFile);
            launchpadConfigProps.load(reader);
        }
        catch (IOException ioe) {
            try {
                throw new MojoExecutionException("Unable to read launchpad runner configuration properties.", (Exception)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        int instances = Integer.valueOf(launchpadConfigProps.getProperty("launchpad.instances"));
        ArrayList<ProcessDescription> configurations = new ArrayList<ProcessDescription>();
        for (int i = 1; i <= instances; ++i) {
            String id = launchpadConfigProps.getProperty("launchpad.instance.id." + String.valueOf(i));
            ProcessDescription config = ProcessDescriptionProvider.getInstance().getRunConfiguration(id);
            if (config == null) {
                this.getLog().warn((CharSequence)("No launchpad configuration found for instance " + id));
                continue;
            }
            configurations.add(config);
        }
        if (configurations.size() > 0) {
            this.getLog().info((CharSequence)("Stopping " + configurations.size() + " Launchpad instances"));
            for (ProcessDescription cfg : configurations) {
                try {
                    LauncherCallable.stop(this.getLog(), cfg);
                    ProcessDescriptionProvider.getInstance().removeRunConfiguration(cfg.getId());
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Could not stop launchpad " + cfg.getId(), e);
                }
            }
        } else {
            this.getLog().warn((CharSequence)("No stored configuration file was found at " + this.systemPropertiesFile + " - no Launchapd will be stopped"));
        }
    }
}

