/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.slingstart.ModelPreprocessor;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class)
public class DependencyLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String PLUGIN_ID = "slingstart-maven-plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement
    private ArtifactResolver resolver;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        ModelPreprocessor.Environment env = new ModelPreprocessor.Environment();
        env.artifactHandlerManager = this.artifactHandlerManager;
        env.resolver = this.resolver;
        env.logger = this.logger;
        env.session = session;
        this.logger.debug("Searching for slingstart/slingfeature projects...");
        for (MavenProject project : session.getProjects()) {
            if (!project.getPackaging().equals("slingstart") && !project.getPackaging().equals("slingfeature")) continue;
            this.logger.debug("Found " + project.getPackaging() + " project: " + project);
            ModelPreprocessor.ProjectInfo info = new ModelPreprocessor.ProjectInfo();
            for (Plugin plugin : project.getBuild().getPlugins()) {
                if (!plugin.getArtifactId().equals(PLUGIN_ID)) continue;
                info.plugin = plugin;
                break;
            }
            info.project = project;
            env.modelProjects.put(project.getGroupId() + ":" + project.getArtifactId(), info);
        }
        new ModelPreprocessor().addDependencies(env);
    }
}

