/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.slingstart.ModelUtils;
import org.apache.sling.maven.slingstart.PomArtifactVersionResolver;
import org.apache.sling.maven.slingstart.PomVariableResolver;
import org.apache.sling.maven.slingstart.ProjectHelper;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.ModelUtility;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.io.ModelReader;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class ModelPreprocessor {
    public void addDependencies(Environment env) throws MavenExecutionException {
        for (ProjectInfo info : env.modelProjects.values()) {
            this.addDependencies(env, info);
        }
    }

    private Model addDependencies(Environment env, ProjectInfo info) throws MavenExecutionException {
        if (info.done) {
            env.logger.debug("Return prepared model for " + info.project);
            return info.model;
        }
        info.done = true;
        env.logger.debug("Processing project " + info.project);
        String directory = this.nodeValue(info.plugin, "modelDirectory", new File(info.project.getBasedir(), "src/main/provisioning").getAbsolutePath());
        String inlinedModel = this.nodeValue(info.plugin, "model", null);
        try {
            info.localModel = this.readLocalModel(info.project, inlinedModel, new File(directory), env.logger);
        }
        catch (IOException ioe) {
            throw new MavenExecutionException(ioe.getMessage(), (Throwable)ioe);
        }
        ModelUtility.ResolverOptions resolverOptions = new ModelUtility.ResolverOptions();
        if (this.nodeBooleanValue(info.plugin, "usePomVariables", false)) {
            resolverOptions.variableResolver((ModelUtility.VariableResolver)new PomVariableResolver(info.project));
        }
        if (this.nodeBooleanValue(info.plugin, "usePomDependencies", false)) {
            resolverOptions.artifactVersionResolver((ModelUtility.ArtifactVersionResolver)new PomArtifactVersionResolver(info.project, this.nodeBooleanValue(info.plugin, "allowUnresolvedPomDependencies", false)));
        }
        Model effectiveModel = ModelUtility.getEffectiveModel((Model)info.localModel, (ModelUtility.ResolverOptions)resolverOptions);
        List<Model> dependencies = this.searchSlingstartDependencies(env, info, info.localModel, effectiveModel);
        info.model = new Model();
        for (Model d : dependencies) {
            this.mergeModels(info.model, d);
        }
        this.mergeModels(info.model, info.localModel);
        info.localModel = info.model;
        info.model = ModelUtility.getEffectiveModel((Model)info.model, (ModelUtility.ResolverOptions)resolverOptions);
        Map errors = ModelUtility.validate((Model)info.model);
        if (errors != null) {
            throw new MavenExecutionException("Unable to create model file for " + info.project + " : " + errors, (File)null);
        }
        this.addDependenciesFromModel(env, info);
        try {
            ProjectHelper.storeProjectInfo(info);
        }
        catch (IOException ioe) {
            throw new MavenExecutionException(ioe.getMessage(), (Throwable)ioe);
        }
        return info.model;
    }

    private void addDependenciesFromModel(Environment env, ProjectInfo info) throws MavenExecutionException {
        if (info.project.getPackaging().equals("slingstart")) {
            String[] classifiers;
            Artifact baseArtifact = ModelUtils.findBaseArtifact(info.model);
            for (String c : classifiers = new String[]{null, "app", "webapp"}) {
                Dependency dep = new Dependency();
                dep.setGroupId(baseArtifact.getGroupId());
                dep.setArtifactId(baseArtifact.getArtifactId());
                dep.setVersion(baseArtifact.getVersion());
                dep.setType(baseArtifact.getType());
                dep.setClassifier(c);
                if ("webapp".equals(c)) {
                    dep.setType("war");
                }
                dep.setScope("provided");
                info.project.getDependencies().add(dep);
                env.logger.debug("- adding base dependency " + ModelUtils.toString(dep));
            }
        }
        for (Feature feature : info.model.getFeatures()) {
            if (feature.getName().equals(":launchpad")) continue;
            for (RunMode runMode : feature.getRunModes()) {
                for (ArtifactGroup group : runMode.getArtifactGroups()) {
                    for (Artifact a : group) {
                        if (a.getGroupId().equals(info.project.getGroupId()) && a.getArtifactId().equals(info.project.getArtifactId()) && a.getVersion().equals(info.project.getVersion())) {
                            env.logger.debug("- skipping dependency " + a.toMvnUrl());
                            continue;
                        }
                        Dependency dep = new Dependency();
                        dep.setGroupId(a.getGroupId());
                        dep.setArtifactId(a.getArtifactId());
                        dep.setVersion(a.getVersion());
                        dep.setType(a.getType());
                        dep.setClassifier(a.getClassifier());
                        dep.setScope("provided");
                        env.logger.debug("- adding dependency " + ModelUtils.toString(dep));
                        info.project.getDependencies().add(dep);
                    }
                }
            }
        }
    }

    private List<Model> searchSlingstartDependencies(Environment env, ProjectInfo info, Model rawModel, Model effectiveModel) throws MavenExecutionException {
        ArrayList<Model> dependencies = new ArrayList<Model>();
        for (Feature feature : effectiveModel.getFeatures()) {
            for (RunMode runMode : feature.getRunModes()) {
                for (ArtifactGroup group : runMode.getArtifactGroups()) {
                    ArrayList<Artifact> removeList = new ArrayList<Artifact>();
                    for (Artifact a : group) {
                        if (!a.getType().equals("slingstart") && !a.getType().equals("slingfeature")) continue;
                        Dependency dep = new Dependency();
                        dep.setGroupId(a.getGroupId());
                        dep.setArtifactId(a.getArtifactId());
                        dep.setVersion(a.getVersion());
                        dep.setType("slingfeature");
                        if (a.getType().equals("slingstart")) {
                            dep.setClassifier("slingfeature");
                        } else {
                            dep.setClassifier(a.getClassifier());
                        }
                        dep.setScope("provided");
                        env.logger.debug("- adding dependency " + ModelUtils.toString(dep));
                        info.project.getDependencies().add(dep);
                        String key = a.getGroupId() + ":" + a.getArtifactId();
                        ProjectInfo depInfo = env.modelProjects.get(key);
                        if (depInfo != null) {
                            env.logger.debug("Found reactor " + a.getType() + " dependency : " + a);
                            Model model = this.addDependencies(env, depInfo);
                            if (model == null) {
                                throw new MavenExecutionException("Recursive model dependency list including project " + info.project, (File)null);
                            }
                            dependencies.add(model);
                            info.includedModels.put(a, depInfo.localModel);
                        } else {
                            env.logger.debug("Found external " + a.getType() + " dependency: " + a);
                            File modelFile = this.resolveSlingstartArtifact(env, info.project, dep);
                            FileReader r = null;
                            try {
                                r = new FileReader(modelFile);
                                Model model = ModelReader.read((Reader)r, (String)modelFile.getAbsolutePath());
                                info.includedModels.put(a, model);
                                Map errors = ModelUtility.validate((Model)model);
                                if (errors != null) {
                                    throw new MavenExecutionException("Unable to read model file from " + modelFile + " : " + errors, modelFile);
                                }
                                Model fullModel = this.processSlingstartDependencies(env, info, dep, model);
                                dependencies.add(fullModel);
                            }
                            catch (IOException ioe) {
                                throw new MavenExecutionException("Unable to read model file from " + modelFile, (Throwable)ioe);
                            }
                            finally {
                                try {
                                    if (r != null) {
                                        r.close();
                                    }
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        removeList.add(a);
                    }
                    for (Artifact r : removeList) {
                        ArtifactGroup localAG;
                        RunMode localRunMode;
                        group.remove((Object)r);
                        Feature localModelFeature = rawModel.getFeature(feature.getName());
                        if (localModelFeature == null || (localRunMode = localModelFeature.getRunMode(runMode.getNames())) == null || (localAG = localRunMode.getArtifactGroup(group.getStartLevel())) == null) continue;
                        localAG.remove((Object)r);
                    }
                }
            }
        }
        return dependencies;
    }

    private Model processSlingstartDependencies(Environment env, ProjectInfo info, Dependency dep, Model rawModel) throws MavenExecutionException {
        env.logger.debug("Processing dependency " + dep);
        Model effectiveModel = ModelUtility.getEffectiveModel((Model)rawModel, (ModelUtility.ResolverOptions)new ModelUtility.ResolverOptions());
        List<Model> dependencies = this.searchSlingstartDependencies(env, info, rawModel, effectiveModel);
        Model mergingModel = new Model();
        for (Model d : dependencies) {
            this.mergeModels(mergingModel, d);
        }
        this.mergeModels(mergingModel, rawModel);
        Map errors = ModelUtility.validate((Model)ModelUtility.getEffectiveModel((Model)mergingModel, (ModelUtility.ResolverOptions)new ModelUtility.ResolverOptions()));
        if (errors != null) {
            throw new MavenExecutionException("Unable to create model file for " + dep + " : " + errors, (File)null);
        }
        return mergingModel;
    }

    private String nodeValue(Plugin plugin, String name, String defaultValue) {
        Xpp3Dom node;
        Xpp3Dom config = plugin == null ? null : (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom xpp3Dom = node = config == null ? null : config.getChild(name);
        if (node != null) {
            return node.getValue();
        }
        return defaultValue;
    }

    private boolean nodeBooleanValue(Plugin plugin, String name, boolean defaultValue) {
        String booleanValue = this.nodeValue(plugin, name, Boolean.toString(defaultValue));
        return "true".equals(booleanValue.toLowerCase());
    }

    private File resolveSlingstartArtifact(Environment env, MavenProject project, Dependency d) throws MavenExecutionException {
        DefaultArtifact prjArtifact = new DefaultArtifact(d.getGroupId(), d.getArtifactId(), VersionRange.createFromVersion((String)d.getVersion()), "provided", d.getType(), d.getClassifier(), env.artifactHandlerManager.getArtifactHandler(d.getType()));
        try {
            env.resolver.resolve((org.apache.maven.artifact.Artifact)prjArtifact, project.getRemoteArtifactRepositories(), env.session.getLocalRepository());
        }
        catch (ArtifactResolutionException e) {
            throw new MavenExecutionException("Unable to get artifact for " + d, (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new MavenExecutionException("Unable to get artifact for " + d, (Throwable)e);
        }
        return prjArtifact.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Model readLocalModel(MavenProject project, String inlinedModel, File modelDirectory, Logger logger) throws MavenExecutionException, IOException {
        ArrayList<String> candidates = new ArrayList<String>();
        if (modelDirectory != null && modelDirectory.exists()) {
            for (File f : modelDirectory.listFiles()) {
                if (!f.isFile() || f.getName().startsWith(".") || !f.getName().endsWith(".txt") && !f.getName().endsWith(".model")) continue;
                candidates.add(f.getName());
            }
            Collections.sort(candidates);
        }
        if (candidates.size() == 0 && (inlinedModel == null || inlinedModel.trim().length() == 0)) {
            throw new MavenExecutionException("No model files found in " + modelDirectory + ", and no model inlined in POM.", (File)null);
        }
        Model result = new Model();
        if (inlinedModel != null) {
            logger.debug("Reading inlined model from project " + project.getId());
            try {
                StringReader reader = new StringReader(inlinedModel);
                try {
                    Model current = ModelReader.read((Reader)reader, (String)"pom");
                    Map errors = ModelUtility.validate((Model)current);
                    if (errors != null) {
                        throw new MavenExecutionException("Invalid inlined model : " + errors, (File)null);
                    }
                    ModelUtility.merge((Model)result, (Model)current, (boolean)false);
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            catch (IOException io) {
                throw new MavenExecutionException("Unable to read inlined model", (Throwable)io);
            }
        }
        for (String name : candidates) {
            logger.debug("Reading model " + name + " in project " + project.getId());
            try {
                File f;
                f = new File(modelDirectory, name);
                FileReader reader = new FileReader(f);
                try {
                    Model current = ModelReader.read((Reader)reader, (String)f.getAbsolutePath());
                    Map errors = ModelUtility.validate((Model)current);
                    if (errors != null) {
                        throw new MavenExecutionException("Invalid model at " + name + " : " + errors, (File)null);
                    }
                    ModelUtility.merge((Model)result, (Model)current, (boolean)false);
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            catch (IOException io) {
                throw new MavenExecutionException("Unable to read model at " + name, (Throwable)io);
            }
        }
        Map errors = ModelUtility.validate((Model)result);
        if (errors != null) {
            throw new MavenExecutionException("Invalid assembled model : " + errors, (File)null);
        }
        return this.postProcessReadModel(result);
    }

    protected Model postProcessReadModel(Model result) throws MavenExecutionException {
        return result;
    }

    protected void mergeModels(Model base, Model additional) throws MavenExecutionException {
        ModelUtility.merge((Model)base, (Model)additional);
    }

    public static final class Environment {
        public ArtifactHandlerManager artifactHandlerManager;
        public ArtifactResolver resolver;
        public MavenSession session;
        public Logger logger;
        public final Map<String, ProjectInfo> modelProjects = new HashMap<String, ProjectInfo>();
    }

    public static final class ProjectInfo {
        public MavenProject project;
        public Plugin plugin;
        public Model localModel;
        public boolean done = false;
        public Model model;
        public final Map<Artifact, Model> includedModels = new HashMap<Artifact, Model>();
    }
}

