/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ModelUtility;

public class PomArtifactVersionResolver
implements ModelUtility.ArtifactVersionResolver {
    private final MavenProject project;
    private final boolean allowUnresolvedPomDependencies;

    public PomArtifactVersionResolver(MavenProject project, boolean allowUnresolvedPomDependencies) {
        this.project = project;
        this.allowUnresolvedPomDependencies = allowUnresolvedPomDependencies;
    }

    public String resolve(Artifact artifact) {
        String version = this.findVersion(this.project.getDependencies(), artifact);
        if (version != null) {
            return version;
        }
        if (this.project.getDependencyManagement() != null && (version = this.findVersion(this.project.getDependencyManagement().getDependencies(), artifact)) != null) {
            return version;
        }
        if (this.allowUnresolvedPomDependencies) {
            return null;
        }
        throw new IllegalArgumentException("Unable to resolve dependency: " + artifact.toMvnUrl());
    }

    private String findVersion(List<Dependency> dependencies, Artifact artifact) {
        if (dependencies != null) {
            for (Dependency dependency : dependencies) {
                if (!this.artifactEquals(dependency, artifact)) continue;
                return dependency.getVersion();
            }
        }
        return null;
    }

    private boolean artifactEquals(Dependency dependency, Artifact artifact) {
        return StringUtils.equals((String)dependency.getGroupId(), (String)artifact.getGroupId()) && StringUtils.equals((String)dependency.getArtifactId(), (String)artifact.getArtifactId()) && StringUtils.equals((String)dependency.getClassifier(), (String)artifact.getClassifier()) && StringUtils.equals((String)dependency.getType(), (String)artifact.getType());
    }
}

