/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.nio.file.Files;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.sling.commons.osgi.BSNRenamer;
import org.apache.sling.maven.slingstart.AbstractSlingStartMojo;
import org.apache.sling.maven.slingstart.ModelUtils;
import org.apache.sling.maven.slingstart.ProjectHelper;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ArtifactGroup;
import org.apache.sling.provisioning.model.Configuration;
import org.apache.sling.provisioning.model.Feature;
import org.apache.sling.provisioning.model.Model;
import org.apache.sling.provisioning.model.RunMode;
import org.apache.sling.provisioning.model.Section;
import org.apache.sling.provisioning.model.io.ModelWriter;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="prepare-package", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class PreparePackageMojo
extends AbstractSlingStartMojo {
    private static final String ALL_RUNMODES_KEY = "_all_";
    private static final String BASE_DESTINATION = "resources";
    private static final String BOOT_DIRECTORY = "bundles";
    private static final String ARTIFACTS_DIRECTORY = "install";
    private static final String CONFIG_DIRECTORY = "config";
    private static final String PROVISIONING_DIRECTORY = "provisioning";
    private static final String EMBEDDED_MODEL_FILENAME = "model.txt";
    private static final String BOOTSTRAP_FILE = "sling_bootstrap.txt";
    private static final String PROPERTIES_FILE = "sling_install.properties";
    @Component
    private ArchiverManager archiverManager;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    private ArtifactResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Model model = ProjectHelper.getEffectiveModel(this.project, this.getResolverOptions());
        this.execute(model);
    }

    void execute(Model model) throws MojoExecutionException {
        this.prepareGlobal(model);
        this.prepareStandaloneApp(model);
        this.prepareWebapp(model);
    }

    private void prepareGlobal(Model model) throws MojoExecutionException {
        HashMap<String, File> globalContentsMap = new HashMap<String, File>();
        this.buildContentsMap(model, null, globalContentsMap);
        this.project.setContextValue("slingstart:global", globalContentsMap);
    }

    private void prepareStandaloneApp(Model model) throws MojoExecutionException {
        HashMap<String, File> contentsMap = new HashMap<String, File>();
        this.project.setContextValue("slingstart:standalone", contentsMap);
        File outputDir = this.getStandaloneOutputDirectory();
        this.unpackBaseArtifact(model, outputDir, ":standalone");
        this.buildSettings(model, ":standalone", outputDir);
        this.buildBootstrapFile(model, ":standalone", outputDir);
        this.embedModel(model, outputDir);
        this.buildContentsMap(model, ":standalone", contentsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void embedModel(Model model, File outputDir) throws MojoExecutionException {
        File modelDir = new File(new File(outputDir, BASE_DESTINATION), PROVISIONING_DIRECTORY);
        modelDir.mkdirs();
        File modelFile = new File(modelDir, EMBEDDED_MODEL_FILENAME);
        try {
            FileWriter w = new FileWriter(modelFile);
            try {
                w.write("# Aggregated provisioning model embedded by " + ((Object)((Object)this)).getClass().getName() + "\n");
                ModelWriter.write((Writer)w, (Model)model);
            }
            finally {
                w.flush();
                w.close();
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to create model file " + modelFile.getAbsolutePath(), (Exception)ioe);
        }
    }

    private void prepareWebapp(Model model) throws MojoExecutionException {
        if (this.createWebapp) {
            Configuration webConfig;
            RunMode webappRM;
            HashMap<String, File> contentsMap = new HashMap<String, File>();
            this.project.setContextValue("slingstart:webapp", contentsMap);
            File outputDir = new File(this.project.getBuild().getDirectory(), "slingstart-webapp");
            File webappDir = new File(outputDir, "WEB-INF");
            this.unpackBaseArtifact(model, outputDir, ":webapp");
            Feature webappF = model.getFeature(":launchpad");
            if (webappF != null && (webappRM = webappF.getRunMode(null)) != null && (webConfig = webappRM.getConfiguration(":web.xml")) != null) {
                File webXML = new File(webappDir, "web.xml");
                try {
                    FileUtils.fileWrite((File)webXML, (String)webConfig.getProperties().get(":web.xml").toString());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to write configuration to " + webXML, (Exception)e);
                }
            }
            this.buildSettings(model, ":webapp", webappDir);
            this.buildBootstrapFile(model, ":webapp", webappDir);
            this.embedModel(model, webappDir);
            this.buildContentsMap(model, ":webapp", contentsMap);
        }
    }

    private void buildContentsMap(Model model, String packageRunMode, Map<String, File> contentsMap) throws MojoExecutionException {
        if (packageRunMode == null) {
            org.apache.maven.artifact.Artifact artifact = this.getBaseArtifact(model, null, "jar");
            contentsMap.put("resources/" + artifact.getArtifactId() + "." + artifact.getArtifactHandler().getExtension(), artifact.getFile());
        }
        for (Feature feature : model.getFeatures()) {
            if (feature.isSpecial() && !feature.getName().equals(":boot")) continue;
            if ("osgi.subsystem.application".equals(feature.getType()) || "osgi.subsystem.composite".equals(feature.getType()) || "osgi.subsystem.feature".equals(feature.getType())) {
                this.buildSubsystemBase(contentsMap, feature);
                continue;
            }
            for (RunMode runMode : feature.getRunModes()) {
                if (packageRunMode == null) {
                    if (runMode.isSpecial()) continue;
                    this.buildContentsMap(model, runMode, contentsMap, feature.getName().equals(":boot"));
                    continue;
                }
                if (!runMode.isRunMode(packageRunMode)) continue;
                this.buildContentsMap(model, runMode, contentsMap, feature.getName().equals(":boot"));
            }
        }
    }

    private void buildSubsystemBase(Map<String, File> contentsMap, Feature feature) throws MojoExecutionException {
        AtomicInteger startLevelHolder = new AtomicInteger();
        File subsystemFile = this.createSubsystemBaseFile(feature, startLevelHolder);
        if (subsystemFile != null) {
            contentsMap.put(this.getPathForArtifact(startLevelHolder.get(), subsystemFile.getName()), subsystemFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildContentsMap(Model model, RunMode runMode, Map<String, File> contentsMap, boolean isBoot) throws MojoExecutionException {
        for (ArtifactGroup group : runMode.getArtifactGroups()) {
            for (Artifact a : group) {
                org.apache.maven.artifact.Artifact artifact = null;
                if (a.getGroupId().equals(this.project.getGroupId()) && a.getArtifactId().equals(this.project.getArtifactId()) && a.getVersion().equals(this.project.getVersion())) {
                    for (org.apache.maven.artifact.Artifact projectArtifact : this.project.getAttachedArtifacts()) {
                        if (!projectArtifact.getClassifier().equals(a.getClassifier())) continue;
                        artifact = projectArtifact;
                        break;
                    }
                    if (artifact == null) {
                        throw new MojoExecutionException("Unable to find artifact from same project: " + a.toMvnUrl());
                    }
                } else {
                    artifact = ModelUtils.getArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.resolver, a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getType(), a.getClassifier());
                }
                File artifactFile = artifact.getFile();
                String newBSN = (String)a.getMetadata().get("bundle:rename-bsn");
                if (newBSN != null) {
                    try {
                        this.getTmpDir().mkdirs();
                        artifactFile = new BSNRenamer(artifactFile, this.getTmpDir(), newBSN).process();
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Unable to rename bundle BSN to " + newBSN + " for " + artifactFile, (Exception)e);
                    }
                }
                contentsMap.put(this.getPathForArtifact(group.getStartLevel(), artifactFile.getName(), runMode, isBoot), artifactFile);
            }
        }
        File rootConfDir = new File(this.getTmpDir(), "global-config");
        boolean hasConfig = false;
        for (Configuration config : runMode.getConfigurations()) {
            if (config.isSpecial()) continue;
            String configPath = this.getPathForConfiguration(config, runMode);
            File configFile = new File(rootConfDir, configPath);
            this.getLog().debug((CharSequence)String.format("Creating configuration at %s", configFile.getPath()));
            configFile.getParentFile().mkdirs();
            try (FileOutputStream os = new FileOutputStream(configFile);){
                ConfigurationHandler.write((OutputStream)os, (Dictionary)config.getProperties());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write configuration to " + configFile, (Exception)e);
            }
            hasConfig = true;
        }
        if (hasConfig) {
            contentsMap.put(BASE_DESTINATION, rootConfDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createSubsystemBaseFile(Feature feature, AtomicInteger startLevelHolder) throws MojoExecutionException {
        File subsystemFile = new File(this.getTmpDir(), feature.getName() + ".subsystem-base");
        if (subsystemFile.exists()) {
            return null;
        }
        startLevelHolder.set(-1);
        Manifest runModesManifest = this.getRunModesManifest(feature);
        this.getLog().info((CharSequence)("Creating subsystem base file: " + subsystemFile.getName()));
        subsystemFile.getParentFile().mkdirs();
        try (JarOutputStream os = new JarOutputStream((OutputStream)new FileOutputStream(subsystemFile), runModesManifest);){
            HashMap<String, Integer> bsnStartOrderMap = new HashMap<String, Integer>();
            for (RunMode rm : feature.getRunModes()) {
                for (ArtifactGroup ag : rm.getArtifactGroups()) {
                    int startOrder = ag.getStartLevel();
                    for (Artifact a : ag) {
                        org.apache.maven.artifact.Artifact artifact = ModelUtils.getArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.resolver, a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getType(), a.getClassifier());
                        File artifactFile = artifact.getFile();
                        String entryName = this.getEntryName(artifactFile, startOrder);
                        ZipEntry ze = new ZipEntry(entryName);
                        try {
                            os.putNextEntry(ze);
                            Files.copy(artifactFile.toPath(), os);
                        }
                        finally {
                            os.closeEntry();
                        }
                    }
                }
            }
            int sl = this.createSubsystemManifest(feature, bsnStartOrderMap, os);
            if (sl != -1) {
                startLevelHolder.set(sl);
            }
            this.addReadme(os);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Problem creating subsystem .esa file " + subsystemFile, (Exception)ioe);
        }
        return subsystemFile;
    }

    private Manifest getRunModesManifest(Feature feature) throws MojoExecutionException {
        HashMap<String, StringBuilder> runModes = new HashMap<String, StringBuilder>();
        for (RunMode rm : feature.getRunModes()) {
            for (ArtifactGroup artifactGroup : rm.getArtifactGroups()) {
                int startOrder = artifactGroup.getStartLevel();
                for (Artifact a : artifactGroup) {
                    org.apache.maven.artifact.Artifact artifact = ModelUtils.getArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.resolver, a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getType(), a.getClassifier());
                    File artifactFile = artifact.getFile();
                    String entryName = this.getEntryName(artifactFile, startOrder);
                    String[] runModeNames = rm.getNames();
                    if (runModeNames == null) {
                        runModeNames = new String[]{ALL_RUNMODES_KEY};
                    }
                    for (String runModeName : runModeNames) {
                        StringBuilder sb = (StringBuilder)runModes.get(runModeName);
                        if (sb == null) {
                            sb = new StringBuilder();
                            runModes.put(runModeName, sb);
                        } else {
                            sb.append('|');
                        }
                        sb.append(entryName);
                    }
                }
            }
        }
        Manifest mf = new Manifest();
        Attributes attrs = mf.getMainAttributes();
        attrs.putValue("Manifest-Version", "1.0");
        attrs.putValue("About-This-Manifest", "This is not a real manifest, it is used as information when this archive is transformed into a real subsystem .esa file");
        for (Map.Entry entry : runModes.entrySet()) {
            attrs.putValue(((String)entry.getKey()).replace(':', '_'), ((StringBuilder)entry.getValue()).toString());
        }
        return mf;
    }

    private String getEntryName(File artifactFile, int startOrder) {
        return "Potential_Bundles/" + startOrder + "/" + artifactFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createSubsystemManifest(Feature feature, Map<String, Integer> startOrderMap, ZipOutputStream os) throws IOException {
        int subsystemStartLevel = -1;
        ZipEntry ze = new ZipEntry("SUBSYSTEM-MANIFEST-BASE.MF");
        try {
            os.putNextEntry(ze);
            Manifest mf = new Manifest();
            Attributes attributes = mf.getMainAttributes();
            attributes.putValue("Manifest-Version", "1.0");
            attributes.putValue("Subsystem-SymbolicName", feature.getName());
            attributes.putValue("Subsystem-Version", "1");
            attributes.putValue("Subsystem-Type", feature.getType());
            for (Section section : feature.getAdditionalSections("subsystem-manifest")) {
                String sl = (String)section.getAttributes().get("startLevel");
                try {
                    subsystemStartLevel = Integer.parseInt(sl);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                BufferedReader br = new BufferedReader(new StringReader(section.getContents()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    int idx = line.indexOf(58);
                    if (idx <= 0) continue;
                    String key = line.substring(0, idx);
                    String value = line.length() > ++idx ? line.substring(idx) : "";
                    attributes.putValue(key.trim(), value.trim());
                }
            }
            mf.write(os);
        }
        finally {
            os.closeEntry();
        }
        return subsystemStartLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReadme(ZipOutputStream os) throws IOException {
        ZipEntry ze = new ZipEntry("readme.txt");
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/subsystem-base/readme.txt");){
            os.putNextEntry(ze);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            os.closeEntry();
        }
    }

    private void buildSettings(Model model, String packageRunMode, File outputDir) throws MojoExecutionException {
        RunMode bootRunMode;
        Feature bootFeature;
        RunMode launchpadRunMode;
        Properties settings = new Properties();
        Feature launchpadFeature = model.getFeature(":launchpad");
        if (launchpadFeature != null && (launchpadRunMode = launchpadFeature.getRunMode(null)) != null) {
            for (Map.Entry entry : launchpadRunMode.getSettings()) {
                settings.put(entry.getKey(), this.deescapeVariablePlaceholders((String)entry.getValue()));
            }
        }
        if ((bootFeature = model.getFeature(":boot")) != null && (bootRunMode = bootFeature.getRunMode(null)) != null) {
            for (Map.Entry entry : bootRunMode.getSettings()) {
                settings.put(entry.getKey(), this.deescapeVariablePlaceholders((String)entry.getValue()));
            }
        }
        for (Feature f : model.getFeatures()) {
            RunMode packageRM = f.getRunMode(new String[]{packageRunMode});
            if (packageRM == null) continue;
            for (Map.Entry entry : packageRM.getSettings()) {
                settings.put(entry.getKey(), this.deescapeVariablePlaceholders((String)entry.getValue()));
            }
        }
        if (settings.size() > 0) {
            File settingsFile = new File(outputDir, PROPERTIES_FILE);
            this.getLog().debug((CharSequence)String.format("Creating settings at %s", settingsFile.getPath()));
            FileWriter writer = null;
            try {
                writer = new FileWriter(settingsFile);
                settings.store(writer, null);
            }
            catch (IOException ioe) {
                try {
                    throw new MojoExecutionException("Unable to write properties file.", (Exception)ioe);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    private void buildBootstrapFile(Model model, String packageRunMode, File outputDir) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        Feature launchpadFeature = model.getFeature(":launchpad");
        if (launchpadFeature != null) {
            Configuration c;
            RunMode packageRM;
            Configuration c2;
            RunMode launchpadRunMode = launchpadFeature.getRunMode(null);
            if (launchpadRunMode != null && (c2 = launchpadRunMode.getConfiguration(":bootstrap")) != null) {
                sb.append(c2.getProperties().get(c2.getPid()));
                sb.append('\n');
            }
            if ((packageRM = launchpadFeature.getRunMode(new String[]{packageRunMode})) != null && (c = packageRM.getConfiguration(":bootstrap")) != null) {
                sb.append(c.getProperties().get(c.getPid()));
                sb.append('\n');
            }
        }
        if (sb.length() > 0) {
            File file = new File(outputDir, BOOTSTRAP_FILE);
            this.getLog().debug((CharSequence)String.format("Creating bootstrap file at %s", file.getPath()));
            try {
                FileUtils.fileWrite((File)file, (String)sb.toString());
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Unable to write bootstrap file.", (Exception)ioe);
            }
        }
    }

    private org.apache.maven.artifact.Artifact getBaseArtifact(Model model, String classifier, String type) throws MojoExecutionException {
        try {
            Artifact baseArtifact = ModelUtils.findBaseArtifact(model);
            org.apache.maven.artifact.Artifact a = ModelUtils.getArtifact(this.project, this.mavenSession, this.artifactHandlerManager, this.resolver, baseArtifact.getGroupId(), baseArtifact.getArtifactId(), baseArtifact.getVersion(), type, classifier);
            if (a == null) {
                throw new MojoExecutionException(String.format("Project doesn't have a base dependency of groupId %s and artifactId %s", baseArtifact.getGroupId(), baseArtifact.getArtifactId()));
            }
            return a;
        }
        catch (MavenExecutionException mee) {
            throw new MojoExecutionException(mee.getMessage(), mee.getCause());
        }
    }

    private void unpackBaseArtifact(Model model, File outputDirectory, String packageRunMode) throws MojoExecutionException {
        String type;
        String classifier;
        if (":standalone".equals(packageRunMode)) {
            classifier = "app";
            type = "jar";
        } else {
            classifier = "webapp";
            type = "war";
        }
        org.apache.maven.artifact.Artifact artifact = this.getBaseArtifact(model, classifier, type);
        this.unpack(artifact.getFile(), outputDirectory);
    }

    private void unpack(File source, File destination) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Unpacking " + source.getPath() + " to\n  " + destination.getPath()));
        try {
            destination.mkdirs();
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(source);
            unArchiver.setSourceFile(source);
            unArchiver.setDestDirectory(destination);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unable to find archiver for " + source.getPath(), (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Unable to unpack " + source.getPath(), (Exception)((Object)e));
        }
    }

    private String getPathForArtifact(int startLevel, String artifactName) {
        return this.getPathForArtifact(startLevel, artifactName, null, false);
    }

    private String getPathForArtifact(int startLevel, String artifactName, RunMode rm, boolean isBoot) {
        String runModeExt;
        TreeSet<String> runModesList = new TreeSet<String>();
        if (rm != null && rm.getNames() != null) {
            for (String mode : rm.getNames()) {
                runModesList.add(mode);
            }
        }
        if (runModesList.size() == 0 || rm.isSpecial()) {
            runModeExt = "";
        } else {
            StringBuilder sb = new StringBuilder();
            for (String n : runModesList) {
                sb.append('.');
                sb.append(n);
            }
            runModeExt = sb.toString();
        }
        if (isBoot) {
            return String.format("%s/%s/1/%s", BASE_DESTINATION, BOOT_DIRECTORY, artifactName);
        }
        return String.format("%s/%s%s/%s/%s", BASE_DESTINATION, ARTIFACTS_DIRECTORY, runModeExt, startLevel == -1 ? 1 : startLevel, artifactName);
    }

    private String getPathForConfiguration(Configuration config, RunMode rm) {
        String runModeExt;
        TreeSet<String> runModesList = new TreeSet<String>();
        if (rm.getNames() != null) {
            for (String mode : rm.getNames()) {
                runModesList.add(mode);
            }
        }
        if (runModesList.size() == 0 || rm.isSpecial()) {
            runModeExt = "";
        } else {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String n : runModesList) {
                if (first) {
                    sb.append('/');
                    first = false;
                } else {
                    sb.append('.');
                }
                sb.append(n);
            }
            runModeExt = sb.toString();
        }
        String mainName = config.getFactoryPid() != null ? config.getFactoryPid() : config.getPid();
        String alias = config.getFactoryPid() != null ? "-" + config.getPid() : "";
        return String.format("%s/%s%s/%s%s.config", BASE_DESTINATION, CONFIG_DIRECTORY, runModeExt, mainName, alias);
    }

    private String deescapeVariablePlaceholders(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("\\\\\\$", "\\$");
    }
}

