/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.sling.provisioning.model.Artifact;
import org.apache.sling.provisioning.model.ModelUtility;

public class PomArtifactVersionResolver
implements ModelUtility.ArtifactVersionResolver {
    private final MavenProject project;
    private final boolean allowUnresolvedPomDependencies;

    public PomArtifactVersionResolver(MavenProject project, boolean allowUnresolvedPomDependencies) {
        this.project = project;
        this.allowUnresolvedPomDependencies = allowUnresolvedPomDependencies;
    }

    public String resolve(Artifact artifact) {
        if (PomArtifactVersionResolver.artifactEquals(this.project.getArtifact(), artifact)) {
            return this.project.getVersion();
        }
        String version = this.findVersion(this.project.getDependencies(), artifact);
        if (version != null) {
            return version;
        }
        if (this.project.getDependencyManagement() != null && (version = this.findVersion(this.project.getDependencyManagement().getDependencies(), artifact)) != null) {
            return version;
        }
        if (this.allowUnresolvedPomDependencies) {
            return null;
        }
        throw new IllegalArgumentException("Unable to resolve dependency: " + artifact.toMvnUrl());
    }

    private String findVersion(List<Dependency> dependencies, Artifact artifact) {
        if (dependencies != null) {
            for (Dependency dependency : dependencies) {
                if (!PomArtifactVersionResolver.artifactEquals(dependency, artifact)) continue;
                return dependency.getVersion();
            }
        }
        return null;
    }

    static boolean artifactEquals(Dependency dependency, Artifact artifact) {
        return StringUtils.equals((String)dependency.getGroupId(), (String)artifact.getGroupId()) && StringUtils.equals((String)dependency.getArtifactId(), (String)artifact.getArtifactId()) && StringUtils.equals((String)dependency.getClassifier(), (String)artifact.getClassifier()) && StringUtils.equals((String)PomArtifactVersionResolver.normalizeType(dependency.getType()), (String)PomArtifactVersionResolver.normalizeType(artifact.getType()));
    }

    static boolean artifactEquals(org.apache.maven.artifact.Artifact artifact, Artifact artifact2) {
        return StringUtils.equals((String)artifact.getGroupId(), (String)artifact2.getGroupId()) && StringUtils.equals((String)artifact.getArtifactId(), (String)artifact2.getArtifactId()) && StringUtils.equals((String)artifact.getClassifier(), (String)artifact2.getClassifier()) && StringUtils.equals((String)PomArtifactVersionResolver.normalizeType(artifact.getType()), (String)PomArtifactVersionResolver.normalizeType(artifact2.getType()));
    }

    static String normalizeType(String type) {
        if (type.equals("bundle")) {
            return "jar";
        }
        return type;
    }
}

