/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart.run;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class ControlListener
implements Runnable {
    private static final String COMMAND_STARTED = "started";
    private static final String RESPONSE_OK = "ok";
    private static final String DEFAULT_LISTEN_INTERFACE = "127.0.0.1";
    private final int port;
    private volatile boolean started = false;
    private volatile boolean stopped = false;
    private volatile ServerSocket server;

    public ControlListener(int p) {
        this.port = p;
        Thread listener = new Thread(this);
        listener.setDaemon(true);
        listener.setName("Launchapd startup listener");
        listener.start();
    }

    public int getPort() {
        return this.port;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() {
        this.stopped = true;
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        InetSocketAddress socketAddress = ControlListener.getSocketAddress(this.port);
        try {
            this.server = new ServerSocket();
            this.server.bind(socketAddress);
        }
        catch (IOException ioe) {
            return;
        }
        try {
            while (!this.stopped) {
                Socket s = this.server.accept();
                try {
                    String commandLine = this.readLine(s);
                    if (commandLine == null) {
                        String msg = "ERR: missing command";
                        this.writeLine(s, "ERR: missing command");
                        continue;
                    }
                    String command = commandLine;
                    if (COMMAND_STARTED.equals(command)) {
                        this.writeLine(s, RESPONSE_OK);
                        this.started = true;
                        this.stopped = true;
                        return;
                    }
                    String msg = "ERR:" + command;
                    this.writeLine(s, msg);
                }
                finally {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            try {
                this.server.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String readLine(Socket socket) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        return br.readLine();
    }

    private void writeLine(Socket socket, String line) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
        bw.write(line);
        bw.write("\r\n");
        bw.flush();
    }

    private static InetSocketAddress getSocketAddress(int port) {
        String address = DEFAULT_LISTEN_INTERFACE;
        InetSocketAddress addr = new InetSocketAddress(DEFAULT_LISTEN_INTERFACE, port);
        if (!addr.isUnresolved()) {
            return addr;
        }
        return null;
    }
}

