/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.slingstart.FeatureModelConverter;
import org.apache.sling.maven.slingstart.ModelPreprocessor;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class)
public class DependencyLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String GROUP_ID = "org.apache.sling";
    private static final String ARTIFACT_ID = "slingstart-maven-plugin";
    private static final String PLUGIN_ID = "org.apache.sling:slingstart-maven-plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement
    private ArtifactResolver resolver;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        String version;
        ModelPreprocessor.Environment env = new ModelPreprocessor.Environment();
        env.artifactHandlerManager = this.artifactHandlerManager;
        env.resolver = this.resolver;
        env.logger = this.logger;
        env.session = session;
        try {
            version = DependencyLifecycleParticipant.getCurrentPluginVersion();
        }
        catch (IOException e) {
            throw new MavenExecutionException("Could not retrieve extension's version", (Throwable)e);
        }
        this.logger.debug("Searching for projects leveraging plugin 'org.apache.sling:slingstart-maven-plugin' in version " + version + "...");
        for (MavenProject project : session.getProjects()) {
            Plugin plugin = project.getPlugin(PLUGIN_ID);
            if (plugin == null) continue;
            if (version.equals(plugin.getVersion())) {
                this.logger.debug("Found project " + project + " leveraging " + PLUGIN_ID + " in version " + version + ".");
                ModelPreprocessor.ProjectInfo info = new ModelPreprocessor.ProjectInfo();
                info.plugin = plugin;
                info.project = project;
                env.modelProjects.put(project.getGroupId() + ":" + project.getArtifactId(), info);
                File processed = new File(project.getBuild().getDirectory(), "features/processed");
                try {
                    FileUtils.forceDelete((File)processed);
                    continue;
                }
                catch (IOException e) {
                    throw new MavenExecutionException("Failed to delete: " + processed.getPath(), (Throwable)e);
                }
            }
            this.logger.debug("Skipping project " + project + " leveraging " + PLUGIN_ID + " in another version " + project.getVersion() + ".");
        }
        FeatureModelConverter.convert(session, env);
        new ModelPreprocessor().addDependencies(env);
    }

    static final String getCurrentPluginVersion() throws IOException {
        String pomPropertiesFile = String.format("/META-INF/maven/%s/%s/pom.properties", GROUP_ID, ARTIFACT_ID);
        try (InputStream inputStream = DependencyLifecycleParticipant.class.getResourceAsStream(pomPropertiesFile);){
            if (inputStream == null) {
                throw new IllegalStateException("Could not find '" + pomPropertiesFile + "' via classloader '" + DependencyLifecycleParticipant.class.getClassLoader() + "'");
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            String string = properties.getProperty("version");
            return string;
        }
    }
}

