/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.beans;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.beans.Field;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentObjectBinder {
    private final Map<Class, List<DocField>> infocache = new ConcurrentHashMap<Class, List<DocField>>();

    public <T> List<T> getBeans(Class<T> clazz, SolrDocumentList solrDocList) {
        List<DocField> fields = this.getDocFields(clazz);
        ArrayList<T> result = new ArrayList<T>(solrDocList.size());
        for (int j = 0; j < solrDocList.size(); ++j) {
            SolrDocument sdoc = (SolrDocument)solrDocList.get(j);
            result.add(this.getBean(clazz, fields, sdoc));
        }
        return result;
    }

    public <T> T getBean(Class<T> clazz, SolrDocument solrDoc) {
        return this.getBean(clazz, null, solrDoc);
    }

    private <T> T getBean(Class<T> clazz, List<DocField> fields, SolrDocument solrDoc) {
        if (fields == null) {
            fields = this.getDocFields(clazz);
        }
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate object of " + clazz, e);
        }
        for (int i = 0; i < fields.size(); ++i) {
            DocField docField = fields.get(i);
            docField.inject(obj, solrDoc);
        }
        return obj;
    }

    public SolrInputDocument toSolrInputDocument(Object obj) {
        List<DocField> fields = this.getDocFields(obj.getClass());
        if (fields.isEmpty()) {
            throw new RuntimeException("class: " + obj.getClass() + " does not define any fields.");
        }
        SolrInputDocument doc = new SolrInputDocument();
        for (DocField field : fields) {
            if (field.dynamicFieldNamePatternMatcher != null && field.get(obj) != null && field.isContainedInMap) {
                HashMap mapValue = (HashMap)field.get(obj);
                for (Map.Entry e : mapValue.entrySet()) {
                    doc.setField((String)e.getKey(), e.getValue(), 1.0f);
                }
                continue;
            }
            doc.setField(field.name, field.get(obj), 1.0f);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DocField> getDocFields(Class clazz) {
        List<DocField> fields = this.infocache.get(clazz);
        if (fields == null) {
            Map<Class, List<DocField>> map = this.infocache;
            synchronized (map) {
                fields = this.collectInfo(clazz);
                this.infocache.put(clazz, fields);
            }
        }
        return fields;
    }

    private List<DocField> collectInfo(Class clazz) {
        ArrayList<DocField> fields = new ArrayList<DocField>();
        ArrayList<AccessibleObject> members = new ArrayList<AccessibleObject>();
        for (Class superClazz = clazz; superClazz != null && superClazz != Object.class; superClazz = superClazz.getSuperclass()) {
            members.addAll(Arrays.asList(superClazz.getDeclaredFields()));
            members.addAll(Arrays.asList(superClazz.getDeclaredMethods()));
        }
        for (AccessibleObject member : members) {
            if (!member.isAnnotationPresent(Field.class)) continue;
            member.setAccessible(true);
            fields.add(new DocField(member));
        }
        return fields;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocField {
        private String name;
        private java.lang.reflect.Field field;
        private Method setter;
        private Method getter;
        private Class type;
        private boolean isArray;
        private boolean isList;
        boolean isContainedInMap;
        private Pattern dynamicFieldNamePatternMatcher;

        public DocField(AccessibleObject member) {
            block7: {
                String gname;
                this.isArray = false;
                this.isList = false;
                this.isContainedInMap = false;
                if (member instanceof java.lang.reflect.Field) {
                    this.field = (java.lang.reflect.Field)member;
                } else {
                    this.setter = (Method)member;
                }
                Field annotation = member.getAnnotation(Field.class);
                this.storeName(annotation);
                this.storeType();
                if (this.setter != null && (gname = this.setter.getName()).startsWith("set")) {
                    gname = "get" + gname.substring(3);
                    try {
                        this.getter = this.setter.getDeclaringClass().getMethod(gname, null);
                    }
                    catch (Exception ex) {
                        if (this.type != Boolean.class) break block7;
                        gname = "is" + this.setter.getName().substring(3);
                        try {
                            this.getter = this.setter.getDeclaringClass().getMethod(gname, null);
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        private void storeName(Field annotation) {
            if (annotation.value().equals("#default")) {
                String setterName;
                this.name = this.field != null ? this.field.getName() : ((setterName = this.setter.getName()).startsWith("set") && setterName.length() > 3 ? setterName.substring(3, 4).toLowerCase() + setterName.substring(4) : this.setter.getName());
            } else if (annotation.value().indexOf(42) >= 0) {
                this.name = annotation.value().replaceFirst("\\*", "\\.*");
                this.dynamicFieldNamePatternMatcher = Pattern.compile("^" + this.name + "$");
            } else {
                this.name = annotation.value();
            }
        }

        private void storeType() {
            if (this.field != null) {
                this.type = this.field.getType();
            } else {
                Class<?>[] params = this.setter.getParameterTypes();
                if (params.length != 1) {
                    throw new RuntimeException("Invalid setter method. Must have one and only one parameter");
                }
                this.type = params[0];
            }
            if (this.type == Collection.class || this.type == List.class || this.type == ArrayList.class) {
                this.type = Object.class;
                this.isList = true;
            } else if (this.type != byte[].class) {
                if (this.type.isArray()) {
                    this.isArray = true;
                    this.type = this.type.getComponentType();
                } else if (this.type == Map.class || this.type == HashMap.class) {
                    ParameterizedType parameterizedType;
                    Type[] types;
                    this.isContainedInMap = true;
                    this.type = Object.class;
                    if (this.field != null && this.field.getGenericType() instanceof ParameterizedType && (types = (parameterizedType = (ParameterizedType)this.field.getGenericType()).getActualTypeArguments()) != null && types.length == 2 && types[0] == String.class) {
                        if (types[1] instanceof Class) {
                            if (types[1] == Collection.class || types[1] == List.class || types[1] == ArrayList.class) {
                                this.type = Object.class;
                                this.isList = true;
                            } else {
                                this.type = (Class)types[1];
                            }
                        } else if (types[1] instanceof ParameterizedType) {
                            Type rawType = ((ParameterizedType)types[1]).getRawType();
                            if (rawType == Collection.class || rawType == List.class || rawType == ArrayList.class) {
                                this.type = Object.class;
                                this.isList = true;
                            }
                        } else if (types[1] instanceof GenericArrayType) {
                            this.type = (Class)((GenericArrayType)types[1]).getGenericComponentType();
                            this.isArray = true;
                        } else {
                            throw new RuntimeException("Allowed type for values of mapping a dynamicField are : Object, Object[] and List");
                        }
                    }
                }
            }
        }

        private Object getFieldValue(SolrDocument sdoc) {
            Object fieldValue = sdoc.getFieldValue(this.name);
            if (fieldValue != null) {
                return fieldValue;
            }
            if (this.dynamicFieldNamePatternMatcher != null) {
                HashMap allValuesMap = null;
                ArrayList allValuesList = null;
                if (this.isContainedInMap) {
                    allValuesMap = new HashMap();
                } else {
                    allValuesList = new ArrayList();
                }
                for (String field : sdoc.getFieldNames()) {
                    Object[] val;
                    if (!this.dynamicFieldNamePatternMatcher.matcher(field).find() || (val = sdoc.getFieldValue(field)) == null) continue;
                    if (this.isContainedInMap) {
                        if (this.isList) {
                            if (!(val instanceof List)) {
                                ArrayList al = new ArrayList();
                                al.add(val);
                                val = al;
                            }
                        } else if (this.isArray) {
                            if (!(val instanceof List)) {
                                Object[] arr = (Object[])Array.newInstance(this.type, 1);
                                arr[0] = val;
                                val = arr;
                            } else {
                                val = Array.newInstance(this.type, ((List)val).size());
                            }
                        }
                        allValuesMap.put(field, val);
                        continue;
                    }
                    if (val instanceof Collection) {
                        allValuesList.addAll((Collection)val);
                        continue;
                    }
                    allValuesList.add(val);
                }
                if (this.isContainedInMap) {
                    return allValuesMap.isEmpty() ? null : allValuesMap;
                }
                return allValuesList.isEmpty() ? null : allValuesList;
            }
            return null;
        }

        <T> void inject(T obj, SolrDocument sdoc) {
            ArrayList val = this.getFieldValue(sdoc);
            if (val == null) {
                return;
            }
            if (this.isArray && !this.isContainedInMap) {
                ArrayList list = null;
                if (val.getClass().isArray()) {
                    this.set(obj, val);
                    return;
                }
                if (val instanceof List) {
                    list = val;
                } else {
                    list = new ArrayList();
                    list.add(val);
                }
                this.set(obj, list.toArray((Object[])Array.newInstance(this.type, list.size())));
            } else if (this.isList && !this.isContainedInMap) {
                if (!(val instanceof List)) {
                    ArrayList list = new ArrayList();
                    list.add(val);
                    val = list;
                }
                this.set(obj, val);
            } else if (this.isContainedInMap) {
                if (val instanceof Map) {
                    this.set(obj, val);
                }
            } else {
                this.set(obj, val);
            }
        }

        private void set(Object obj, Object v) {
            if (v != null && this.type == ByteBuffer.class && v.getClass() == byte[].class) {
                v = ByteBuffer.wrap((byte[])v);
            }
            try {
                if (this.field != null) {
                    this.field.set(obj, v);
                } else if (this.setter != null) {
                    this.setter.invoke(obj, v);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while setting value : " + v + " on " + (this.field != null ? this.field : this.setter), e);
            }
        }

        public Object get(Object obj) {
            if (this.field != null) {
                try {
                    return this.field.get(obj);
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception while getting value: " + this.field, e);
                }
            }
            if (this.getter == null) {
                throw new RuntimeException("Missing getter for field: " + this.name + " -- You can only call the 'get' for fields that have a field of 'get' method");
            }
            try {
                return this.getter.invoke(obj, (Object[])null);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while getting value: " + this.getter, e);
            }
        }
    }
}

