/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.ComparatorOrder;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicStream
extends CloudSolrStream
implements Expressible {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 1L;
    private long count;
    private int runCount;
    private String id;
    protected long checkpointEvery;
    private Map<String, Long> checkpoints = new HashMap<String, Long>();
    private String checkpointCollection;
    private long initialCheckpoint = -1L;

    @Deprecated
    public TopicStream(String zkHost, String checkpointCollection, String collection, String id, long initialCheckpoint, long checkpointEvery, Map<String, String> params) {
        this.init(zkHost, checkpointCollection, collection, id, initialCheckpoint, checkpointEvery, new MapSolrParams(params));
    }

    public TopicStream(String zkHost, String checkpointCollection, String collection, String id, long initialCheckpoint, long checkpointEvery, SolrParams params) {
        this.init(zkHost, checkpointCollection, collection, id, initialCheckpoint, checkpointEvery, params);
    }

    private void init(String zkHost, String checkpointCollection, String collection, String id, long initialCheckpoint, long checkpointEvery, SolrParams params) {
        this.zkHost = zkHost;
        ModifiableSolrParams mParams = new ModifiableSolrParams(params);
        if (mParams.getParams("rows") == null) {
            mParams.set("rows", "500");
        }
        this.params = mParams;
        this.collection = collection;
        this.checkpointCollection = checkpointCollection;
        this.checkpointEvery = checkpointEvery;
        this.id = id;
        this.initialCheckpoint = initialCheckpoint;
        this.comp = new FieldComparator("_version_", ComparatorOrder.ASCENDING);
    }

    public TopicStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String checkpointCollectionName = factory.getValueOperand(expression, 0);
        String collectionName = factory.getValueOperand(expression, 1);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        StreamExpressionNamedParameter idParam = factory.getNamedOperand(expression, "id");
        if (null == idParam) {
            throw new IOException("invalid TopicStream id cannot be null");
        }
        StreamExpressionNamedParameter flParam = factory.getNamedOperand(expression, "fl");
        if (null == flParam) {
            throw new IOException("invalid TopicStream fl cannot be null");
        }
        long initialCheckpoint = -1L;
        StreamExpressionNamedParameter initialCheckpointParam = factory.getNamedOperand(expression, "initialCheckpoint");
        if (initialCheckpointParam != null) {
            initialCheckpoint = Long.parseLong(((StreamExpressionValue)initialCheckpointParam.getParameter()).getValue());
        }
        long checkpointEvery = -1L;
        StreamExpressionNamedParameter checkpointEveryParam = factory.getNamedOperand(expression, "checkpointEvery");
        if (checkpointEveryParam != null) {
            checkpointEvery = Long.parseLong(((StreamExpressionValue)checkpointEveryParam.getParameter()).getValue());
        }
        if (null == checkpointCollectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - checkpointCollectionName expected as first operand", expression));
        }
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as second operand", expression));
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("id") || namedParam.getName().equals("checkpointEvery")) continue;
            params.set(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (null == zkHost) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - zkHost not found for collection '%s'", expression, collectionName));
        }
        this.init(zkHost, checkpointCollectionName, collectionName, ((StreamExpressionValue)idParam.getParameter()).getValue(), initialCheckpoint, checkpointEvery, params);
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.checkpointCollection);
        expression.addParameter(this.collection);
        ModifiableSolrParams mParams = new ModifiableSolrParams(this.params);
        for (Map.Entry<String, String[]> param : mParams.getMap().entrySet()) {
            String value = String.join((CharSequence)",", param.getValue());
            value = value.replace("\"", "\\\"");
            expression.addParameter(new StreamExpressionNamedParameter(param.getKey(), value));
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        expression.addParameter(new StreamExpressionNamedParameter("id", this.id));
        if (this.initialCheckpoint > -1L) {
            expression.addParameter(new StreamExpressionNamedParameter("initialCheckpoint", Long.toString(this.initialCheckpoint)));
        }
        expression.addParameter(new StreamExpressionNamedParameter("checkpointEvery", Long.toString(this.checkpointEvery)));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        ModifiableSolrParams mParams = new ModifiableSolrParams(this.params);
        child.setExpression(mParams.getMap().entrySet().stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining(",")));
        explanation.addChild(child);
        child = new StreamExplanation(this.getStreamNodeId() + "-checkpoint");
        child.setFunctionName(String.format(Locale.ROOT, "solr (checkpoint store)", new Object[0]));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        child.setExpression(String.format(Locale.ROOT, "id=%s, collection=%s, checkpointEvery=%d", this.id, this.checkpointCollection, this.checkpointEvery));
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    @Override
    public void open() throws IOException {
        this.tuples = new TreeSet();
        this.solrStreams = new ArrayList();
        this.eofTuples = Collections.synchronizedMap(new HashMap());
        if (this.checkpoints.size() == 0 && this.streamContext.numWorkers > 1) {
            this.id = this.id + "_" + this.streamContext.workerID;
        }
        if (this.streamContext.getSolrClientCache() != null) {
            this.cloudSolrClient = this.streamContext.getSolrClientCache().getCloudSolrClient(this.zkHost);
        } else {
            this.cloudSolrClient = new CloudSolrClient.Builder().withZkHost(this.zkHost).build();
            this.cloudSolrClient.connect();
        }
        if (this.checkpoints.size() == 0) {
            this.getPersistedCheckpoints();
            if (this.checkpoints.size() == 0) {
                this.getCheckpoints();
            }
        }
        this.constructStreams();
        this.openStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openStreams() throws IOException {
        ExecutorService service = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrjNamedThreadFactory("TopicStream"));
        try {
            ArrayList<Future<CloudSolrStream.TupleWrapper>> futures = new ArrayList<Future<CloudSolrStream.TupleWrapper>>();
            for (TupleStream tupleStream : this.solrStreams) {
                CloudSolrStream.StreamOpener so = new CloudSolrStream.StreamOpener((SolrStream)tupleStream, this.comp);
                Future<CloudSolrStream.TupleWrapper> future = service.submit(so);
                futures.add(future);
            }
            try {
                for (Future future : futures) {
                    CloudSolrStream.TupleWrapper w = (CloudSolrStream.TupleWrapper)future.get();
                    if (w == null) continue;
                    this.tuples.add(w);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        finally {
            service.shutdown();
        }
    }

    @Override
    public void close() throws IOException {
        this.runCount = 0;
        try {
            this.persistCheckpoints();
        }
        finally {
            if (this.solrStreams != null) {
                for (TupleStream solrStream : this.solrStreams) {
                    solrStream.close();
                }
            }
            if (this.streamContext.getSolrClientCache() == null) {
                this.cloudSolrClient.close();
            }
        }
    }

    @Override
    public Tuple read() throws IOException {
        Tuple tuple = this._read();
        if (tuple.EOF) {
            if (this.runCount > 0) {
                tuple.put("sleepMillis", 0);
            } else {
                tuple.put("sleepMillis", 1000);
            }
            return tuple;
        }
        ++this.count;
        ++this.runCount;
        if (this.checkpointEvery > -1L && this.count % this.checkpointEvery == 0L) {
            this.persistCheckpoints();
        }
        long version = tuple.getLong("_version_");
        String slice = tuple.getString("_SLICE_");
        this.checkpoints.put(slice, version);
        tuple.remove("_SLICE_");
        tuple.remove("_CORE_");
        return tuple;
    }

    @Override
    public int getCost() {
        return 0;
    }

    private void getCheckpoints() throws IOException {
        this.checkpoints = new HashMap<String, Long>();
        ZkStateReader zkStateReader = this.cloudSolrClient.getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        Collection<Slice> slices = clusterState.getActiveSlices(this.collection);
        for (Slice slice : slices) {
            String sliceName = slice.getName();
            long checkpoint = 0L;
            checkpoint = this.initialCheckpoint > -1L ? this.initialCheckpoint : this.getCheckpoint(slice, clusterState.getLiveNodes());
            this.checkpoints.put(sliceName, checkpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCheckpoint(Slice slice, Set<String> liveNodes) throws IOException {
        Collection<Replica> replicas = slice.getReplicas();
        long checkpoint = -1L;
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("q", "*:*");
        params.set("sort", "_version_ desc");
        params.set("distrib", "false");
        params.set("rows", 1);
        for (Replica replica : replicas) {
            if (replica.getState() != Replica.State.ACTIVE || !liveNodes.contains(replica.getNodeName())) continue;
            String coreUrl = replica.getCoreUrl();
            SolrStream solrStream = new SolrStream(coreUrl, params);
            if (this.streamContext != null) {
                StreamContext localContext = new StreamContext();
                localContext.setSolrClientCache(this.streamContext.getSolrClientCache());
                solrStream.setStreamContext(localContext);
            }
            try {
                solrStream.open();
                Tuple tuple = solrStream.read();
                if (tuple.EOF) {
                    long l = 0L;
                    return l;
                }
                checkpoint = tuple.getLong("_version_");
                break;
            }
            finally {
                solrStream.close();
            }
        }
        return checkpoint;
    }

    private void persistCheckpoints() throws IOException {
        UpdateRequest request = new UpdateRequest();
        request.setParam("collection", this.checkpointCollection);
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.addField("id", this.id);
        for (Map.Entry<String, Long> entry : this.checkpoints.entrySet()) {
            doc.addField("checkpoint_ss", entry.getKey() + "~" + entry.getValue());
        }
        request.add(doc);
        try {
            this.cloudSolrClient.request(request);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void getPersistedCheckpoints() throws IOException {
        ZkStateReader zkStateReader = this.cloudSolrClient.getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        Collection<Slice> slices = clusterState.getActiveSlices(this.checkpointCollection);
        Set<String> liveNodes = clusterState.getLiveNodes();
        block2: for (Slice slice : slices) {
            Collection<Replica> replicas = slice.getReplicas();
            for (Replica replica : replicas) {
                if (replica.getState() != Replica.State.ACTIVE || !liveNodes.contains(replica.getNodeName())) continue;
                HttpSolrClient httpClient = this.streamContext.getSolrClientCache().getHttpSolrClient(replica.getCoreUrl());
                try {
                    SolrDocument doc = httpClient.getById(this.id);
                    if (doc == null) break block2;
                    List checkpoints = (List)doc.getFieldValue("checkpoint_ss");
                    for (String checkpoint : checkpoints) {
                        String[] pair = checkpoint.split("~");
                        this.checkpoints.put(pair[0], Long.parseLong(pair[1]));
                    }
                    break block2;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
    }

    @Override
    protected void constructStreams() throws IOException {
        try {
            ZkStateReader zkStateReader = this.cloudSolrClient.getZkStateReader();
            ClusterState clusterState = zkStateReader.getClusterState();
            Set<String> liveNodes = clusterState.getLiveNodes();
            Collection<Slice> slices = clusterState.getActiveSlices(this.collection);
            if (slices == null) {
                slices = TopicStream.getSlicesIgnoreCase(this.collection, clusterState);
            }
            if (slices == null) {
                throw new Exception("Collection not found:" + this.collection);
            }
            Iterator<String> iterator = this.params.getParameterNamesIterator();
            ModifiableSolrParams mParams = new ModifiableSolrParams(this.params);
            mParams.set("distrib", "false");
            String fl = mParams.get("fl");
            mParams.set("sort", "_version_ asc");
            if (!fl.contains("_version_")) {
                fl = fl + ",_version_";
            }
            mParams.set("fl", fl);
            Random random = new Random();
            for (Slice slice : slices) {
                ModifiableSolrParams localParams = new ModifiableSolrParams(mParams);
                long checkpoint = this.checkpoints.get(slice.getName());
                Collection<Replica> replicas = slice.getReplicas();
                ArrayList<Replica> shuffler = new ArrayList<Replica>();
                for (Replica replica : replicas) {
                    if (replica.getState() != Replica.State.ACTIVE || !liveNodes.contains(replica.getNodeName())) continue;
                    shuffler.add(replica);
                }
                Replica rep = (Replica)shuffler.get(random.nextInt(shuffler.size()));
                ZkCoreNodeProps zkProps = new ZkCoreNodeProps(rep);
                String url = zkProps.getCoreUrl();
                SolrStream solrStream = new SolrStream(url, localParams);
                solrStream.setSlice(slice.getName());
                solrStream.setCheckpoint(checkpoint);
                solrStream.setTrace(true);
                if (this.streamContext != null) {
                    solrStream.setStreamContext(this.streamContext);
                }
                this.solrStreams.add(solrStream);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

