/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.ExprId$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation$;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00153Q!\u0001\u0002\u0002\u0002=\u0011\u0001\u0002\u00157b]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ\u0001\u001d7b]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0015!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0011\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011\u0011D\u0006\u0002\u0010!J,G-[2bi\u0016DU\r\u001c9fe\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\u0006A\u0001!\t\"I\u0001\u0011]>\u0014X.\u00197ju\u0016,\u0005\u0010\u001d:JIN$\"A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\u0012\u0011a\u00027pO&\u001c\u0017\r\\\u0005\u0003O\u0011\u00121\u0002T8hS\u000e\fG\u000e\u00157b]\")\u0011f\ba\u0001E\u0005!\u0001\u000f\\1o\u0011\u0015Y\u0003\u0001\"\u0003-\u00035qwN]7bY&TX\r\u00157b]R\u0011!%\f\u0005\u0006S)\u0002\rA\t\u0005\u0006_\u0001!\t\u0002M\u0001\rG>l\u0007/\u0019:f!2\fgn\u001d\u000b\u0004c]J\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$\u0001B+oSRDQ\u0001\u000f\u0018A\u0002\t\nQ\u0001\u001d7b]FBQA\u000f\u0018A\u0002\t\nQ\u0001\u001d7b]JBQ\u0001\u0010\u0001\u0005\u0012u\n!cY8na\u0006\u0014X-\u0012=qe\u0016\u001c8/[8ogR\u0019\u0011GP\"\t\u000b}Z\u0004\u0019\u0001!\u0002\u0005\u0015\f\u0004CA\u000bB\u0013\t\u0011eC\u0001\u0006FqB\u0014Xm]:j_:DQ\u0001R\u001eA\u0002\u0001\u000b!!\u001a\u001a")
public abstract class PlanTest
extends SparkFunSuite
implements PredicateHelper {
    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitConjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitDisjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.class.replaceAlias((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.class.canEvaluate((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return (LogicalPlan)plan.transformAllExpressions((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ScalarSubquery) {
                    ScalarSubquery scalarSubquery = (ScalarSubquery)A1;
                    object = new ScalarSubquery(scalarSubquery.query(), ExprId$.MODULE$.apply(0L));
                } else if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    String x$2 = attributeReference.name();
                    DataType x$3 = attributeReference.dataType();
                    boolean x$4 = attributeReference.nullable();
                    Metadata x$5 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$6 = ExprId$.MODULE$.apply(0L);
                    Option x$7 = AttributeReference$.MODULE$.apply$default$6(x$2, x$3, x$4, x$5);
                    Boolean x$8 = AttributeReference$.MODULE$.apply$default$7(x$2, x$3, x$4, x$5);
                    object = new AttributeReference(x$2, x$3, x$4, x$5, x$6, x$7, x$8);
                } else if (A1 instanceof Alias) {
                    Alias alias = (Alias)A1;
                    Expression x$9 = alias.child();
                    String x$10 = alias.name();
                    ExprId x$11 = ExprId$.MODULE$.apply(0L);
                    Option x$12 = Alias$.MODULE$.apply$default$4(x$9, x$10);
                    Option x$13 = Alias$.MODULE$.apply$default$5(x$9, x$10);
                    Boolean x$14 = Alias$.MODULE$.apply$default$6(x$9, x$10);
                    object = new Alias(x$9, x$10, x$11, x$12, x$13, x$14);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof ScalarSubquery ? true : (expression instanceof AttributeReference ? true : expression instanceof Alias);
                return bl;
            }
        });
    }

    private LogicalPlan normalizePlan(LogicalPlan plan) {
        return (LogicalPlan)plan.transform((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Filter) {
                    Filter filter = (Filter)A1;
                    Expression condition = filter.condition();
                    LogicalPlan child = filter.child();
                    if (condition != null) {
                        Expression expression = condition;
                        if (child != null) {
                            LogicalPlan logicalPlan = child;
                            object = new Filter((Expression)((TraversableOnce)this.$outer.splitConjunctivePredicates(expression).sortBy((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Expression x$1) {
                                    return x$1.hashCode();
                                }
                            }, (Ordering)Ordering.Int$.MODULE$)).reduce((Function2)And$.MODULE$), logicalPlan);
                            return (B1)object;
                        }
                    }
                }
                if (A1 instanceof Sample) {
                    Sample sample = (Sample)A1;
                    long x$15 = 0L;
                    double x$16 = sample.copy$default$1();
                    double x$17 = sample.copy$default$2();
                    boolean x$18 = sample.copy$default$3();
                    LogicalPlan x$19 = sample.copy$default$5();
                    Boolean x$20 = Predef$.MODULE$.boolean2Boolean(true);
                    object = sample.copy(x$16, x$17, x$18, x$15, x$19, x$20);
                    return (B1)object;
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x2) {
                LogicalPlan logicalPlan = x2;
                if (logicalPlan instanceof Filter) {
                    Filter filter = (Filter)logicalPlan;
                    Expression condition = filter.condition();
                    LogicalPlan child = filter.child();
                    if (condition != null && child != null) {
                        return true;
                    }
                }
                if (!(logicalPlan instanceof Sample)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2) {
        LogicalPlan normalized1 = this.normalizePlan(this.normalizeExprIds(plan1));
        LogicalPlan normalized2 = this.normalizePlan(this.normalizeExprIds(plan2));
        LogicalPlan logicalPlan = normalized1;
        LogicalPlan logicalPlan2 = normalized2;
        if (!(logicalPlan != null ? !logicalPlan.equals(logicalPlan2) : logicalPlan2 != null)) {
            return;
        }
        throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |== FAIL: Plans do not match ===\n          |", "\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.sideBySide(normalized1.treeString(), normalized2.treeString()).mkString("\n")})))).stripMargin());
    }

    public void compareExpressions(Expression e1, Expression e2) {
        this.comparePlans((LogicalPlan)new Filter(e1, (LogicalPlan)OneRowRelation$.MODULE$), (LogicalPlan)new Filter(e2, (LogicalPlan)OneRowRelation$.MODULE$));
    }

    public PlanTest() {
        PredicateHelper.class.$init$((PredicateHelper)this);
    }
}

